/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.AnalyticsRequest;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.AppInfo;
import com.stripe.android.ErrorParser;
import com.stripe.android.FingerprintRequestFactory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.StripeApiRequestExecutor;
import com.stripe.android.StripeError;
import com.stripe.android.StripeFireAndForgetRequestExecutor;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeRepository;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.UidParamsFactory;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Token;
import com.stripe.android.utils.ObjectUtils;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 v2\u00020\u0001:\u0003vwxB9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ@\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J8\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J&\u0010!\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001dH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u00020#2\u0006\u00100\u001a\u000201H\u0002J\u001c\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016032\u0006\u00104\u001a\u00020\u0016H\u0002J\u001a\u00105\u001a\u0004\u0018\u00010\u001f2\u0006\u00106\u001a\u0002072\u0006\u0010*\u001a\u00020\u001dH\u0016J\u001a\u00108\u001a\u0004\u0018\u00010\u00142\u0006\u00109\u001a\u00020:2\u0006\u0010*\u001a\u00020\u001dH\u0016J,\u0010;\u001a\u0004\u0018\u00010<2\u0010\u0010=\u001a\f\u0012\u0004\u0012\u00020\u0016\u0012\u0002\b\u0003032\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u0016H\u0016J8\u0010?\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J0\u0010@\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00160BH\u0002J$\u0010C\u001a\u00020#2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020E032\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J\b\u0010F\u001a\u00020#H\u0002J\u0010\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0007J<\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J$\u0010M\u001a\u00020#2\b\u0010N\u001a\u0004\u0018\u00010\u00162\u0006\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010R\u001a\u0004\u0018\u00010S2\f\u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0002J\u0010\u0010U\u001a\u0002012\u0006\u0010V\u001a\u00020IH\u0007J\u0010\u0010W\u001a\u00020#2\u0006\u0010V\u001a\u00020XH\u0002J\u001e\u0010Y\u001a\u0004\u0018\u00010Z2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0002\b\u0003\u0018\u000103H\u0002J,\u0010\\\u001a\u0004\u0018\u00010<2\u0006\u0010]\u001a\u00020\u00162\u0010\u0010^\u001a\f\u0012\u0004\u0012\u00020\u0016\u0012\u0002\b\u0003032\u0006\u0010*\u001a\u00020\u001dH\u0002J\u001c\u0010_\u001a\u00020#2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00160BH\u0002J\u001a\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010c\u001a\u00020\u00162\u0006\u0010d\u001a\u00020\u00162\u0006\u0010e\u001a\u00020\u00162\u0006\u0010f\u001a\u00020\u00162\u0006\u0010g\u001a\u00020\u0016H\u0016J\u001a\u0010h\u001a\u0004\u0018\u00010'2\u0006\u00104\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001dH\u0016J\u001a\u0010i\u001a\u0004\u0018\u00010,2\u0006\u00104\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001dH\u0016J\"\u0010j\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001dH\u0016J8\u0010k\u001a\u0004\u0018\u00010b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010l\u001a\u00020m2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J@\u0010n\u001a\u0004\u0018\u00010b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J.\u0010o\u001a\u00020#2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020p0%H\u0016J0\u0010t\u001a\u00020#2\u0006\u0010d\u001a\u00020\u00162\u0006\u0010u\u001a\u00020\u00162\u0006\u0010e\u001a\u00020\u00162\u0006\u0010f\u001a\u00020\u00162\u0006\u0010g\u001a\u00020\u0016H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lcom/stripe/android/StripeApiRepository;", "Lcom/stripe/android/StripeRepository;", "context", "Landroid/content/Context;", "appInfo", "Lcom/stripe/android/AppInfo;", "stripeApiRequestExecutor", "Lcom/stripe/android/ApiRequestExecutor;", "fireAndForgetRequestExecutor", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "fingerprintRequestFactory", "Lcom/stripe/android/FingerprintRequestFactory;", "(Landroid/content/Context;Lcom/stripe/android/AppInfo;Lcom/stripe/android/ApiRequestExecutor;Lcom/stripe/android/FireAndForgetRequestExecutor;Lcom/stripe/android/FingerprintRequestFactory;)V", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "networkUtils", "Lcom/stripe/android/StripeNetworkUtils;", "uidParamsFactory", "Lcom/stripe/android/UidParamsFactory;", "addCustomerSource", "Lcom/stripe/android/model/Source;", "customerId", "", "publishableKey", "productUsageTokens", "", "sourceId", "sourceType", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "attachPaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "complete3ds2Auth", "", "", "callback", "Lcom/stripe/android/ApiResultCallback;", "confirmPaymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "options", "confirmSetupIntent", "Lcom/stripe/android/model/SetupIntent;", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "convertErrorsToExceptionsAndThrowIfNecessary", "response", "Lcom/stripe/android/StripeResponse;", "createClientSecretParam", "", "clientSecret", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "createToken", "Lcom/stripe/android/model/Token;", "tokenParams", "tokenType", "deleteCustomerSource", "detachPaymentMethod", "disableDnsCache", "Landroid/util/Pair;", "fireAnalyticsRequest", "loggingMap", "", "fireFingerprintRequest", "fireStripeApiRequest", "apiRequest", "Lcom/stripe/android/ApiRequest;", "getDetachPaymentMethodUrl", "getPaymentMethods", "paymentMethodType", "handleAPIError", "responseBody", "responseCode", "", "requestId", "listToJsonArray", "Lorg/json/JSONArray;", "values", "makeApiRequest", "request", "makeFireAndForgetRequest", "Lcom/stripe/android/StripeRequest;", "mapToJsonObject", "Lorg/json/JSONObject;", "mapObject", "requestToken", "url", "params", "resetDnsCacheTtl", "dnsCacheData", "retrieveCustomer", "Lcom/stripe/android/model/Customer;", "retrieveIssuingCardPin", "cardId", "verificationId", "userOneTimeCode", "ephemeralKeySecret", "retrievePaymentIntent", "retrieveSetupIntent", "retrieveSource", "setCustomerShippingInfo", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "setDefaultCustomerSource", "start3ds2Auth", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "authParams", "Lcom/stripe/android/Stripe3ds2AuthParams;", "stripeIntentId", "updateIssuingCardPin", "newPin", "Companion", "Complete3ds2AuthTask", "Start3ds2AuthTask", "stripe_release"})
public final class StripeApiRepository
implements StripeRepository {
    private final AnalyticsDataFactory analyticsDataFactory;
    private final StripeNetworkUtils networkUtils;
    private final UidParamsFactory uidParamsFactory;
    private final AppInfo appInfo;
    private final ApiRequestExecutor stripeApiRequestExecutor;
    private final FireAndForgetRequestExecutor fireAndForgetRequestExecutor;
    private final FingerprintRequestFactory fingerprintRequestFactory;
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public PaymentIntent confirmPaymentIntent(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Map<String, Object> map = confirmPaymentIntentParams.toParamMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"confirmPaymentIntentParams.toParamMap()");
        Map<String, Object> paramMap = map;
        this.networkUtils.addUidToConfirmPaymentIntentParams(paramMap);
        try {
            SourceParams sourceParams;
            this.fireFingerprintRequest();
            SourceParams sourceParams2 = sourceParams = confirmPaymentIntentParams.getSourceParams();
            String sourceType = sourceParams2 != null ? sourceParams2.getType() : null;
            String string2 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"options.apiKey");
            Map<String, Object> map2 = this.analyticsDataFactory.getPaymentIntentConfirmationParams(null, string2, sourceType);
            String string3 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"options.apiKey");
            this.fireAnalyticsRequest(map2, string3);
            String string4 = PaymentIntent.parseIdFromClientSecret(confirmPaymentIntentParams.getClientSecret());
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"PaymentIntent.parseIdFro\u2026ntentParams.clientSecret)");
            String paymentIntentId = string4;
            ApiRequest apiRequest = ApiRequest.createPost(Companion.getConfirmPaymentIntentUrl(paymentIntentId), paramMap, options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026ramMap, options, appInfo)");
            StripeResponse response = this.makeApiRequest(apiRequest);
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public PaymentIntent retrievePaymentIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        try {
            this.fireFingerprintRequest();
            String string2 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"options.apiKey");
            Map<String, Object> map = this.analyticsDataFactory.getPaymentIntentRetrieveParams(null, string2);
            String string3 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"options.apiKey");
            this.fireAnalyticsRequest(map, string3);
            String string4 = PaymentIntent.parseIdFromClientSecret(clientSecret);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"PaymentIntent.parseIdFro\u2026lientSecret(clientSecret)");
            String paymentIntentId = string4;
            ApiRequest apiRequest = ApiRequest.createGet(Companion.getRetrievePaymentIntentUrl(paymentIntentId), this.createClientSecretParam(clientSecret), options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createGet(get\u2026                 appInfo)");
            StripeResponse response = this.makeApiRequest(apiRequest);
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent confirmSetupIntent(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Map<String, Object> map = confirmSetupIntentParams.toParamMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"confirmSetupIntentParams.toParamMap()");
        Map<String, Object> paramMap = map;
        this.networkUtils.addUidToConfirmPaymentIntentParams(paramMap);
        try {
            this.fireFingerprintRequest();
            String string2 = SetupIntent.parseIdFromClientSecret(confirmSetupIntentParams.getClientSecret());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SetupIntent.parseIdFromC\u2026ntentParams.clientSecret)");
            String setupIntentId = string2;
            ApiRequest apiRequest = ApiRequest.createPost(Companion.getConfirmSetupIntentUrl(setupIntentId), paramMap, options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026appInfo\n                )");
            StripeResponse response = this.makeApiRequest(apiRequest);
            SetupIntent setupIntent = SetupIntent.fromString(response.getResponseBody());
            String string3 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"options.apiKey");
            PaymentMethodCreateParams paymentMethodCreateParams = confirmSetupIntentParams.getPaymentMethodCreateParams();
            Map<String, Object> map2 = this.analyticsDataFactory.getSetupIntentConfirmationParams(string3, paymentMethodCreateParams != null ? paymentMethodCreateParams.getTypeCode() : null);
            String string4 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"options.apiKey");
            this.fireAnalyticsRequest(map2, string4);
            return setupIntent;
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent retrieveSetupIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        try {
            this.fireFingerprintRequest();
            String string2 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"options.apiKey");
            Map<String, Object> map = this.analyticsDataFactory.getSetupIntentRetrieveParams(string2);
            String string3 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"options.apiKey");
            this.fireAnalyticsRequest(map, string3);
            String string4 = SetupIntent.parseIdFromClientSecret(clientSecret);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"SetupIntent.parseIdFromClientSecret(clientSecret)");
            String setupIntentId = string4;
            ApiRequest apiRequest = ApiRequest.createGet(Companion.getRetrieveSetupIntentUrl(setupIntentId), this.createClientSecretParam(clientSecret), options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createGet(\n  \u2026appInfo\n                )");
            StripeResponse response = this.makeApiRequest(apiRequest);
            return SetupIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public Source createSource(@NotNull SourceParams sourceParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        try {
            this.fireFingerprintRequest();
            String string2 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"options.apiKey");
            String string3 = sourceParams.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sourceParams.type");
            Map<String, Object> map = this.analyticsDataFactory.getSourceCreationParams(null, string2, string3);
            String string4 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"options.apiKey");
            this.fireAnalyticsRequest(map, string4);
            String string5 = Companion.getSourcesUrl();
            Map<String, Object> map2 = sourceParams.toParamMap();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"sourceParams.toParamMap()");
            ApiRequest apiRequest = ApiRequest.createPost(string5, MapsKt.plus(map2, this.uidParamsFactory.createParams()), options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026appInfo\n                )");
            StripeResponse response = this.makeApiRequest(apiRequest);
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public Source retrieveSource(@NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        try {
            ApiRequest apiRequest = ApiRequest.createGet(Companion.getRetrieveSourceApiUrl(sourceId), SourceParams.createRetrieveSourceParams(clientSecret), options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createGet(\n  \u2026appInfo\n                )");
            StripeResponse response = this.makeApiRequest(apiRequest);
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public PaymentMethod createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        try {
            String string2 = Companion.getPaymentMethodsUrl();
            Map<String, Object> map = paymentMethodCreateParams.toParamMap();
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"paymentMethodCreateParams.toParamMap()");
            ApiRequest apiRequest = ApiRequest.createPost(string2, MapsKt.plus(map, this.uidParamsFactory.createParams()), options, this.appInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026appInfo\n                )");
            StripeResponse response = this.makeApiRequest(apiRequest);
            PaymentMethod paymentMethod = PaymentMethod.fromString(response.getResponseBody());
            String string3 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"options.apiKey");
            PaymentMethod paymentMethod2 = paymentMethod;
            Map<String, Object> map2 = this.analyticsDataFactory.createPaymentMethodCreationParams(string3, paymentMethod2 != null ? paymentMethod2.id : null);
            String string4 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"options.apiKey");
            this.fireAnalyticsRequest(map2, string4);
            return paymentMethod;
        }
        catch (CardException unexpected) {
            throw (Throwable)new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Override
    @Nullable
    public Token createToken(@NotNull Map<String, ?> tokenParams, @NotNull ApiRequest.Options options, @NotNull String tokenType) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull(tokenParams, (String)"tokenParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)tokenType, (String)"tokenType");
        try {
            this.fireFingerprintRequest();
            List list = (List)tokenParams.get("product_usage");
            String string2 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"options.apiKey");
            Map<String, Object> map = this.analyticsDataFactory.getTokenCreationParams(list, string2, tokenType);
            String string3 = options.apiKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"options.apiKey");
            this.fireAnalyticsRequest(map, string3);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.requestToken(Companion.getTokensUrl(), MapsKt.minus(tokenParams, (Object)"product_usage"), options);
    }

    @Override
    @Nullable
    public Source addCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(this.analyticsDataFactory.getAddSourceParams(productUsageTokens, publishableKey, sourceType), publishableKey);
        ApiRequest apiRequest = ApiRequest.createPost(Companion.getAddCustomerSourceUrl(customerId), MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId)), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026    appInfo\n            )");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Override
    @Nullable
    public Source deleteCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(this.analyticsDataFactory.getDeleteSourceParams(productUsageTokens, publishableKey), publishableKey);
        ApiRequest apiRequest = ApiRequest.createDelete(Companion.getDeleteCustomerSourceUrl(customerId, sourceId), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createDelete(\u2026 requestOptions, appInfo)");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Override
    @Nullable
    public PaymentMethod attachPaymentMethod(@NotNull String customerId, @NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(this.analyticsDataFactory.getAttachPaymentMethodParams(productUsageTokens, publishableKey), publishableKey);
        ApiRequest apiRequest = ApiRequest.createPost(Companion.getAttachPaymentMethodUrl(paymentMethodId), MapsKt.mapOf((Pair)TuplesKt.to((Object)"customer", (Object)customerId)), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026ns, appInfo\n            )");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return PaymentMethod.fromString(response.getResponseBody());
    }

    @Override
    @Nullable
    public PaymentMethod detachPaymentMethod(@NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(this.analyticsDataFactory.getDetachPaymentMethodParams(productUsageTokens, publishableKey), publishableKey);
        ApiRequest apiRequest = ApiRequest.createPost(this.getDetachPaymentMethodUrl(paymentMethodId), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026 requestOptions, appInfo)");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return PaymentMethod.fromString(response.getResponseBody());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PaymentMethod> getPaymentMethods(@NotNull String customerId, @NotNull String paymentMethodType, @NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodType, (String)"paymentMethodType");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Map queryParams = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"customer", (Object)customerId), TuplesKt.to((Object)"type", (Object)paymentMethodType)});
        this.fireAnalyticsRequest(this.analyticsDataFactory.getDetachPaymentMethodParams(productUsageTokens, publishableKey), publishableKey);
        ApiRequest apiRequest = ApiRequest.createGet(Companion.getPaymentMethodsUrl(), queryParams, requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createGet(\n  \u2026 requestOptions, appInfo)");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        JSONArray data = null;
        try {
            JSONArray jSONArray = new JSONObject(response.getResponseBody()).optJSONArray("data");
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONArray, (String)"JSONObject(response.resp\u2026ody).optJSONArray(\"data\")");
            data = jSONArray;
        }
        catch (JSONException e) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)data.length());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PaymentMethod paymentMethod;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            if (PaymentMethod.fromJson(data.optJSONObject(it)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PaymentMethod it$iv$iv = paymentMethod;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Customer setDefaultCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(AnalyticsDataFactory.getEventLoggingParams$default(this.analyticsDataFactory, "default_source", publishableKey, productUsageTokens, sourceType, null, 16, null), publishableKey);
        ApiRequest apiRequest = ApiRequest.createPost(Companion.getRetrieveCustomerUrl(customerId), MapsKt.mapOf((Pair)TuplesKt.to((Object)"default_source", (Object)sourceId)), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026    appInfo\n            )");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Override
    @Nullable
    public Customer setCustomerShippingInfo(@NotNull String customerId, @NotNull String publishableKey, @NotNull List<String> productUsageTokens, @NotNull ShippingInformation shippingInformation, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(AnalyticsDataFactory.getEventLoggingParams$default(this.analyticsDataFactory, "set_shipping_info", publishableKey, productUsageTokens, null, null, 24, null), publishableKey);
        ApiRequest apiRequest = ApiRequest.createPost(Companion.getRetrieveCustomerUrl(customerId), MapsKt.mapOf((Pair)TuplesKt.to((Object)"shipping", shippingInformation.toParamMap())), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026 requestOptions, appInfo)");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Override
    @Nullable
    public Customer retrieveCustomer(@NotNull String customerId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        ApiRequest apiRequest = ApiRequest.createGet(Companion.getRetrieveCustomerUrl(customerId), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createGet(get\u2026 requestOptions, appInfo)");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Override
    @NotNull
    public String retrieveIssuingCardPin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException, JSONException {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        ApiRequest apiRequest = ApiRequest.createGet(Companion.getIssuingCardPinUrl(cardId), MapsKt.mapOf((Pair)TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode))), ApiRequest.Options.create(ephemeralKeySecret), this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createGet(\n  \u2026    appInfo\n            )");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        JSONObject jsonResponse = new JSONObject(response.getResponseBody());
        String string2 = jsonResponse.getString("pin");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jsonResponse.getString(\"pin\")");
        return string2;
    }

    @Override
    public void updateIssuingCardPin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)newPin, (String)"newPin");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        ApiRequest apiRequest = ApiRequest.createPost(Companion.getIssuingCardPinUrl(cardId), MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode)), TuplesKt.to((Object)"pin", (Object)newPin)}), ApiRequest.Options.create(ephemeralKeySecret), this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026meralKeySecret), appInfo)");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
    }

    @VisibleForTesting
    @NotNull
    public final Stripe3ds2AuthResult start3ds2Auth(@NotNull Stripe3ds2AuthParams authParams, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException, JSONException {
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        String string2 = requestOptions.apiKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"requestOptions.apiKey");
        Map<String, Object> map = this.analyticsDataFactory.createAuthParams("3ds2_authenticate", stripeIntentId, string2);
        String string3 = requestOptions.apiKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"requestOptions.apiKey");
        this.fireAnalyticsRequest(map, string3);
        ApiRequest apiRequest = ApiRequest.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/authenticate"), authParams.toParamMap(), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026    appInfo\n            )");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Stripe3ds2AuthResult.Companion.fromJson(new JSONObject(response.getResponseBody()));
    }

    @Override
    public void start3ds2Auth(@NotNull Stripe3ds2AuthParams authParams, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new Start3ds2AuthTask(this, authParams, stripeIntentId, requestOptions, callback).execute(new Void[0]);
    }

    @VisibleForTesting
    public final boolean complete3ds2Auth(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        ApiRequest apiRequest = ApiRequest.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/challenge_complete"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId)), requestOptions, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(\n \u2026    appInfo\n            )");
        StripeResponse response = this.fireStripeApiRequest(apiRequest);
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return response.isOk();
    }

    @Override
    public void complete3ds2Auth(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Boolean> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new Complete3ds2AuthTask(this, sourceId, requestOptions, callback).execute(new Void[0]);
    }

    @VisibleForTesting
    @NotNull
    public final String getDetachPaymentMethodUrl(@NotNull String paymentMethodId) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        return StripeApiRepository.Companion.getApiUrl("payment_methods/%s/detach", paymentMethodId);
    }

    private final void convertErrorsToExceptionsAndThrowIfNecessary(StripeResponse response) throws InvalidRequestException, APIException, AuthenticationException, CardException {
        String requestId;
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        Map<String, List<String>> map = response.getResponseHeaders();
        String string2 = map != null && (map = map.get("Request-Id")) != null ? (String)CollectionsKt.firstOrNull((List)((Object)map)) : (requestId = null);
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode, requestId);
        }
    }

    private final JSONObject mapToJsonObject(Map<String, ?> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            if (mapObject.get(key) == null) {
                continue;
            }
            try {
                Object value;
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)this.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)this.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    private final JSONArray listToJsonArray(List<?> values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                jsonArray.put((Object)this.mapToJsonObject(mapObject));
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)this.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)String.valueOf(object));
        }
        return jsonArray;
    }

    private final StripeResponse fireStripeApiRequest(ApiRequest apiRequest) throws InvalidRequestException, APIConnectionException {
        return this.stripeApiRequestExecutor.execute(apiRequest);
    }

    private final void handleAPIError(String responseBody, int responseCode, String requestId) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        StripeError stripeError = ErrorParser.parseError(responseBody);
        switch (responseCode) {
            case 400: 
            case 404: {
                throw (Throwable)new InvalidRequestException(stripeError.message, stripeError.param, requestId, responseCode, stripeError.code, stripeError.declineCode, stripeError, null);
            }
            case 401: {
                throw (Throwable)new AuthenticationException(stripeError.message, requestId, stripeError);
            }
            case 402: {
                throw (Throwable)new CardException(stripeError.message, requestId, stripeError.code, stripeError.param, stripeError.declineCode, stripeError.charge, stripeError);
            }
            case 403: {
                throw (Throwable)new PermissionException(stripeError.message, requestId, stripeError);
            }
            case 429: {
                throw (Throwable)new RateLimitException(stripeError.message, stripeError.param, requestId, stripeError);
            }
        }
        throw (Throwable)new APIException(stripeError.message, requestId, responseCode, stripeError, null);
    }

    @VisibleForTesting
    @NotNull
    public final StripeResponse makeApiRequest(@NotNull ApiRequest request) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        android.util.Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        StripeResponse response = this.fireStripeApiRequest(request);
        if (response.hasErrorCode()) {
            this.handleAPIError(response.getResponseBody(), response.getResponseCode(), response.getRequestId());
        }
        this.resetDnsCacheTtl(dnsCacheData);
        return response;
    }

    private final void makeFireAndForgetRequest(StripeRequest request) {
        this.fireAndForgetRequestExecutor.executeAsync(request);
    }

    private final android.util.Pair<Boolean, String> disableDnsCache() {
        android.util.Pair pair;
        try {
            String originalDNSCacheTtl = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
            android.util.Pair pair2 = android.util.Pair.create((Object)true, (Object)originalDNSCacheTtl);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(true, originalDNSCacheTtl)");
            pair = pair2;
        }
        catch (SecurityException se) {
            android.util.Pair pair3 = android.util.Pair.create((Object)false, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create(false, null)");
            pair = pair3;
        }
        return pair;
    }

    private final void resetDnsCacheTtl(android.util.Pair<Boolean, String> dnsCacheData) {
        Object object = dnsCacheData.first;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dnsCacheData.first");
        if (((Boolean)object).booleanValue()) {
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, ObjectUtils.getOrDefault(dnsCacheData.second, "-1"));
        }
    }

    private final Token requestToken(String url, Map<String, ?> params, ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        ApiRequest apiRequest = ApiRequest.createPost(url, params, options, this.appInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)apiRequest, (String)"ApiRequest.createPost(ur\u2026params, options, appInfo)");
        StripeResponse response = this.makeApiRequest(apiRequest);
        return Token.fromString(response.getResponseBody());
    }

    private final void fireFingerprintRequest() {
        this.makeFireAndForgetRequest(this.fingerprintRequestFactory.create());
    }

    @VisibleForTesting
    public final void fireAnalyticsRequest(@NotNull Map<String, ? extends Object> loggingMap, @NotNull String publishableKey) {
        Intrinsics.checkParameterIsNotNull(loggingMap, (String)"loggingMap");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        ApiRequest.Options options = ApiRequest.Options.create(publishableKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)options, (String)"ApiRequest.Options.create(publishableKey)");
        this.makeFireAndForgetRequest(AnalyticsRequest.create(loggingMap, options, this.appInfo));
    }

    private final Map<String, String> createClientSecretParam(String clientSecret) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"client_secret", (Object)clientSecret));
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)fireAndForgetRequestExecutor, (String)"fireAndForgetRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)fingerprintRequestFactory, (String)"fingerprintRequestFactory");
        this.appInfo = appInfo;
        this.stripeApiRequestExecutor = stripeApiRequestExecutor;
        this.fireAndForgetRequestExecutor = fireAndForgetRequestExecutor;
        this.fingerprintRequestFactory = fingerprintRequestFactory;
        this.analyticsDataFactory = AnalyticsDataFactory.Companion.create(context);
        this.networkUtils = new StripeNetworkUtils(context);
        this.uidParamsFactory = UidParamsFactory.Companion.create(context);
    }

    public /* synthetic */ StripeApiRepository(Context context, AppInfo appInfo, ApiRequestExecutor apiRequestExecutor, FireAndForgetRequestExecutor fireAndForgetRequestExecutor, FingerprintRequestFactory fingerprintRequestFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            appInfo = null;
        }
        if ((n & 4) != 0) {
            apiRequestExecutor = new StripeApiRequestExecutor();
        }
        if ((n & 8) != 0) {
            fireAndForgetRequestExecutor = new StripeFireAndForgetRequestExecutor();
        }
        if ((n & 0x10) != 0) {
            fingerprintRequestFactory = new FingerprintRequestFactory(context);
        }
        this(context, appInfo, apiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor) {
        this(context, appInfo, stripeApiRequestExecutor, fireAndForgetRequestExecutor, null, 16, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull ApiRequestExecutor stripeApiRequestExecutor) {
        this(context, appInfo, stripeApiRequestExecutor, null, null, 24, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo) {
        this(context, appInfo, null, null, null, 28, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context) {
        this(context, null, null, null, null, 30, null);
    }

    @NotNull
    public static final String getTokensUrl() {
        return Companion.getTokensUrl();
    }

    @VisibleForTesting
    @NotNull
    public static final String getSourcesUrl() {
        return Companion.getSourcesUrl();
    }

    @VisibleForTesting
    @NotNull
    public static final String getPaymentMethodsUrl() {
        return Companion.getPaymentMethodsUrl();
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getRetrievePaymentIntentUrl(@NotNull String paymentIntentId) {
        return Companion.getRetrievePaymentIntentUrl(paymentIntentId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getConfirmPaymentIntentUrl(@NotNull String paymentIntentId) {
        return Companion.getConfirmPaymentIntentUrl(paymentIntentId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getRetrieveSetupIntentUrl(@NotNull String setupIntentId) {
        return Companion.getRetrieveSetupIntentUrl(setupIntentId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getConfirmSetupIntentUrl(@NotNull String setupIntentId) {
        return Companion.getConfirmSetupIntentUrl(setupIntentId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getAddCustomerSourceUrl(@NotNull String customerId) {
        return Companion.getAddCustomerSourceUrl(customerId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getDeleteCustomerSourceUrl(@NotNull String customerId, @NotNull String sourceId) {
        return Companion.getDeleteCustomerSourceUrl(customerId, sourceId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getAttachPaymentMethodUrl(@NotNull String paymentMethodId) {
        return Companion.getAttachPaymentMethodUrl(paymentMethodId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getRetrieveCustomerUrl(@NotNull String customerId) {
        return Companion.getRetrieveCustomerUrl(customerId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getRetrieveSourceApiUrl(@NotNull String sourceId) {
        return Companion.getRetrieveSourceApiUrl(sourceId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getRetrieveTokenApiUrl(@NotNull String tokenId) {
        return Companion.getRetrieveTokenApiUrl(tokenId);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getIssuingCardPinUrl(@NotNull String cardId) {
        return Companion.getIssuingCardPinUrl(cardId);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/StripeApiRepository$Start3ds2AuthTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "mStripeApiRepository", "Lcom/stripe/android/StripeApiRepository;", "mParams", "Lcom/stripe/android/Stripe3ds2AuthParams;", "mStripeIntentId", "", "mRequestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeApiRepository;Lcom/stripe/android/Stripe3ds2AuthParams;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "stripe_release"})
    private static final class Start3ds2AuthTask
    extends ApiOperation<Stripe3ds2AuthResult> {
        private final StripeApiRepository mStripeApiRepository;
        private final Stripe3ds2AuthParams mParams;
        private final String mStripeIntentId;
        private final ApiRequest.Options mRequestOptions;

        @NotNull
        public Stripe3ds2AuthResult getResult$stripe_release() throws StripeException, JSONException {
            return this.mStripeApiRepository.start3ds2Auth(this.mParams, this.mStripeIntentId, this.mRequestOptions);
        }

        public Start3ds2AuthTask(@NotNull StripeApiRepository mStripeApiRepository, @NotNull Stripe3ds2AuthParams mParams, @NotNull String mStripeIntentId, @NotNull ApiRequest.Options mRequestOptions, @NotNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
            Intrinsics.checkParameterIsNotNull((Object)mStripeApiRepository, (String)"mStripeApiRepository");
            Intrinsics.checkParameterIsNotNull((Object)mParams, (String)"mParams");
            Intrinsics.checkParameterIsNotNull((Object)mStripeIntentId, (String)"mStripeIntentId");
            Intrinsics.checkParameterIsNotNull((Object)mRequestOptions, (String)"mRequestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.mStripeApiRepository = mStripeApiRepository;
            this.mParams = mParams;
            this.mStripeIntentId = mStripeIntentId;
            this.mRequestOptions = mRequestOptions;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/StripeApiRepository$Complete3ds2AuthTask;", "Lcom/stripe/android/ApiOperation;", "", "mStripeApiRepository", "Lcom/stripe/android/StripeApiRepository;", "mSourceId", "", "mRequestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeApiRepository;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "()Ljava/lang/Boolean;", "stripe_release"})
    private static final class Complete3ds2AuthTask
    extends ApiOperation<Boolean> {
        private final StripeApiRepository mStripeApiRepository;
        private final String mSourceId;
        private final ApiRequest.Options mRequestOptions;

        @NotNull
        public Boolean getResult$stripe_release() throws StripeException {
            return this.mStripeApiRepository.complete3ds2Auth(this.mSourceId, this.mRequestOptions);
        }

        public Complete3ds2AuthTask(@NotNull StripeApiRepository mStripeApiRepository, @NotNull String mSourceId, @NotNull ApiRequest.Options mRequestOptions, @NotNull ApiResultCallback<Boolean> callback) {
            Intrinsics.checkParameterIsNotNull((Object)mStripeApiRepository, (String)"mStripeApiRepository");
            Intrinsics.checkParameterIsNotNull((Object)mSourceId, (String)"mSourceId");
            Intrinsics.checkParameterIsNotNull((Object)mRequestOptions, (String)"mRequestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.mStripeApiRepository = mStripeApiRepository;
            this.mSourceId = mSourceId;
            this.mRequestOptions = mRequestOptions;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J)\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0018\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0007J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\b\u00a8\u0006*"}, d2={"Lcom/stripe/android/StripeApiRepository$Companion;", "", "()V", "DNS_CACHE_TTL_PROPERTY_NAME", "", "paymentMethodsUrl", "paymentMethodsUrl$annotations", "getPaymentMethodsUrl", "()Ljava/lang/String;", "sourcesUrl", "sourcesUrl$annotations", "getSourcesUrl", "tokensUrl", "tokensUrl$annotations", "getTokensUrl", "createVerificationParam", "", "verificationId", "userOneTimeCode", "getAddCustomerSourceUrl", "customerId", "getApiUrl", "path", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getAttachPaymentMethodUrl", "paymentMethodId", "getConfirmPaymentIntentUrl", "paymentIntentId", "getConfirmSetupIntentUrl", "setupIntentId", "getDeleteCustomerSourceUrl", "sourceId", "getIssuingCardPinUrl", "cardId", "getRetrieveCustomerUrl", "getRetrievePaymentIntentUrl", "getRetrieveSetupIntentUrl", "getRetrieveSourceApiUrl", "getRetrieveTokenApiUrl", "tokenId", "stripe_release"})
    public static final class Companion {
        private final Map<String, String> createVerificationParam(String verificationId, String userOneTimeCode) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)verificationId), TuplesKt.to((Object)"one_time_code", (Object)userOneTimeCode)});
        }

        @JvmStatic
        public static /* synthetic */ void tokensUrl$annotations() {
        }

        @NotNull
        public final String getTokensUrl() {
            return Companion.getApiUrl("tokens");
        }

        @JvmStatic
        public static /* synthetic */ void sourcesUrl$annotations() {
        }

        @VisibleForTesting
        @NotNull
        public final String getSourcesUrl() {
            return Companion.getApiUrl("sources");
        }

        @JvmStatic
        public static /* synthetic */ void paymentMethodsUrl$annotations() {
        }

        @VisibleForTesting
        @NotNull
        public final String getPaymentMethodsUrl() {
            return Companion.getApiUrl("payment_methods");
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getRetrievePaymentIntentUrl(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s", paymentIntentId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getConfirmPaymentIntentUrl(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s/confirm", paymentIntentId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getRetrieveSetupIntentUrl(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s", setupIntentId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getConfirmSetupIntentUrl(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s/confirm", setupIntentId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getAddCustomerSourceUrl(@NotNull String customerId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            return this.getApiUrl("customers/%s/sources", customerId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getDeleteCustomerSourceUrl(@NotNull String customerId, @NotNull String sourceId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            return this.getApiUrl("customers/%s/sources/%s", customerId, sourceId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getAttachPaymentMethodUrl(@NotNull String paymentMethodId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
            return this.getApiUrl("payment_methods/%s/attach", paymentMethodId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getRetrieveCustomerUrl(@NotNull String customerId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            return this.getApiUrl("customers/%s", customerId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getRetrieveSourceApiUrl(@NotNull String sourceId) {
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            return this.getApiUrl("sources/%s", sourceId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getRetrieveTokenApiUrl(@NotNull String tokenId) {
            Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
            return this.getApiUrl("tokens/%s", tokenId);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getIssuingCardPinUrl(@NotNull String cardId) {
            Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
            return this.getApiUrl("issuing/cards/%s/pin", cardId);
        }

        private final String getApiUrl(String path, Object ... args) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            Companion companion = this;
            boolean bl = false;
            String string2 = String.format(locale2, path, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            return companion.getApiUrl(string3);
        }

        private final String getApiUrl(String path) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            String string2 = "%s/v1/%s";
            Object[] objectArray = new Object[]{"https://api.stripe.com", path};
            boolean bl = false;
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            return string3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

