/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.stripe.android.CardUtils;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.R;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.ModelUtils;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class Card
extends StripeModel
implements StripePaymentSource,
StripeParamsModel {
    public static final int CVC_LENGTH_AMERICAN_EXPRESS = 4;
    public static final int CVC_LENGTH_COMMON = 3;
    public static final String[] PREFIXES_AMERICAN_EXPRESS = new String[]{"34", "37"};
    public static final String[] PREFIXES_DISCOVER = new String[]{"60", "64", "65"};
    public static final String[] PREFIXES_JCB = new String[]{"35"};
    public static final String[] PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "39"};
    public static final String[] PREFIXES_VISA = new String[]{"4"};
    public static final String[] PREFIXES_MASTERCARD = new String[]{"2221", "2222", "2223", "2224", "2225", "2226", "2227", "2228", "2229", "223", "224", "225", "226", "227", "228", "229", "23", "24", "25", "26", "270", "271", "2720", "50", "51", "52", "53", "54", "55", "67"};
    public static final String[] PREFIXES_UNIONPAY = new String[]{"62"};
    public static final int MAX_LENGTH_STANDARD = 16;
    public static final int MAX_LENGTH_AMERICAN_EXPRESS = 15;
    public static final int MAX_LENGTH_DINERS_CLUB = 14;
    static final String VALUE_CARD = "card";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ADDRESS_CITY = "address_city";
    private static final String FIELD_ADDRESS_COUNTRY = "address_country";
    private static final String FIELD_ADDRESS_LINE1 = "address_line1";
    private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
    private static final String FIELD_ADDRESS_LINE2 = "address_line2";
    private static final String FIELD_ADDRESS_STATE = "address_state";
    private static final String FIELD_ADDRESS_ZIP = "address_zip";
    private static final String FIELD_ADDRESS_ZIP_CHECK = "address_zip_check";
    private static final String FIELD_BRAND = "brand";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_CVC_CHECK = "cvc_check";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_FUNDING = "funding";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_ID = "id";
    private static final String FIELD_TOKENIZATION_METHOD = "tokenization_method";
    private static final Map<String, Integer> BRAND_RESOURCE_MAP = new HashMap<String, Integer>(){
        {
            this.put("American Express", R.drawable.ic_amex);
            this.put("Diners Club", R.drawable.ic_diners);
            this.put("Discover", R.drawable.ic_discover);
            this.put("JCB", R.drawable.ic_jcb);
            this.put("MasterCard", R.drawable.ic_mastercard);
            this.put("Visa", R.drawable.ic_visa);
            this.put("UnionPay", R.drawable.ic_unionpay);
            this.put("Unknown", R.drawable.ic_unknown);
        }
    };
    @Nullable
    private final String number;
    @Nullable
    private final String cvc;
    @Nullable
    private final Integer expMonth;
    @Nullable
    private final Integer expYear;
    @Nullable
    private final String name;
    @Nullable
    private final String addressLine1;
    @Nullable
    private final String addressLine1Check;
    @Nullable
    private final String addressLine2;
    @Nullable
    private final String addressCity;
    @Nullable
    private final String addressState;
    @Nullable
    private final String addressZip;
    @Nullable
    private final String addressZipCheck;
    @Nullable
    private final String addressCountry;
    @Nullable
    @Size(value=4L)
    private final String last4;
    @Nullable
    private final String brand;
    @Nullable
    private final String funding;
    @Nullable
    private final String fingerprint;
    @Nullable
    private final String country;
    @Nullable
    private final String currency;
    @Nullable
    private final String customerId;
    @Nullable
    private final String cvcCheck;
    @Nullable
    private final String id;
    @NonNull
    private final List<String> loggingTokens = new ArrayList<String>();
    @Nullable
    private final String tokenizationMethod;
    @Nullable
    private final Map<String, String> metadata;

    @Nullable
    public static String asCardBrand(@Nullable String possibleCardType) {
        if (possibleCardType == null || StripeTextUtils.isEmpty(possibleCardType.trim())) {
            return null;
        }
        if ("American Express".equalsIgnoreCase(possibleCardType)) {
            return "American Express";
        }
        if ("MasterCard".equalsIgnoreCase(possibleCardType)) {
            return "MasterCard";
        }
        if ("Diners Club".equalsIgnoreCase(possibleCardType)) {
            return "Diners Club";
        }
        if ("Discover".equalsIgnoreCase(possibleCardType)) {
            return "Discover";
        }
        if ("JCB".equalsIgnoreCase(possibleCardType)) {
            return "JCB";
        }
        if ("Visa".equalsIgnoreCase(possibleCardType)) {
            return "Visa";
        }
        if ("UnionPay".equalsIgnoreCase(possibleCardType)) {
            return "UnionPay";
        }
        return "Unknown";
    }

    @Nullable
    public static String asFundingType(@Nullable String possibleFundingType) {
        if (possibleFundingType == null || StripeTextUtils.isEmpty(possibleFundingType.trim())) {
            return null;
        }
        if ("credit".equalsIgnoreCase(possibleFundingType)) {
            return "credit";
        }
        if ("debit".equalsIgnoreCase(possibleFundingType)) {
            return "debit";
        }
        if ("prepaid".equalsIgnoreCase(possibleFundingType)) {
            return "prepaid";
        }
        return "unknown";
    }

    @DrawableRes
    public static int getBrandIcon(@Nullable String brand) {
        Integer brandIcon = BRAND_RESOURCE_MAP.get(brand);
        return brandIcon != null ? brandIcon : R.drawable.ic_unknown;
    }

    @Nullable
    public static Card fromString(@NonNull String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            return Card.fromJson(jsonObject);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Card fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_CARD.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        Integer expMonth = StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_MONTH);
        Integer expYear = StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_YEAR);
        if (expMonth != null && (expMonth < 1 || expMonth > 12)) {
            expMonth = null;
        }
        if (expYear != null && expYear < 0) {
            expYear = null;
        }
        return new Builder(null, expMonth, expYear, null).addressCity(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_CITY)).addressLine1(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE1)).addressLine1Check(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE1_CHECK)).addressLine2(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE2)).addressCountry(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_COUNTRY)).addressState(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_STATE)).addressZip(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_ZIP)).addressZipCheck(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_ZIP_CHECK)).brand(Card.asCardBrand(StripeJsonUtils.optString(jsonObject, FIELD_BRAND))).country(StripeJsonUtils.optCountryCode(jsonObject, FIELD_COUNTRY)).customer(StripeJsonUtils.optString(jsonObject, FIELD_CUSTOMER)).currency(StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY)).cvcCheck(StripeJsonUtils.optString(jsonObject, FIELD_CVC_CHECK)).funding(Card.asFundingType(StripeJsonUtils.optString(jsonObject, FIELD_FUNDING))).fingerprint(StripeJsonUtils.optString(jsonObject, FIELD_FINGERPRINT)).id(StripeJsonUtils.optString(jsonObject, FIELD_ID)).last4(StripeJsonUtils.optString(jsonObject, FIELD_LAST4)).name(StripeJsonUtils.optString(jsonObject, FIELD_NAME)).tokenizationMethod(StripeJsonUtils.optString(jsonObject, FIELD_TOKENIZATION_METHOD)).metadata(StripeJsonUtils.optHash(jsonObject, FIELD_METADATA)).build();
    }

    @NonNull
    public static Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
        return new Builder(number, expMonth, expYear, cvc).build();
    }

    @NonNull
    public PaymentMethodCreateParams.Card toPaymentMethodParamsCard() {
        return new PaymentMethodCreateParams.Card.Builder().setNumber(this.number).setCvc(this.cvc).setExpiryMonth(this.expMonth).setExpiryYear(this.expYear).build();
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this.number, this.expMonth, this.expYear, this.cvc).name(this.name).addressLine1(this.addressLine1).addressLine1Check(this.addressLine1Check).addressLine2(this.addressLine2).addressCity(this.addressCity).addressState(this.addressState).addressZip(this.addressZip).addressZipCheck(this.addressZipCheck).addressCountry(this.addressCountry).brand(this.brand).fingerprint(this.fingerprint).funding(this.funding).country(this.country).currency(this.currency).customer(this.customerId).cvcCheck(this.cvcCheck).last4(this.last4).id(this.id).tokenizationMethod(this.tokenizationMethod).metadata(this.metadata).loggingTokens(this.loggingTokens);
    }

    public boolean validateCard() {
        return this.validateCard(Calendar.getInstance());
    }

    public boolean validateNumber() {
        return CardUtils.isValidCardNumber(this.number);
    }

    public boolean validateExpiryDate() {
        return this.validateExpiryDate(Calendar.getInstance());
    }

    public boolean validateCVC() {
        if (StripeTextUtils.isBlank(this.cvc)) {
            return false;
        }
        String cvcValue = this.cvc.trim();
        String updatedType = this.getBrand();
        boolean validLength = updatedType == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || "American Express".equals(updatedType) && cvcValue.length() == 4 || cvcValue.length() == 3;
        return ModelUtils.isWholePositiveNumber(cvcValue) && validLength;
    }

    public boolean validateExpMonth() {
        return this.expMonth != null && this.expMonth >= 1 && this.expMonth <= 12;
    }

    boolean validateExpYear(@NonNull Calendar now) {
        return this.expYear != null && !ModelUtils.hasYearPassed(this.expYear, now);
    }

    @Nullable
    public String getNumber() {
        return this.number;
    }

    @NonNull
    public List<String> getLoggingTokens() {
        return this.loggingTokens;
    }

    @Nullable
    public String getCVC() {
        return this.cvc;
    }

    @Nullable
    @IntRange(from=1L, to=12L)
    public Integer getExpMonth() {
        return this.expMonth;
    }

    @Nullable
    public Integer getExpYear() {
        return this.expYear;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Nullable
    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Nullable
    public String getAddressCity() {
        return this.addressCity;
    }

    @Nullable
    public String getAddressZip() {
        return this.addressZip;
    }

    @Nullable
    public String getAddressState() {
        return this.addressState;
    }

    @Nullable
    public String getAddressCountry() {
        return this.addressCountry;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public String getLast4() {
        return this.last4;
    }

    @Nullable
    private String calculateLast4(@Nullable String number, @Nullable String last4) {
        if (!StripeTextUtils.isBlank(last4)) {
            return last4;
        }
        if (number != null && number.length() > 4) {
            return number.substring(number.length() - 4);
        }
        return null;
    }

    @Nullable
    public String getBrand() {
        return this.brand;
    }

    @Nullable
    private String calculateBrand(@Nullable String brand) {
        if (StripeTextUtils.isBlank(brand) && !StripeTextUtils.isBlank(this.number)) {
            return CardUtils.getPossibleCardType(this.number);
        }
        return brand;
    }

    @Nullable
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public String getFunding() {
        return this.funding;
    }

    @Nullable
    public String getCountry() {
        return this.country;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    @Nullable
    public String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    @Nullable
    public String getCustomerId() {
        return this.customerId;
    }

    @Nullable
    public String getCvcCheck() {
        return this.cvcCheck;
    }

    @Nullable
    String getTokenizationMethod() {
        return this.tokenizationMethod;
    }

    boolean validateCard(@NonNull Calendar now) {
        if (this.cvc == null) {
            return this.validateNumber() && this.validateExpiryDate(now);
        }
        return this.validateNumber() && this.validateExpiryDate(now) && this.validateCVC();
    }

    boolean validateExpiryDate(@NonNull Calendar now) {
        if (!this.validateExpMonth()) {
            return false;
        }
        if (this.expYear == null || !this.validateExpYear(now)) {
            return false;
        }
        return !ModelUtils.hasMonthPassed(this.expYear, this.expMonth, now);
    }

    private Card(@NonNull Builder builder) {
        this.number = StripeTextUtils.nullIfBlank(this.normalizeCardNumber(builder.number));
        this.expMonth = builder.expMonth;
        this.expYear = builder.expYear;
        this.cvc = StripeTextUtils.nullIfBlank(builder.cvc);
        this.name = StripeTextUtils.nullIfBlank(builder.name);
        this.addressLine1 = StripeTextUtils.nullIfBlank(builder.addressLine1);
        this.addressLine1Check = StripeTextUtils.nullIfBlank(builder.addressLine1Check);
        this.addressLine2 = StripeTextUtils.nullIfBlank(builder.addressLine2);
        this.addressCity = StripeTextUtils.nullIfBlank(builder.addressCity);
        this.addressState = StripeTextUtils.nullIfBlank(builder.addressState);
        this.addressZip = StripeTextUtils.nullIfBlank(builder.addressZip);
        this.addressZipCheck = StripeTextUtils.nullIfBlank(builder.addressZipCheck);
        this.addressCountry = StripeTextUtils.nullIfBlank(builder.addressCountry);
        this.last4 = StripeTextUtils.nullIfBlank(builder.last4) == null ? this.calculateLast4(this.number, builder.last4) : builder.last4;
        this.brand = Card.asCardBrand(builder.brand) == null ? this.calculateBrand(builder.brand) : builder.brand;
        this.fingerprint = StripeTextUtils.nullIfBlank(builder.fingerprint);
        this.funding = Card.asFundingType(builder.funding);
        this.country = StripeTextUtils.nullIfBlank(builder.country);
        this.currency = StripeTextUtils.nullIfBlank(builder.currency);
        this.customerId = StripeTextUtils.nullIfBlank(builder.customerId);
        this.cvcCheck = StripeTextUtils.nullIfBlank(builder.cvcCheck);
        this.id = StripeTextUtils.nullIfBlank(builder.id);
        this.tokenizationMethod = StripeTextUtils.nullIfBlank(builder.tokenizationMethod);
        this.metadata = builder.metadata;
        if (builder.loggingTokens != null) {
            this.loggingTokens.addAll(builder.loggingTokens);
        }
    }

    @Nullable
    private String normalizeCardNumber(@Nullable String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Card && this.typedEquals((Card)obj);
    }

    private boolean typedEquals(@NonNull Card card) {
        return Objects.equals(this.number, card.number) && Objects.equals(this.cvc, card.cvc) && Objects.equals(this.expMonth, card.expMonth) && Objects.equals(this.expYear, card.expYear) && Objects.equals(this.name, card.name) && Objects.equals(this.addressLine1, card.addressLine1) && Objects.equals(this.addressLine1Check, card.addressLine1Check) && Objects.equals(this.addressLine2, card.addressLine2) && Objects.equals(this.addressCity, card.addressCity) && Objects.equals(this.addressState, card.addressState) && Objects.equals(this.addressZip, card.addressZip) && Objects.equals(this.addressZipCheck, card.addressZipCheck) && Objects.equals(this.addressCountry, card.addressCountry) && Objects.equals(this.last4, card.last4) && Objects.equals(this.brand, card.brand) && Objects.equals(this.funding, card.funding) && Objects.equals(this.fingerprint, card.fingerprint) && Objects.equals(this.country, card.country) && Objects.equals(this.currency, card.currency) && Objects.equals(this.customerId, card.customerId) && Objects.equals(this.cvcCheck, card.cvcCheck) && Objects.equals(this.id, card.id) && Objects.equals(this.loggingTokens, card.loggingTokens) && Objects.equals(this.tokenizationMethod, card.tokenizationMethod) && Objects.equals(this.metadata, card.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.number, this.cvc, this.expMonth, this.expYear, this.name, this.addressLine1, this.addressLine1Check, this.addressLine2, this.addressCity, this.addressState, this.addressZip, this.addressZipCheck, this.addressCountry, this.last4, this.brand, this.funding, this.fingerprint, this.country, this.currency, this.customerId, this.cvcCheck, this.id, this.loggingTokens, this.tokenizationMethod, this.metadata);
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(VALUE_CARD, this.createCardParams());
        return params;
    }

    @NonNull
    private Map<String, Object> createCardParams() {
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        ((AbstractMap)cardParams).put("number", StripeTextUtils.nullIfBlank(this.number));
        ((AbstractMap)cardParams).put("cvc", StripeTextUtils.nullIfBlank(this.cvc));
        ((AbstractMap)cardParams).put(FIELD_EXP_MONTH, this.expMonth);
        ((AbstractMap)cardParams).put(FIELD_EXP_YEAR, this.expYear);
        ((AbstractMap)cardParams).put(FIELD_NAME, StripeTextUtils.nullIfBlank(this.name));
        ((AbstractMap)cardParams).put(FIELD_CURRENCY, StripeTextUtils.nullIfBlank(this.currency));
        ((AbstractMap)cardParams).put(FIELD_ADDRESS_LINE1, StripeTextUtils.nullIfBlank(this.addressLine1));
        ((AbstractMap)cardParams).put(FIELD_ADDRESS_LINE2, StripeTextUtils.nullIfBlank(this.addressLine2));
        ((AbstractMap)cardParams).put(FIELD_ADDRESS_CITY, StripeTextUtils.nullIfBlank(this.addressCity));
        ((AbstractMap)cardParams).put(FIELD_ADDRESS_ZIP, StripeTextUtils.nullIfBlank(this.addressZip));
        ((AbstractMap)cardParams).put(FIELD_ADDRESS_STATE, StripeTextUtils.nullIfBlank(this.addressState));
        ((AbstractMap)cardParams).put(FIELD_ADDRESS_COUNTRY, StripeTextUtils.nullIfBlank(this.addressCountry));
        return cardParams;
    }

    public static final class Builder
    implements ObjectBuilder<Card> {
        @Nullable
        private final String number;
        @Nullable
        private final String cvc;
        private final Integer expMonth;
        private final Integer expYear;
        private String name;
        private String addressLine1;
        private String addressLine1Check;
        private String addressLine2;
        private String addressCity;
        private String addressState;
        private String addressZip;
        private String addressZipCheck;
        private String addressCountry;
        private String brand;
        private String funding;
        @Size(value=4L)
        private String last4;
        private String fingerprint;
        private String country;
        private String currency;
        private String customerId;
        private String cvcCheck;
        private String id;
        private String tokenizationMethod;
        private Map<String, String> metadata;
        private List<String> loggingTokens;

        public Builder(@Nullable String number, @IntRange(from=1L, to=12L) @Nullable Integer expMonth, @IntRange(from=0L) @Nullable Integer expYear, @Nullable String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }

        @NonNull
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder addressLine1(@Nullable String address) {
            this.addressLine1 = address;
            return this;
        }

        @NonNull
        public Builder addressLine1Check(@Nullable String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
            return this;
        }

        @NonNull
        public Builder addressLine2(@Nullable String address) {
            this.addressLine2 = address;
            return this;
        }

        @NonNull
        public Builder addressCity(@Nullable String city) {
            this.addressCity = city;
            return this;
        }

        @NonNull
        public Builder addressState(@Nullable String state) {
            this.addressState = state;
            return this;
        }

        @NonNull
        public Builder addressZip(@Nullable String zip) {
            this.addressZip = zip;
            return this;
        }

        @NonNull
        public Builder addressZipCheck(@Nullable String zipCheck) {
            this.addressZipCheck = zipCheck;
            return this;
        }

        @NonNull
        public Builder addressCountry(@Nullable String country) {
            this.addressCountry = country;
            return this;
        }

        @NonNull
        public Builder brand(@Nullable String brand) {
            this.brand = brand;
            return this;
        }

        @NonNull
        public Builder fingerprint(@Nullable String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @NonNull
        public Builder funding(@Nullable String funding) {
            this.funding = funding;
            return this;
        }

        @NonNull
        public Builder country(@Nullable String country) {
            this.country = country;
            return this;
        }

        @NonNull
        public Builder currency(@Nullable String currency) {
            this.currency = currency;
            return this;
        }

        @NonNull
        public Builder customer(@Nullable String customerId) {
            this.customerId = customerId;
            return this;
        }

        @NonNull
        public Builder cvcCheck(@Nullable String cvcCheck) {
            this.cvcCheck = cvcCheck;
            return this;
        }

        @NonNull
        public Builder last4(@Nullable String last4) {
            this.last4 = last4;
            return this;
        }

        @NonNull
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder tokenizationMethod(@Nullable String tokenizationMethod) {
            this.tokenizationMethod = tokenizationMethod;
            return this;
        }

        @NonNull
        public Builder metadata(@Nullable Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @NonNull
        public Builder loggingTokens(@NonNull List<String> loggingTokens) {
            this.loggingTokens = loggingTokens;
            return this;
        }

        @Override
        @NonNull
        public Card build() {
            return new Card(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FundingType {
        public static final String CREDIT = "credit";
        public static final String DEBIT = "debit";
        public static final String PREPAID = "prepaid";
        public static final String UNKNOWN = "unknown";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CardBrand {
        public static final String AMERICAN_EXPRESS = "American Express";
        public static final String DISCOVER = "Discover";
        public static final String JCB = "JCB";
        public static final String DINERS_CLUB = "Diners Club";
        public static final String VISA = "Visa";
        public static final String MASTERCARD = "MasterCard";
        public static final String UNIONPAY = "UnionPay";
        public static final String UNKNOWN = "Unknown";
    }
}

