/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.exception;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeError;

public abstract class StripeException
extends Exception {
    protected static final long serialVersionUID = 1L;
    @Nullable
    private final String mRequestId;
    private final int mStatusCode;
    @Nullable
    private final StripeError mStripeError;

    public StripeException(@Nullable StripeError stripeError, @Nullable String message, @Nullable String requestId, int statusCode) {
        this(stripeError, message, requestId, statusCode, null);
    }

    public StripeException(@Nullable String message, @Nullable String requestId, int statusCode, @Nullable Throwable e) {
        this(null, message, requestId, statusCode, e);
    }

    public StripeException(@Nullable StripeError stripeError, @Nullable String message, @Nullable String requestId, int statusCode, @Nullable Throwable e) {
        super(message, e);
        this.mStripeError = stripeError;
        this.mStatusCode = statusCode;
        this.mRequestId = requestId;
    }

    @Nullable
    public String getRequestId() {
        return this.mRequestId;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    @Nullable
    public StripeError getStripeError() {
        return this.mStripeError;
    }

    @Override
    @NonNull
    public String toString() {
        String reqIdStr = this.mRequestId != null ? "; request-id: " + this.mRequestId : "";
        return super.toString() + reqIdStr;
    }
}

