/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeIntent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public abstract class StripeIntentResult<T extends StripeIntent> {
    @NonNull
    private final T mStripeIntent;
    private final int mOutcome;

    StripeIntentResult(@NonNull T stripeIntent, int outcome) {
        this.mStripeIntent = stripeIntent;
        this.mOutcome = StripeIntentResult.determineOutcome(Objects.requireNonNull(stripeIntent.getStatus()), outcome);
    }

    private static int determineOutcome(@NonNull StripeIntent.Status stripeIntentStatus, int outcome) {
        if (outcome != 0) {
            return outcome;
        }
        switch (stripeIntentStatus) {
            case RequiresAction: 
            case Canceled: {
                return 3;
            }
            case RequiresPaymentMethod: {
                return 2;
            }
            case Succeeded: 
            case RequiresCapture: 
            case RequiresConfirmation: {
                return 1;
            }
        }
        return 0;
    }

    @NonNull
    public final T getIntent() {
        return this.mStripeIntent;
    }

    public final int getOutcome() {
        return this.mOutcome;
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeIntentResult && this.typedEquals((StripeIntentResult)obj);
    }

    private boolean typedEquals(@NonNull StripeIntentResult setupIntentResult) {
        return Objects.equals(this.mStripeIntent, setupIntentResult.mStripeIntent) && Objects.equals(this.mOutcome, setupIntentResult.mOutcome);
    }

    public final int hashCode() {
        return Objects.hash(this.mStripeIntent, this.mOutcome);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Outcome {
        public static final int UNKNOWN = 0;
        public static final int SUCCEEDED = 1;
        public static final int FAILED = 2;
        public static final int CANCELED = 3;
        public static final int TIMEDOUT = 4;
    }
}

