/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodCardRowView;
import com.stripe.android.view.AddPaymentMethodFpxRowView;
import com.stripe.android.view.MaskedCardView;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000589:;<B)\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0002J\b\u0010*\u001a\u00020\u0014H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020\u0014H\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0014H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u00102\u001a\u00020\u0014H\u0016J\u0010\u00103\u001a\u00020/2\u0006\u0010)\u001a\u00020\u0014H\u0002J\u0014\u00104\u001a\u00020/2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\bJ\u000e\u00105\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u0014J\u0012\u00106\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006="}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "initiallySelectedPaymentMethodId", "", "intentArgs", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "addableTypes", "", "Lcom/stripe/android/model/PaymentMethod$Type;", "(Ljava/lang/String;Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;Ljava/util/List;)V", "handler", "Landroid/os/Handler;", "listener", "Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "getListener", "()Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "setListener", "(Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;)V", "newestPaymentMethodIndex", "", "getNewestPaymentMethodIndex", "()I", "paymentMethods", "Ljava/util/ArrayList;", "Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethods", "()Ljava/util/ArrayList;", "selectedIndex", "selectedPaymentMethod", "getSelectedPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "createAddCardPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$AddCardPaymentMethodViewHolder;", "parent", "Landroid/view/ViewGroup;", "createAddFpxPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$AddFpxPaymentMethodViewHolder;", "createPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$PaymentMethodViewHolder;", "getAddableTypesPosition", "position", "getItemCount", "getItemId", "", "getItemViewType", "onBindViewHolder", "", "holder", "onCreateViewHolder", "viewType", "onPositionClicked", "setPaymentMethods", "setSelectedIndex", "setSelectedPaymentMethod", "paymentMethodId", "AddCardPaymentMethodViewHolder", "AddFpxPaymentMethodViewHolder", "Companion", "Listener", "PaymentMethodViewHolder", "stripe_release"})
public final class PaymentMethodsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final ArrayList<PaymentMethod> paymentMethods;
    private int selectedIndex;
    @Nullable
    private Listener listener;
    private final Handler handler;
    private final String initiallySelectedPaymentMethodId;
    private final PaymentMethodsActivityStarter.Args intentArgs;
    private final List<PaymentMethod.Type> addableTypes;
    private static final int NO_SELECTION = -1;
    private static final int TYPE_CARD = 1;
    private static final int TYPE_ADD_CARD = 2;
    private static final int TYPE_ADD_FPX = 3;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ArrayList<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    @Nullable
    public final Listener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - void declaration
     */
    private final int getNewestPaymentMethodIndex() {
        int index = -1;
        long created = 0L;
        Iterable $this$forEachIndexed$iv = this.paymentMethods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void paymentMethod;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            PaymentMethod paymentMethod2 = (PaymentMethod)item$iv;
            int i = n2;
            boolean bl2 = false;
            if (paymentMethod.created == null || paymentMethod.created <= created) continue;
            created = paymentMethod.created;
            index = i;
        }
        return index;
    }

    @Nullable
    public final PaymentMethod getSelectedPaymentMethod() {
        return this.selectedIndex == -1 ? null : this.paymentMethods.get(this.selectedIndex);
    }

    public final void setPaymentMethods(@NotNull List<PaymentMethod> paymentMethods) {
        Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
        this.paymentMethods.clear();
        this.paymentMethods.addAll((Collection<PaymentMethod>)paymentMethods);
        this.setSelectedPaymentMethod(this.initiallySelectedPaymentMethodId);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.paymentMethods.size() + this.addableTypes.size();
    }

    public int getItemViewType(int position) {
        if (position < this.paymentMethods.size()) {
        } else {
            int n;
            PaymentMethod.Type paymentMethodType = this.addableTypes.get(this.getAddableTypesPosition(position));
            switch (PaymentMethodsAdapter$WhenMappings.$EnumSwitchMapping$0[paymentMethodType.ordinal()]) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported PaymentMethod type: " + paymentMethodType.code);
                }
            }
            return n;
        }
        String type = this.paymentMethods.get((int)position).type;
        return Intrinsics.areEqual((Object)PaymentMethod.Type.Card.code, (Object)type) ? 1 : super.getItemViewType(position);
    }

    public long getItemId(int position) {
        return position < this.paymentMethods.size() ? (long)this.paymentMethods.get(position).hashCode() : (long)this.addableTypes.get(this.getAddableTypesPosition(position)).hashCode();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (holder instanceof PaymentMethodViewHolder) {
            PaymentMethodViewHolder paymentMethodViewHolder = (PaymentMethodViewHolder)holder;
            PaymentMethod paymentMethod = this.paymentMethods.get(position);
            Intrinsics.checkExpressionValueIsNotNull((Object)paymentMethod, (String)"paymentMethods[position]");
            paymentMethodViewHolder.setPaymentMethod(paymentMethod);
            ((PaymentMethodViewHolder)holder).setSelected(position == this.selectedIndex);
            holder.itemView.setOnClickListener(new View.OnClickListener(this, holder){
                final /* synthetic */ PaymentMethodsAdapter this$0;
                final /* synthetic */ RecyclerView.ViewHolder $holder;

                public final void onClick(View it) {
                    PaymentMethodsAdapter.access$onPositionClicked(this.this$0, ((PaymentMethodViewHolder)this.$holder).getAdapterPosition());
                }
                {
                    this.this$0 = paymentMethodsAdapter;
                    this.$holder = viewHolder;
                }
            });
        }
    }

    private final void onPositionClicked(int position) {
        if (this.selectedIndex != position) {
            this.notifyItemChanged(this.selectedIndex);
            this.setSelectedIndex(position);
        }
        this.notifyItemChanged(position);
        this.handler.post(new Runnable(this, position){
            final /* synthetic */ PaymentMethodsAdapter this$0;
            final /* synthetic */ int $position;

            public final void run() {
                block0: {
                    Listener listener = this.this$0.getListener();
                    if (listener == null) break block0;
                    PaymentMethod paymentMethod = this.this$0.getPaymentMethods().get(this.$position);
                    Intrinsics.checkExpressionValueIsNotNull((Object)paymentMethod, (String)"paymentMethods[position]");
                    listener.onClick(paymentMethod);
                }
            }
            {
                this.this$0 = paymentMethodsAdapter;
                this.$position = n;
            }
        });
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        switch (viewType) {
            case 1: {
                viewHolder = this.createPaymentMethodViewHolder(parent);
                break;
            }
            case 2: {
                viewHolder = this.createAddCardPaymentMethodViewHolder(parent);
                break;
            }
            case 3: {
                viewHolder = this.createAddFpxPaymentMethodViewHolder(parent);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported viewType: " + viewType);
            }
        }
        return viewHolder;
    }

    private final AddCardPaymentMethodViewHolder createAddCardPaymentMethodViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        return new AddCardPaymentMethodViewHolder((View)new AddPaymentMethodCardRowView((Activity)context, this.intentArgs));
    }

    private final AddFpxPaymentMethodViewHolder createAddFpxPaymentMethodViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        return new AddFpxPaymentMethodViewHolder((View)new AddPaymentMethodFpxRowView((Activity)context, this.intentArgs));
    }

    private final PaymentMethodViewHolder createPaymentMethodViewHolder(ViewGroup parent) {
        View itemView;
        View view = itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.masked_card_row, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return new PaymentMethodViewHolder(view);
    }

    private final void setSelectedPaymentMethod(String paymentMethodId) {
        int n;
        block4: {
            String string2 = paymentMethodId;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                List $this$indexOfFirst$iv = this.paymentMethods;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    PaymentMethod it2 = (PaymentMethod)item$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)paymentMethodId, (Object)it2.id)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        int indexToSelect = n;
        this.setSelectedIndex(indexToSelect >= 0 ? indexToSelect : this.getNewestPaymentMethodIndex());
    }

    public final void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    private final int getAddableTypesPosition(int position) {
        return position - this.paymentMethods.size();
    }

    @JvmOverloads
    public PaymentMethodsAdapter(@Nullable String initiallySelectedPaymentMethodId, @NotNull PaymentMethodsActivityStarter.Args intentArgs, @NotNull List<? extends PaymentMethod.Type> addableTypes) {
        Intrinsics.checkParameterIsNotNull((Object)intentArgs, (String)"intentArgs");
        Intrinsics.checkParameterIsNotNull(addableTypes, (String)"addableTypes");
        this.initiallySelectedPaymentMethodId = initiallySelectedPaymentMethodId;
        this.intentArgs = intentArgs;
        this.addableTypes = addableTypes;
        this.paymentMethods = new ArrayList();
        this.selectedIndex = -1;
        this.handler = new Handler(Looper.getMainLooper());
        this.setHasStableIds(true);
    }

    public /* synthetic */ PaymentMethodsAdapter(String string2, PaymentMethodsActivityStarter.Args args, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.listOf((Object)((Object)PaymentMethod.Type.Card));
        }
        this(string2, args, list);
    }

    @JvmOverloads
    public PaymentMethodsAdapter(@Nullable String initiallySelectedPaymentMethodId, @NotNull PaymentMethodsActivityStarter.Args intentArgs) {
        this(initiallySelectedPaymentMethodId, intentArgs, null, 4, null);
    }

    public static final /* synthetic */ void access$onPositionClicked(PaymentMethodsAdapter $this, int position) {
        $this.onPositionClicked(position);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$PaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "cardView", "Lcom/stripe/android/view/MaskedCardView;", "setPaymentMethod", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "stripe_release"})
    public static final class PaymentMethodViewHolder
    extends RecyclerView.ViewHolder {
        private final MaskedCardView cardView;

        public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            this.cardView.setPaymentMethod(paymentMethod);
        }

        public final void setSelected(boolean selected) {
            this.cardView.setSelected(selected);
        }

        public PaymentMethodViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.masked_card_item);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.masked_card_item)");
            this.cardView = (MaskedCardView)view;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$AddCardPaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "stripe_release"})
    public static final class AddCardPaymentMethodViewHolder
    extends RecyclerView.ViewHolder {
        public AddCardPaymentMethodViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$AddFpxPaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "stripe_release"})
    public static final class AddFpxPaymentMethodViewHolder
    extends RecyclerView.ViewHolder {
        public AddFpxPaymentMethodViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "", "onClick", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface Listener {
        public void onClick(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Companion;", "", "()V", "NO_SELECTION", "", "TYPE_ADD_CARD", "TYPE_ADD_FPX", "TYPE_CARD", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

