/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceCodeVerification
extends StripeModel {
    private static final String FIELD_ATTEMPTS_REMAINING = "attempts_remaining";
    private static final String FIELD_STATUS = "status";
    private static final int INVALID_ATTEMPTS_REMAINING = -1;
    private final int mAttemptsRemaining;
    @Nullable
    private final String mStatus;

    private SourceCodeVerification(int attemptsRemaining, @Nullable String status) {
        this.mAttemptsRemaining = attemptsRemaining;
        this.mStatus = status;
    }

    public int getAttemptsRemaining() {
        return this.mAttemptsRemaining;
    }

    @Nullable
    public String getStatus() {
        return this.mStatus;
    }

    @Nullable
    public static SourceCodeVerification fromString(@Nullable String jsonString) {
        try {
            return SourceCodeVerification.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceCodeVerification fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new SourceCodeVerification(jsonObject.optInt(FIELD_ATTEMPTS_REMAINING, -1), SourceCodeVerification.asStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS)));
    }

    @Nullable
    private static String asStatus(@Nullable String stringStatus) {
        if ("pending".equals(stringStatus)) {
            return "pending";
        }
        if ("succeeded".equals(stringStatus)) {
            return "succeeded";
        }
        if ("failed".equals(stringStatus)) {
            return "failed";
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SourceCodeVerification && this.typedEquals((SourceCodeVerification)obj);
    }

    private boolean typedEquals(@NonNull SourceCodeVerification sourceCodeVerification) {
        return this.mAttemptsRemaining == sourceCodeVerification.mAttemptsRemaining && Objects.equals(this.mStatus, sourceCodeVerification.mStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mAttemptsRemaining, this.mStatus);
    }
}

