/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PaymentSessionConfig
implements Parcelable {
    @NonNull
    private final List<String> mHiddenShippingInfoFields;
    @NonNull
    private final List<String> mOptionalShippingInfoFields;
    @Nullable
    private final ShippingInformation mShippingInformation;
    private final boolean mShippingInfoRequired;
    private final boolean mShippingMethodRequired;
    public static final Parcelable.Creator<PaymentSessionConfig> CREATOR = new Parcelable.Creator<PaymentSessionConfig>(){

        public PaymentSessionConfig createFromParcel(@NonNull Parcel in) {
            return new PaymentSessionConfig(in);
        }

        public PaymentSessionConfig[] newArray(int size) {
            return new PaymentSessionConfig[size];
        }
    };

    private PaymentSessionConfig(@NonNull Builder builder) {
        this.mHiddenShippingInfoFields = ObjectUtils.getOrDefault(builder.mHiddenShippingInfoFields, new ArrayList());
        this.mOptionalShippingInfoFields = ObjectUtils.getOrDefault(builder.mOptionalShippingInfoFields, new ArrayList());
        this.mShippingInformation = builder.mShippingInformation;
        this.mShippingInfoRequired = builder.mShippingInfoRequired;
        this.mShippingMethodRequired = builder.mShippingMethodsRequired;
    }

    private PaymentSessionConfig(@NonNull Parcel in) {
        this.mHiddenShippingInfoFields = new ArrayList<String>();
        in.readList(this.mHiddenShippingInfoFields, String.class.getClassLoader());
        this.mOptionalShippingInfoFields = new ArrayList<String>();
        in.readList(this.mOptionalShippingInfoFields, String.class.getClassLoader());
        this.mShippingInformation = (ShippingInformation)in.readParcelable(ShippingInformation.class.getClassLoader());
        this.mShippingInfoRequired = in.readInt() == 1;
        this.mShippingMethodRequired = in.readInt() == 1;
    }

    public boolean equals(Object o) {
        return super.equals(o) || o instanceof PaymentSessionConfig && this.typedEquals((PaymentSessionConfig)o);
    }

    private boolean typedEquals(@NonNull PaymentSessionConfig obj) {
        return Objects.equals(this.mHiddenShippingInfoFields, obj.mHiddenShippingInfoFields) && Objects.equals(this.mOptionalShippingInfoFields, obj.mOptionalShippingInfoFields) && Objects.equals(this.mShippingInformation, obj.mShippingInformation) && Objects.equals(this.mShippingInfoRequired, obj.mShippingInfoRequired) && Objects.equals(this.mShippingMethodRequired, obj.mShippingMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.mHiddenShippingInfoFields, this.mOptionalShippingInfoFields, this.mShippingInformation, this.mShippingInfoRequired, this.mShippingMethodRequired);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeList(this.mHiddenShippingInfoFields);
        parcel.writeList(this.mOptionalShippingInfoFields);
        parcel.writeParcelable((Parcelable)this.mShippingInformation, flags);
        parcel.writeInt(this.mShippingInfoRequired ? 1 : 0);
        parcel.writeInt(this.mShippingMethodRequired ? 1 : 0);
    }

    @NonNull
    public List<String> getHiddenShippingInfoFields() {
        return this.mHiddenShippingInfoFields;
    }

    @NonNull
    public List<String> getOptionalShippingInfoFields() {
        return this.mOptionalShippingInfoFields;
    }

    @Nullable
    public ShippingInformation getPrepopulatedShippingInfo() {
        return this.mShippingInformation;
    }

    public boolean isShippingInfoRequired() {
        return this.mShippingInfoRequired;
    }

    public boolean isShippingMethodRequired() {
        return this.mShippingMethodRequired;
    }

    public static class Builder
    implements ObjectBuilder<PaymentSessionConfig> {
        private boolean mShippingInfoRequired = true;
        private boolean mShippingMethodsRequired = true;
        @Nullable
        private List<String> mHiddenShippingInfoFields;
        @Nullable
        private List<String> mOptionalShippingInfoFields;
        @Nullable
        private ShippingInformation mShippingInformation;

        @NonNull
        public Builder setHiddenShippingInfoFields(String ... hiddenShippingInfoFields) {
            this.mHiddenShippingInfoFields = Arrays.asList(hiddenShippingInfoFields);
            return this;
        }

        @NonNull
        public Builder setOptionalShippingInfoFields(String ... optionalShippingInfoFields) {
            this.mOptionalShippingInfoFields = Arrays.asList(optionalShippingInfoFields);
            return this;
        }

        @NonNull
        public Builder setPrepopulatedShippingInfo(ShippingInformation shippingInfo) {
            this.mShippingInformation = shippingInfo;
            return this;
        }

        @NonNull
        public Builder setShippingInfoRequired(boolean shippingInfoRequired) {
            this.mShippingInfoRequired = shippingInfoRequired;
            return this;
        }

        @NonNull
        public Builder setShippingMethodsRequired(boolean shippingMethodsRequired) {
            this.mShippingMethodsRequired = shippingMethodsRequired;
            return this;
        }

        @Override
        @NonNull
        public PaymentSessionConfig build() {
            return new PaymentSessionConfig(this);
        }
    }
}

