/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentMethodsActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class PaymentMethodsActivityStarter
extends ActivityStarter<PaymentMethodsActivity, Args> {
    public static final int REQUEST_CODE = 6000;

    public PaymentMethodsActivityStarter(@NonNull Activity activity) {
        super(activity, PaymentMethodsActivity.class, Args.DEFAULT, 6000);
    }

    public PaymentMethodsActivityStarter(@NonNull Fragment fragment) {
        super(fragment, PaymentMethodsActivity.class, Args.DEFAULT, 6000);
    }

    public static final class Result
    implements ActivityStarter.Result {
        @NonNull
        public final PaymentMethod paymentMethod;
        final boolean useGooglePay;
        public static final Parcelable.Creator<Result> CREATOR = new Parcelable.Creator<Result>(){

            public Result createFromParcel(Parcel in) {
                return new Result(in);
            }

            public Result[] newArray(int size) {
                return new Result[size];
            }
        };

        @Nullable
        public static Result fromIntent(@NonNull Intent intent) {
            return (Result)intent.getParcelableExtra("extra_activity_result");
        }

        public Result(@NonNull PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            this.useGooglePay = false;
        }

        private Result(@NonNull Parcel parcel) {
            this.paymentMethod = (PaymentMethod)Objects.requireNonNull(parcel.readParcelable(PaymentMethod.class.getClassLoader()));
            this.useGooglePay = parcel.readInt() == 1;
        }

        @NonNull
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putParcelable("extra_activity_result", (Parcelable)this);
            return bundle;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.paymentMethod, flags);
            dest.writeInt(this.useGooglePay ? 1 : 0);
        }

        public int hashCode() {
            return Objects.hash(this.paymentMethod);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Result && this.typedEquals((Result)obj);
        }

        private boolean typedEquals(@NonNull Result other) {
            return Objects.equals(this.paymentMethod, other.paymentMethod);
        }
    }

    public static final class Args
    implements ActivityStarter.Args {
        private static final Args DEFAULT = new Builder().build();
        @Nullable
        final String initialPaymentMethodId;
        public final boolean shouldRequirePostalCode;
        final boolean isPaymentSessionActive;
        @NonNull
        final List<PaymentMethod.Type> paymentMethodTypes;
        @Nullable
        final PaymentConfiguration paymentConfiguration;
        public static final Parcelable.Creator<Args> CREATOR = new Parcelable.Creator<Args>(){

            public Args createFromParcel(@NonNull Parcel in) {
                return new Args(in);
            }

            public Args[] newArray(int size) {
                return new Args[size];
            }
        };

        @NonNull
        public static Args create(@NonNull Intent intent) {
            Args args = (Args)intent.getParcelableExtra("extra_activity_args");
            return Objects.requireNonNull(args);
        }

        private Args(@NonNull Builder builder) {
            this.initialPaymentMethodId = builder.mInitialPaymentMethodId;
            this.shouldRequirePostalCode = builder.mShouldRequirePostalCode;
            this.isPaymentSessionActive = builder.mIsPaymentSessionActive;
            this.paymentMethodTypes = ObjectUtils.getOrEmpty(builder.mPaymentMethodTypes, Collections.singletonList(PaymentMethod.Type.Card));
            this.paymentConfiguration = builder.mPaymentConfiguration;
        }

        private Args(@NonNull Parcel in) {
            this.initialPaymentMethodId = in.readString();
            this.shouldRequirePostalCode = in.readInt() == 1;
            this.isPaymentSessionActive = in.readInt() == 1;
            int paymentMethodTypesSize = in.readInt();
            this.paymentMethodTypes = new ArrayList<PaymentMethod.Type>(paymentMethodTypesSize);
            for (int i = 0; i < paymentMethodTypesSize; ++i) {
                this.paymentMethodTypes.add(PaymentMethod.Type.valueOf(in.readString()));
            }
            this.paymentConfiguration = (PaymentConfiguration)in.readParcelable(PaymentConfiguration.class.getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.initialPaymentMethodId);
            dest.writeInt(this.shouldRequirePostalCode ? 1 : 0);
            dest.writeInt(this.isPaymentSessionActive ? 1 : 0);
            dest.writeInt(this.paymentMethodTypes.size());
            for (PaymentMethod.Type paymentMethodType : this.paymentMethodTypes) {
                dest.writeString(paymentMethodType.name());
            }
            dest.writeParcelable((Parcelable)this.paymentConfiguration, 0);
        }

        public int hashCode() {
            return Objects.hash(this.initialPaymentMethodId, this.shouldRequirePostalCode, this.isPaymentSessionActive, this.paymentMethodTypes, this.paymentConfiguration);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Args && this.typedEquals((Args)obj);
        }

        private boolean typedEquals(@NonNull Args args) {
            return Objects.equals(this.initialPaymentMethodId, args.initialPaymentMethodId) && Objects.equals(this.shouldRequirePostalCode, args.shouldRequirePostalCode) && Objects.equals(this.isPaymentSessionActive, args.isPaymentSessionActive) && Objects.equals(this.paymentMethodTypes, args.paymentMethodTypes) && Objects.equals(this.paymentConfiguration, args.paymentConfiguration);
        }

        public static final class Builder
        implements ObjectBuilder<Args> {
            @Nullable
            private String mInitialPaymentMethodId = null;
            private boolean mShouldRequirePostalCode = false;
            private boolean mIsPaymentSessionActive = false;
            @Nullable
            private List<PaymentMethod.Type> mPaymentMethodTypes;
            @Nullable
            private PaymentConfiguration mPaymentConfiguration;

            @NonNull
            public Builder setInitialPaymentMethodId(@Nullable String initialPaymentMethodId) {
                this.mInitialPaymentMethodId = initialPaymentMethodId;
                return this;
            }

            @NonNull
            public Builder setShouldRequirePostalCode(boolean shouldRequirePostalCode) {
                this.mShouldRequirePostalCode = shouldRequirePostalCode;
                return this;
            }

            @NonNull
            public Builder setIsPaymentSessionActive(boolean isPaymentSessionActive) {
                this.mIsPaymentSessionActive = isPaymentSessionActive;
                return this;
            }

            @NonNull
            public Builder setPaymentConfiguration(@Nullable PaymentConfiguration paymentConfiguration) {
                this.mPaymentConfiguration = paymentConfiguration;
                return this;
            }

            @NonNull
            Builder setPaymentMethodTypes(@NonNull List<PaymentMethod.Type> paymentMethodTypes) {
                this.mPaymentMethodTypes = paymentMethodTypes;
                return this;
            }

            @Override
            @NonNull
            public Args build() {
                return new Args(this);
            }
        }
    }
}

