/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.stripe.android.R;
import com.stripe.android.view.ViewUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0010\u001a\u00020\u00062\b\b\u0001\u0010\u0011\u001a\u00020\u0006H\u0003J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/view/ThemeConfig;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "selectedColorInt", "", "selectedTextAlphaColorInt", "textColorValues", "", "getTextColorValues", "()[I", "unselectedColorInt", "unselectedTextAlphaColorInt", "unselectedTextColorInt", "determineColor", "defaultColor", "colorIfTransparent", "getTextAlphaColor", "isSelected", "", "getTextColor", "getTintColor", "stripe_release"})
public final class ThemeConfig {
    @ColorInt
    private final int selectedColorInt;
    @ColorInt
    private final int unselectedColorInt;
    @ColorInt
    private final int unselectedTextColorInt;
    @ColorInt
    private final int selectedTextAlphaColorInt;
    @ColorInt
    private final int unselectedTextAlphaColorInt;
    @NotNull
    private final int[] textColorValues;

    @NotNull
    public final int[] getTextColorValues() {
        return this.textColorValues;
    }

    @ColorInt
    public final int getTintColor(boolean isSelected) {
        return isSelected ? this.selectedColorInt : this.unselectedColorInt;
    }

    @ColorInt
    public final int getTextColor(boolean isSelected) {
        return isSelected ? this.selectedColorInt : this.unselectedTextColorInt;
    }

    @ColorInt
    public final int getTextAlphaColor(boolean isSelected) {
        return isSelected ? this.selectedTextAlphaColorInt : this.unselectedTextAlphaColorInt;
    }

    @ColorInt
    private final int determineColor(Context context, @ColorInt int defaultColor, @ColorRes int colorIfTransparent) {
        return ViewUtils.isColorTransparent(defaultColor) ? ContextCompat.getColor((Context)context, (int)colorIfTransparent) : defaultColor;
    }

    public ThemeConfig(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.selectedColorInt = this.determineColor(context, ViewUtils.getThemeAccentColor((Context)context).data, R.color.accent_color_default);
        this.unselectedColorInt = this.determineColor(context, ViewUtils.getThemeColorControlNormal((Context)context).data, R.color.control_normal_color_default);
        this.unselectedTextColorInt = this.determineColor(context, ViewUtils.getThemeTextColorSecondary((Context)context).data, R.color.color_text_secondary_default);
        this.selectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.selectedColorInt, (int)context.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.unselectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.unselectedTextColorInt, (int)context.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.textColorValues = new int[]{this.selectedColorInt, this.selectedTextAlphaColorInt, this.unselectedTextColorInt, this.unselectedTextAlphaColorInt};
    }
}

