/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.MaskedCardView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003+,-B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0014\u0010&\u001a\u00020\u001f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140'J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0012\u0010)\u001a\u00020\u001f2\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder;", "initiallySelectedPaymentMethodId", "", "(Ljava/lang/String;)V", "handler", "Landroid/os/Handler;", "listener", "Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "getListener", "()Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "setListener", "(Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;)V", "newestPaymentMethodIndex", "", "getNewestPaymentMethodIndex", "()I", "paymentMethods", "Ljava/util/ArrayList;", "Lcom/stripe/android/model/PaymentMethod;", "selectedIndex", "selectedPaymentMethod", "getSelectedPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getItemCount", "getItemId", "", "position", "getItemViewType", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onPositionClicked", "setPaymentMethods", "", "setSelectedIndex", "setSelectedPaymentMethod", "paymentMethodId", "Companion", "Listener", "ViewHolder", "stripe_release"})
public final class PaymentMethodsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final ArrayList<PaymentMethod> paymentMethods;
    private int selectedIndex;
    @Nullable
    private Listener listener;
    private final Handler handler;
    private final String initiallySelectedPaymentMethodId;
    private static final int TYPE_CARD = 0;
    private static final int NO_SELECTION = -1;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Listener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - void declaration
     */
    private final int getNewestPaymentMethodIndex() {
        int index = -1;
        long created = 0L;
        Iterable $this$forEachIndexed$iv = this.paymentMethods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void paymentMethod;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            PaymentMethod paymentMethod2 = (PaymentMethod)item$iv;
            int i = n2;
            boolean bl2 = false;
            if (paymentMethod.created == null || paymentMethod.created <= created) continue;
            created = paymentMethod.created;
            index = i;
        }
        return index;
    }

    @Nullable
    public final PaymentMethod getSelectedPaymentMethod() {
        return this.selectedIndex == -1 ? null : this.paymentMethods.get(this.selectedIndex);
    }

    public final void setPaymentMethods(@NotNull List<PaymentMethod> paymentMethods) {
        Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
        this.paymentMethods.clear();
        this.paymentMethods.addAll((Collection<PaymentMethod>)paymentMethods);
        this.setSelectedPaymentMethod(this.initiallySelectedPaymentMethodId);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.paymentMethods.size();
    }

    public int getItemViewType(int position) {
        String type = this.paymentMethods.get((int)position).type;
        return Intrinsics.areEqual((Object)PaymentMethod.Type.Card.code, (Object)type) ? 0 : super.getItemViewType(position);
    }

    public long getItemId(int position) {
        String string2 = this.paymentMethods.get((int)position).id;
        boolean bl = false;
        String string3 = string2;
        return string3 != null ? string3.hashCode() : 0;
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        PaymentMethod paymentMethod = this.paymentMethods.get(position);
        Intrinsics.checkExpressionValueIsNotNull((Object)paymentMethod, (String)"paymentMethods[position]");
        holder.setPaymentMethod(paymentMethod);
        holder.setSelected(position == this.selectedIndex);
        holder.itemView.setOnClickListener(new View.OnClickListener(this, holder){
            final /* synthetic */ PaymentMethodsAdapter this$0;
            final /* synthetic */ ViewHolder $holder;

            public final void onClick(View it) {
                PaymentMethodsAdapter.access$onPositionClicked(this.this$0, this.$holder.getAdapterPosition());
            }
            {
                this.this$0 = paymentMethodsAdapter;
                this.$holder = viewHolder;
            }
        });
    }

    private final void onPositionClicked(int position) {
        if (this.selectedIndex != position) {
            this.notifyItemChanged(position);
            this.notifyItemChanged(this.selectedIndex);
            this.setSelectedIndex(position);
        }
        this.handler.post(new Runnable(this, position){
            final /* synthetic */ PaymentMethodsAdapter this$0;
            final /* synthetic */ int $position;

            public final void run() {
                block0: {
                    Listener listener = this.this$0.getListener();
                    if (listener == null) break block0;
                    E e = PaymentMethodsAdapter.access$getPaymentMethods$p(this.this$0).get(this.$position);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"paymentMethods[position]");
                    listener.onClick((PaymentMethod)e);
                }
            }
            {
                this.this$0 = paymentMethodsAdapter;
                this.$position = n;
            }
        });
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View itemView;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        int layoutRes = 0;
        if (viewType != 0) {
            throw (Throwable)new IllegalArgumentException("Unsupported type: " + viewType);
        }
        layoutRes = R.layout.masked_card_row;
        View view = itemView = LayoutInflater.from((Context)parent.getContext()).inflate(layoutRes, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return new ViewHolder(view);
    }

    private final void setSelectedPaymentMethod(String paymentMethodId) {
        int n;
        block4: {
            String string2 = paymentMethodId;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                List $this$indexOfFirst$iv = this.paymentMethods;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    PaymentMethod it2 = (PaymentMethod)item$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)paymentMethodId, (Object)it2.id)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        int indexToSelect = n;
        this.setSelectedIndex(indexToSelect >= 0 ? indexToSelect : this.getNewestPaymentMethodIndex());
    }

    public final void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public PaymentMethodsAdapter(@Nullable String initiallySelectedPaymentMethodId) {
        this.initiallySelectedPaymentMethodId = initiallySelectedPaymentMethodId;
        this.paymentMethods = new ArrayList();
        this.selectedIndex = -1;
        this.handler = new Handler(Looper.getMainLooper());
        this.setHasStableIds(true);
    }

    public static final /* synthetic */ void access$onPositionClicked(PaymentMethodsAdapter $this, int position) {
        $this.onPositionClicked(position);
    }

    public static final /* synthetic */ ArrayList access$getPaymentMethods$p(PaymentMethodsAdapter $this) {
        return $this.paymentMethods;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "cardView", "Lcom/stripe/android/view/MaskedCardView;", "setPaymentMethod", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "stripe_release"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        private final MaskedCardView cardView;

        public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            this.cardView.setPaymentMethod(paymentMethod);
        }

        public final void setSelected(boolean selected) {
            this.cardView.setSelected(selected);
        }

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.masked_card_item);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.masked_card_item)");
            this.cardView = (MaskedCardView)view;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "", "onClick", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface Listener {
        public void onClick(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Companion;", "", "()V", "NO_SELECTION", "", "TYPE_CARD", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

