/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.VisibleForTesting;
import com.stripe.android.model.StripeIntent;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "", "source", "", "directoryServer", "Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServer;", "serverTransactionId", "directoryServerEncryption", "Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "(Ljava/lang/String;Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServer;Ljava/lang/String;Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;)V", "getDirectoryServer", "()Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServer;", "getDirectoryServerEncryption", "()Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "getServerTransactionId", "()Ljava/lang/String;", "getSource", "Companion", "DirectoryServer", "DirectoryServerEncryption", "stripe_release"})
public final class Stripe3ds2Fingerprint {
    @NotNull
    private final String source;
    @NotNull
    private final DirectoryServer directoryServer;
    @NotNull
    private final String serverTransactionId;
    @NotNull
    private final DirectoryServerEncryption directoryServerEncryption;
    private static final String FIELD_THREE_D_SECURE_2_SOURCE = "three_d_secure_2_source";
    private static final String FIELD_DIRECTORY_SERVER_NAME = "directory_server_name";
    private static final String FIELD_SERVER_TRANSACTION_ID = "server_transaction_id";
    private static final String FIELD_DIRECTORY_SERVER_ENCRYPTION = "directory_server_encryption";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final DirectoryServer getDirectoryServer() {
        return this.directoryServer;
    }

    @NotNull
    public final String getServerTransactionId() {
        return this.serverTransactionId;
    }

    @NotNull
    public final DirectoryServerEncryption getDirectoryServerEncryption() {
        return this.directoryServerEncryption;
    }

    private Stripe3ds2Fingerprint(String source, DirectoryServer directoryServer, String serverTransactionId, DirectoryServerEncryption directoryServerEncryption) {
        this.source = source;
        this.directoryServer = directoryServer;
        this.serverTransactionId = serverTransactionId;
        this.directoryServerEncryption = directoryServerEncryption;
    }

    public /* synthetic */ Stripe3ds2Fingerprint(String source, DirectoryServer directoryServer, String serverTransactionId, DirectoryServerEncryption directoryServerEncryption, DefaultConstructorMarker $constructor_marker) {
        this(source, directoryServer, serverTransactionId, directoryServerEncryption);
    }

    @JvmStatic
    @NotNull
    public static final Stripe3ds2Fingerprint create(@NotNull StripeIntent.SdkData sdkData) throws CertificateException {
        return Companion.create(sdkData);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B/\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "", "directoryServerId", "", "dsCertificateData", "rootCertsData", "", "keyId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getDirectoryServerId", "()Ljava/lang/String;", "directoryServerPublicKey", "Ljava/security/PublicKey;", "getDirectoryServerPublicKey", "()Ljava/security/PublicKey;", "getKeyId", "rootCerts", "Ljava/security/cert/X509Certificate;", "getRootCerts", "()Ljava/util/List;", "generateCertificate", "certificateData", "generateCertificates", "certificatesData", "Companion", "stripe_release"})
    public static final class DirectoryServerEncryption {
        @NotNull
        private final PublicKey directoryServerPublicKey;
        @NotNull
        private final List<X509Certificate> rootCerts;
        @NotNull
        private final String directoryServerId;
        @Nullable
        private final String keyId;
        private static final String FIELD_DIRECTORY_SERVER_ID = "directory_server_id";
        private static final String FIELD_CERTIFICATE = "certificate";
        private static final String FIELD_KEY_ID = "key_id";
        private static final String FIELD_ROOT_CAS = "root_certificate_authorities";
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final PublicKey getDirectoryServerPublicKey() {
            return this.directoryServerPublicKey;
        }

        @NotNull
        public final List<X509Certificate> getRootCerts() {
            return this.rootCerts;
        }

        /*
         * WARNING - void declaration
         */
        private final List<X509Certificate> generateCertificates(List<String> certificatesData) throws CertificateException {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = certificatesData;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                X509Certificate x509Certificate = this.generateCertificate((String)it);
                collection.add(x509Certificate);
            }
            return (List)destination$iv$iv;
        }

        private final X509Certificate generateCertificate(String certificateData) throws CertificateException {
            Certificate certificate;
            byte[] byArray;
            String string2 = certificateData;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray = byArray2;
            Certificate certificate2 = certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray3));
            if (certificate2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            return (X509Certificate)certificate2;
        }

        @NotNull
        public final String getDirectoryServerId() {
            return this.directoryServerId;
        }

        @Nullable
        public final String getKeyId() {
            return this.keyId;
        }

        @VisibleForTesting
        public DirectoryServerEncryption(@NotNull String directoryServerId, @NotNull String dsCertificateData, @NotNull List<String> rootCertsData, @Nullable String keyId) throws CertificateException {
            Intrinsics.checkParameterIsNotNull((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkParameterIsNotNull((Object)dsCertificateData, (String)"dsCertificateData");
            Intrinsics.checkParameterIsNotNull(rootCertsData, (String)"rootCertsData");
            this.directoryServerId = directoryServerId;
            this.keyId = keyId;
            PublicKey publicKey = this.generateCertificate(dsCertificateData).getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"generateCertificate(dsCertificateData).publicKey");
            this.directoryServerPublicKey = publicKey;
            this.rootCerts = this.generateCertificates(rootCertsData);
        }

        @JvmStatic
        @NotNull
        public static final DirectoryServerEncryption create$stripe_release(@NotNull Map<String, ?> data) throws CertificateException {
            return Companion.create$stripe_release(data);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u000bH\u0001\u00a2\u0006\u0002\b\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption$Companion;", "", "()V", "FIELD_CERTIFICATE", "", "FIELD_DIRECTORY_SERVER_ID", "FIELD_KEY_ID", "FIELD_ROOT_CAS", "create", "Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "data", "", "create$stripe_release", "stripe_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final DirectoryServerEncryption create$stripe_release(@NotNull Map<String, ?> data) throws CertificateException {
                List list;
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                if (data.containsKey(DirectoryServerEncryption.FIELD_ROOT_CAS)) {
                    Object obj = data.get(DirectoryServerEncryption.FIELD_ROOT_CAS);
                    if (obj == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                    }
                    list = (List)obj;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List rootCertData = list;
                Object obj = data.get(DirectoryServerEncryption.FIELD_DIRECTORY_SERVER_ID);
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                Object obj2 = data.get(DirectoryServerEncryption.FIELD_CERTIFICATE);
                if (obj2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                return new DirectoryServerEncryption((String)obj, (String)obj2, rootCertData, (String)data.get(DirectoryServerEncryption.FIELD_KEY_ID));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServer;", "", "networkName", "", "id", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getNetworkName", "Visa", "Mastercard", "Amex", "Companion", "stripe_release"})
    public static final class DirectoryServer
    extends Enum<DirectoryServer> {
        public static final /* enum */ DirectoryServer Visa;
        public static final /* enum */ DirectoryServer Mastercard;
        public static final /* enum */ DirectoryServer Amex;
        private static final /* synthetic */ DirectoryServer[] $VALUES;
        @NotNull
        private final String networkName;
        @NotNull
        private final String id;
        public static final Companion Companion;

        static {
            DirectoryServer[] directoryServerArray = new DirectoryServer[3];
            DirectoryServer[] directoryServerArray2 = directoryServerArray;
            directoryServerArray[0] = Visa = new DirectoryServer("visa", "A000000003");
            directoryServerArray[1] = Mastercard = new DirectoryServer("mastercard", "A000000004");
            directoryServerArray[2] = Amex = new DirectoryServer("american_express", "A000000025");
            $VALUES = directoryServerArray;
            Companion = new Companion(null);
        }

        @NotNull
        public final String getNetworkName() {
            return this.networkName;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        private DirectoryServer(String networkName, String id) {
            this.networkName = networkName;
            this.id = id;
        }

        public static DirectoryServer[] values() {
            return (DirectoryServer[])$VALUES.clone();
        }

        public static DirectoryServer valueOf(String string2) {
            return Enum.valueOf(DirectoryServer.class, string2);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServer$Companion;", "", "()V", "lookup", "Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServer;", "networkName", "", "lookup$stripe_release", "stripe_release"})
        public static final class Companion {
            @NotNull
            public final DirectoryServer lookup$stripe_release(@NotNull String networkName) {
                DirectoryServer directoryServer;
                boolean bl;
                Object object;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)networkName, (String)"networkName");
                    object = DirectoryServer.values();
                    bl = false;
                    DirectoryServer[] directoryServerArray = object;
                    boolean bl2 = false;
                    DirectoryServer[] directoryServerArray2 = directoryServerArray;
                    int n = directoryServerArray2.length;
                    for (int i = 0; i < n; ++i) {
                        DirectoryServer directoryServer2;
                        DirectoryServer it = directoryServer2 = directoryServerArray2[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getNetworkName(), (Object)networkName)) continue;
                        directoryServer = directoryServer2;
                        break block2;
                    }
                    directoryServer = null;
                }
                if (directoryServer == null) {
                    object = "Invalid directory server networkName: '" + networkName + '\'';
                    bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                return directoryServer;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$Companion;", "", "()V", "FIELD_DIRECTORY_SERVER_ENCRYPTION", "", "FIELD_DIRECTORY_SERVER_NAME", "FIELD_SERVER_TRANSACTION_ID", "FIELD_THREE_D_SECURE_2_SOURCE", "create", "Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "sdkData", "Lcom/stripe/android/model/StripeIntent$SdkData;", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Stripe3ds2Fingerprint create(@NotNull StripeIntent.SdkData sdkData) throws CertificateException {
            Intrinsics.checkParameterIsNotNull((Object)sdkData, (String)"sdkData");
            boolean bl = sdkData.is3ds2();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "Expected SdkData with type='stripe_3ds2_fingerprint'.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Object obj = sdkData.data.get(Stripe3ds2Fingerprint.FIELD_THREE_D_SECURE_2_SOURCE);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Object obj2 = sdkData.data.get(Stripe3ds2Fingerprint.FIELD_DIRECTORY_SERVER_NAME);
            if (obj2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Object obj3 = sdkData.data.get(Stripe3ds2Fingerprint.FIELD_SERVER_TRANSACTION_ID);
            if (obj3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Object obj4 = sdkData.data.get(Stripe3ds2Fingerprint.FIELD_DIRECTORY_SERVER_ENCRYPTION);
            if (obj4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            }
            return new Stripe3ds2Fingerprint((String)obj, DirectoryServer.Companion.lookup$stripe_release((String)obj2), (String)obj3, DirectoryServerEncryption.Companion.create$stripe_release((Map)obj4), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

