/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.R;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowActivityStarter;
import com.stripe.android.view.PaymentFlowPagerAdapter;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import com.stripe.android.view.StripeActivity;
import java.util.List;

public class PaymentFlowActivity
extends StripeActivity {
    public static final String TOKEN_PAYMENT_FLOW_ACTIVITY = "PaymentFlowActivity";
    public static final String TOKEN_SHIPPING_INFO_SCREEN = "ShippingInfoScreen";
    public static final String TOKEN_SHIPPING_METHOD_SCREEN = "ShippingMethodScreen";
    private BroadcastReceiver mShippingInfoSavedBroadcastReceiver;
    private BroadcastReceiver mShippingInfoSubmittedBroadcastReceiver;
    private PaymentFlowPagerAdapter mPaymentFlowPagerAdapter;
    private ViewPager mViewPager;
    private PaymentSessionData mPaymentSessionData;
    private ShippingInformation mShippingInformationSubmitted;
    private List<ShippingMethod> mValidShippingMethods;
    private ShippingMethod mDefaultShippingMethod;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentFlowActivityStarter.Args args = PaymentFlowActivityStarter.Args.create(this.getIntent());
        CustomerSession.getInstance().addProductUsageTokenIfValid("PaymentSession");
        CustomerSession.getInstance().addProductUsageTokenIfValid(TOKEN_PAYMENT_FLOW_ACTIVITY);
        this.getViewStub().setLayoutResource(R.layout.activity_shipping_flow);
        this.getViewStub().inflate();
        this.mViewPager = (ViewPager)this.findViewById(R.id.shipping_flow_viewpager);
        this.mPaymentSessionData = args.paymentSessionData;
        if (this.mPaymentSessionData == null) {
            throw new IllegalArgumentException("PaymentFlowActivity launched without PaymentSessionData");
        }
        this.mPaymentFlowPagerAdapter = new PaymentFlowPagerAdapter((Context)this, args.paymentSessionConfig);
        this.mViewPager.setAdapter((PagerAdapter)this.mPaymentFlowPagerAdapter);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int i) {
                PaymentFlowActivity.this.setTitle(PaymentFlowActivity.this.mViewPager.getAdapter().getPageTitle(i));
                if (PaymentFlowActivity.this.mPaymentFlowPagerAdapter.getPageAt(i) == PaymentFlowPagerEnum.SHIPPING_INFO) {
                    PaymentFlowActivity.this.mPaymentFlowPagerAdapter.hideShippingPage();
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
        this.mShippingInfoSubmittedBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                boolean isShippingInfoValid = intent.getBooleanExtra("shipping_is_shipping_info_valid", false);
                if (isShippingInfoValid) {
                    PaymentFlowActivity.this.onShippingInfoValidated();
                    PaymentFlowActivity.this.mValidShippingMethods = intent.getParcelableArrayListExtra("valid_shipping_methods");
                    PaymentFlowActivity.this.mDefaultShippingMethod = (ShippingMethod)intent.getParcelableExtra("default_shipping_method");
                } else {
                    PaymentFlowActivity.this.setCommunicatingProgress(false);
                    String shippingInfoError = intent.getStringExtra("shipping_info_error");
                    if (shippingInfoError != null && !shippingInfoError.isEmpty()) {
                        PaymentFlowActivity.this.showError(shippingInfoError);
                    } else {
                        PaymentFlowActivity.this.showError(PaymentFlowActivity.this.getString(R.string.invalid_shipping_information));
                    }
                    PaymentFlowActivity.this.mShippingInformationSubmitted = null;
                }
            }
        };
        this.mShippingInfoSavedBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                PaymentFlowActivity.this.onShippingMethodsReady(PaymentFlowActivity.this.mValidShippingMethods, PaymentFlowActivity.this.mDefaultShippingMethod);
                PaymentFlowActivity.this.mPaymentSessionData.setShippingInformation(PaymentFlowActivity.this.mShippingInformationSubmitted);
            }
        };
        this.setTitle(this.mPaymentFlowPagerAdapter.getPageTitle(this.mViewPager.getCurrentItem()));
    }

    @Override
    protected void onActionSave() {
        if (PaymentFlowPagerEnum.SHIPPING_INFO.equals((Object)this.mPaymentFlowPagerAdapter.getPageAt(this.mViewPager.getCurrentItem()))) {
            this.onShippingInfoSubmitted();
        } else {
            this.onShippingMethodSave();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mShippingInfoSubmittedBroadcastReceiver);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mShippingInfoSavedBroadcastReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mShippingInfoSubmittedBroadcastReceiver, new IntentFilter("shipping_info_processed"));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mShippingInfoSavedBroadcastReceiver, new IntentFilter("shipping_info_saved"));
    }

    private void onShippingInfoValidated() {
        CustomerSession.getInstance().setCustomerShippingInformation(this.mShippingInformationSubmitted);
    }

    private void onShippingMethodsReady(@NonNull List<ShippingMethod> validShippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        this.setCommunicatingProgress(false);
        this.mPaymentFlowPagerAdapter.setShippingMethods(validShippingMethods, defaultShippingMethod);
        this.mPaymentFlowPagerAdapter.setShippingInfoSaved(true);
        if (this.hasNextPage()) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
        } else {
            this.mPaymentSessionData.setShippingInformation(this.mShippingInformationSubmitted);
            this.setResult(-1, new Intent().putExtra("payment_session_data", (Parcelable)this.mPaymentSessionData));
            this.finish();
        }
    }

    private void onShippingInfoSubmitted() {
        ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)this.findViewById(R.id.shipping_info_widget);
        ShippingInformation shippingInformation = shippingInfoWidget.getShippingInformation();
        if (shippingInformation != null) {
            this.mShippingInformationSubmitted = shippingInformation;
            this.setCommunicatingProgress(true);
            this.broadcastShippingInfoSubmitted(shippingInformation);
        }
    }

    private void broadcastShippingInfoSubmitted(ShippingInformation shippingInformation) {
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent("shipping_info_submitted").putExtra("shipping_info_data", (Parcelable)shippingInformation));
    }

    private boolean hasNextPage() {
        return this.mViewPager.getCurrentItem() + 1 < this.mPaymentFlowPagerAdapter.getCount();
    }

    private boolean hasPreviousPage() {
        int currentPageIndex = this.mViewPager.getCurrentItem();
        return currentPageIndex != 0;
    }

    private void onShippingMethodSave() {
        SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)this.findViewById(R.id.select_shipping_method_widget);
        ShippingMethod shippingMethod = selectShippingMethodWidget.getSelectedShippingMethod();
        this.mPaymentSessionData.setShippingMethod(shippingMethod);
        this.setResult(-1, new Intent().putExtra("payment_session_data", (Parcelable)this.mPaymentSessionData));
        this.finish();
    }

    public void onBackPressed() {
        if (this.hasPreviousPage()) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1);
            return;
        }
        super.onBackPressed();
    }
}

