/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeError;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/ErrorParser;", "", "()V", "FIELD_CHARGE", "", "FIELD_CODE", "FIELD_DECLINE_CODE", "FIELD_ERROR", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_TYPE", "MALFORMED_RESPONSE_MESSAGE", "MALFORMED_RESPONSE_MESSAGE$annotations", "parseError", "Lcom/stripe/android/StripeError;", "rawError", "stripe_release"})
public final class ErrorParser {
    @NotNull
    public static final String MALFORMED_RESPONSE_MESSAGE = "An improperly formatted error response was found.";
    private static final String FIELD_CHARGE = "charge";
    private static final String FIELD_CODE = "code";
    private static final String FIELD_DECLINE_CODE = "decline_code";
    private static final String FIELD_ERROR = "error";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_PARAM = "param";
    private static final String FIELD_TYPE = "type";
    public static final ErrorParser INSTANCE;

    @VisibleForTesting
    public static /* synthetic */ void MALFORMED_RESPONSE_MESSAGE$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final StripeError parseError(@Nullable String rawError) {
        String charge = null;
        String code = null;
        String declineCode = null;
        String message = null;
        String param = null;
        String type = null;
        try {
            JSONObject jsonError = new JSONObject(rawError);
            JSONObject errorObject = jsonError.getJSONObject(FIELD_ERROR);
            charge = errorObject.optString(FIELD_CHARGE);
            code = errorObject.optString(FIELD_CODE);
            declineCode = errorObject.optString(FIELD_DECLINE_CODE);
            String string2 = errorObject.optString(FIELD_MESSAGE);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"errorObject.optString(FIELD_MESSAGE)");
            message = string2;
            param = errorObject.optString(FIELD_PARAM);
            type = errorObject.optString(FIELD_TYPE);
        }
        catch (JSONException jsonException) {
            message = MALFORMED_RESPONSE_MESSAGE;
        }
        return new StripeError(type, message, code, param, declineCode, charge);
    }

    private ErrorParser() {
    }

    static {
        ErrorParser errorParser;
        INSTANCE = errorParser = new ErrorParser();
    }
}

