/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class EphemeralKey
extends StripeModel
implements Parcelable {
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_EXPIRES = "expires";
    private static final String FIELD_SECRET = "secret";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ID = "id";
    private static final String FIELD_ASSOCIATED_OBJECTS = "associated_objects";
    private static final String FIELD_TYPE = "type";
    @NonNull
    final String objectId;
    private final long mCreated;
    private final long mExpires;
    @NonNull
    private final String mId;
    private final boolean mLiveMode;
    @NonNull
    private final String mObject;
    @NonNull
    private final String mSecret;
    @NonNull
    private final String mType;

    EphemeralKey(@NonNull Parcel in) {
        this.mCreated = in.readLong();
        this.objectId = Objects.requireNonNull(in.readString());
        this.mExpires = in.readLong();
        this.mId = Objects.requireNonNull(in.readString());
        this.mLiveMode = in.readInt() == 1;
        this.mObject = Objects.requireNonNull(in.readString());
        this.mSecret = Objects.requireNonNull(in.readString());
        this.mType = Objects.requireNonNull(in.readString());
    }

    EphemeralKey(long created, @NonNull String objectId, long expires, @NonNull String id, boolean liveMode, @NonNull String object, @NonNull String secret, @NonNull String type) {
        this.mCreated = created;
        this.objectId = objectId;
        this.mExpires = expires;
        this.mId = id;
        this.mLiveMode = liveMode;
        this.mObject = object;
        this.mSecret = secret;
        this.mType = type;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mCreated);
        out.writeString(this.objectId);
        out.writeLong(this.mExpires);
        out.writeString(this.mId);
        out.writeInt(this.mLiveMode ? 1 : 0);
        out.writeString(this.mObject);
        out.writeString(this.mSecret);
        out.writeString(this.mType);
    }

    long getCreated() {
        return this.mCreated;
    }

    long getExpires() {
        return this.mExpires;
    }

    @NonNull
    String getId() {
        return this.mId;
    }

    boolean isLiveMode() {
        return this.mLiveMode;
    }

    @NonNull
    String getObject() {
        return this.mObject;
    }

    @NonNull
    String getSecret() {
        return this.mSecret;
    }

    @NonNull
    String getType() {
        return this.mType;
    }

    @NonNull
    protected static <TEphemeralKey extends EphemeralKey> TEphemeralKey fromJson(@NonNull JSONObject jsonObject, @NonNull Factory<TEphemeralKey> factory) throws JSONException {
        long created = jsonObject.getLong(FIELD_CREATED);
        long expires = jsonObject.getLong(FIELD_EXPIRES);
        String id = jsonObject.getString(FIELD_ID);
        boolean liveMode = jsonObject.getBoolean(FIELD_LIVEMODE);
        String object = jsonObject.getString(FIELD_OBJECT);
        String secret = jsonObject.getString(FIELD_SECRET);
        JSONArray associatedObjectArray = jsonObject.getJSONArray(FIELD_ASSOCIATED_OBJECTS);
        JSONObject typeObject = associatedObjectArray.getJSONObject(0);
        String type = typeObject.getString(FIELD_TYPE);
        String objectId = typeObject.getString(FIELD_ID);
        return factory.create(created, objectId, expires, id, liveMode, object, secret, type);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof EphemeralKey && this.typedEquals((EphemeralKey)obj);
    }

    private boolean typedEquals(@NonNull EphemeralKey ephemeralKey) {
        return ObjectUtils.equals(this.objectId, ephemeralKey.objectId) && this.mCreated == ephemeralKey.mCreated && this.mExpires == ephemeralKey.mExpires && ObjectUtils.equals(this.mId, ephemeralKey.mId) && this.mLiveMode == ephemeralKey.mLiveMode && ObjectUtils.equals(this.mObject, ephemeralKey.mObject) && ObjectUtils.equals(this.mSecret, ephemeralKey.mSecret) && ObjectUtils.equals(this.mType, ephemeralKey.mType);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(this.objectId, this.mCreated, this.mExpires, this.mId, this.mLiveMode, this.mObject, this.mSecret, this.mType);
    }

    static abstract class Factory<TEphemeralKey extends EphemeralKey> {
        Factory() {
        }

        @NonNull
        abstract TEphemeralKey create(long var1, @NonNull String var3, long var4, @NonNull String var6, boolean var7, @NonNull String var8, @NonNull String var9, @NonNull String var10);
    }
}

