/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.Card;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\bH\u0007J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/CardUtils;", "", "()V", "LENGTH_AMERICAN_EXPRESS", "", "LENGTH_COMMON_CARD", "LENGTH_DINERS_CLUB", "getPossibleCardType", "", "cardNumber", "shouldNormalize", "", "isValidCardLength", "cardBrand", "isValidCardNumber", "isValidLuhnNumber", "stripe_release"})
public final class CardUtils {
    private static final int LENGTH_COMMON_CARD = 16;
    private static final int LENGTH_AMERICAN_EXPRESS = 15;
    private static final int LENGTH_DINERS_CLUB = 14;
    public static final CardUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getPossibleCardType(@Nullable String cardNumber) {
        return INSTANCE.getPossibleCardType(cardNumber, true);
    }

    @JvmStatic
    public static final boolean isValidCardNumber(@Nullable String cardNumber) {
        String normalizedNumber = StripeTextUtils.removeSpacesAndHyphens(cardNumber);
        return CardUtils.isValidLuhnNumber(normalizedNumber) && CardUtils.isValidCardLength(normalizedNumber);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isValidLuhnNumber(@Nullable String cardNumber) {
        void $this$mapIndexedTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List cardNumberReversed;
        block7: {
            if (cardNumber == null) {
                return false;
            }
            cardNumberReversed = CollectionsKt.reversed((Iterable)StringsKt.toList((CharSequence)cardNumber));
            Iterable $this$all$iv = cardNumberReversed;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    char it = ((Character)element$iv2).charValue();
                    boolean bl2 = false;
                    if (Character.isDigit(it)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        Iterable $this$mapIndexed$iv = cardNumberReversed;
        boolean $i$f$mapIndexed = false;
        element$iv2 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void idx;
            void c;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            char c2 = ((Character)item$iv$iv).charValue();
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl4 = false;
            int digitInteger = Character.getNumericValue((char)c) * (idx % 2 == true ? 2 : 1);
            Integer n4 = digitInteger > 9 ? digitInteger - 9 : digitInteger;
            collection2.add(n4);
        }
        int sum = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
        return sum % 10 == 0;
    }

    @JvmStatic
    public static final boolean isValidCardLength(@Nullable String cardNumber) {
        return cardNumber != null && CardUtils.isValidCardLength(cardNumber, INSTANCE.getPossibleCardType(cardNumber, false));
    }

    @JvmStatic
    public static final boolean isValidCardLength(@Nullable String cardNumber, @NotNull String cardBrand) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)cardBrand, (String)"cardBrand");
        if (cardNumber == null || Intrinsics.areEqual((Object)"Unknown", (Object)cardBrand)) {
            return false;
        }
        int length = cardNumber.length();
        switch (cardBrand) {
            case "American Express": {
                if (length == 15) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Diners Club": {
                if (length == 14) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = length == 16;
            }
        }
        return bl;
    }

    private final String getPossibleCardType(String cardNumber, boolean shouldNormalize) {
        if (StripeTextUtils.isBlank(cardNumber)) {
            return "Unknown";
        }
        String spacelessCardNumber = shouldNormalize ? StripeTextUtils.removeSpacesAndHyphens(cardNumber) : cardNumber;
        return StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_AMERICAN_EXPRESS, Card.PREFIXES_AMERICAN_EXPRESS.length)) ? "American Express" : (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_DISCOVER, Card.PREFIXES_DISCOVER.length)) ? "Discover" : (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_JCB, Card.PREFIXES_JCB.length)) ? "JCB" : (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_DINERS_CLUB, Card.PREFIXES_DINERS_CLUB.length)) ? "Diners Club" : (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_VISA, Card.PREFIXES_VISA.length)) ? "Visa" : (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_MASTERCARD, Card.PREFIXES_MASTERCARD.length)) ? "MasterCard" : (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Arrays.copyOf(Card.PREFIXES_UNIONPAY, Card.PREFIXES_UNIONPAY.length)) ? "UnionPay" : "Unknown"))))));
    }

    private CardUtils() {
    }

    static {
        CardUtils cardUtils;
        INSTANCE = cardUtils = new CardUtils();
    }
}

