/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import com.stripe.android.R;
import com.stripe.android.view.ViewUtils;

final class ThemeConfig {
    @NonNull
    final int[] textColorValues;
    @ColorInt
    private final int selectedTextAlphaColorInt;
    @ColorInt
    private final int selectedColorInt;
    @ColorInt
    private final int unselectedColorInt;
    @ColorInt
    private final int unselectedTextAlphaColorInt;
    @ColorInt
    private final int unselectedTextColorInt;

    ThemeConfig(@NonNull Context context) {
        this.selectedColorInt = this.determineColor(context, ViewUtils.getThemeAccentColor((Context)context).data, R.color.accent_color_default);
        this.unselectedColorInt = this.determineColor(context, ViewUtils.getThemeColorControlNormal((Context)context).data, R.color.control_normal_color_default);
        this.unselectedTextColorInt = this.determineColor(context, ViewUtils.getThemeTextColorSecondary((Context)context).data, R.color.color_text_secondary_default);
        this.selectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.selectedColorInt, (int)context.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.unselectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.unselectedTextColorInt, (int)context.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.textColorValues = new int[]{this.selectedColorInt, this.selectedTextAlphaColorInt, this.unselectedTextColorInt, this.unselectedTextAlphaColorInt};
    }

    @ColorInt
    int getTintColor(boolean isSelected) {
        return isSelected ? this.selectedColorInt : this.unselectedColorInt;
    }

    @ColorInt
    int getTextColor(boolean isSelected) {
        return isSelected ? this.selectedColorInt : this.unselectedTextColorInt;
    }

    @ColorInt
    int getTextAlphaColor(boolean isSelected) {
        return isSelected ? this.selectedTextAlphaColorInt : this.unselectedTextAlphaColorInt;
    }

    @ColorInt
    private int determineColor(@NonNull Context context, @ColorInt int defaultColor, @ColorRes int colorIfTransparent) {
        return ViewUtils.isColorTransparent(defaultColor) ? ContextCompat.getColor((Context)context, (int)colorIfTransparent) : defaultColor;
    }
}

