/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.AddPaymentMethodActivity;
import com.stripe.android.view.AddPaymentMethodView;
import com.stripe.android.view.CardMultilineWidget;

class AddPaymentMethodCardView
extends AddPaymentMethodView {
    @NonNull
    private final CardMultilineWidget mCardMultilineWidget;

    @NonNull
    static AddPaymentMethodCardView create(@NonNull Context context, boolean shouldShowPostalCode) {
        return new AddPaymentMethodCardView(context, null, 0, shouldShowPostalCode);
    }

    AddPaymentMethodCardView(@NonNull Context context) {
        this(context, null);
    }

    AddPaymentMethodCardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    AddPaymentMethodCardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, false);
    }

    private AddPaymentMethodCardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, boolean shouldShowPostalCode) {
        super(context, attrs, defStyleAttr);
        AddPaymentMethodCardView.inflate((Context)this.getContext(), (int)R.layout.add_payment_method_card_layout, (ViewGroup)this);
        this.mCardMultilineWidget = (CardMultilineWidget)this.findViewById(R.id.add_source_card_entry_widget);
        this.mCardMultilineWidget.setShouldShowPostalCode(shouldShowPostalCode);
        this.initEnterListeners();
    }

    private void initEnterListeners() {
        AddPaymentMethodActivity activity = (AddPaymentMethodActivity)this.getContext();
        OnEditorActionListenerImpl listener = new OnEditorActionListenerImpl(activity, this, (InputMethodManager)activity.getSystemService("input_method"));
        ((TextView)this.mCardMultilineWidget.findViewById(R.id.et_add_source_card_number_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
        ((TextView)this.mCardMultilineWidget.findViewById(R.id.et_add_source_expiry_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
        ((TextView)this.mCardMultilineWidget.findViewById(R.id.et_add_source_cvc_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
        ((TextView)this.mCardMultilineWidget.findViewById(R.id.et_add_source_postal_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getCreateParams() {
        return this.mCardMultilineWidget.getPaymentMethodCreateParams();
    }

    @Override
    public void setCommunicatingProgress(boolean communicating) {
        this.mCardMultilineWidget.setEnabled(!communicating);
    }

    static final class OnEditorActionListenerImpl
    implements TextView.OnEditorActionListener {
        @NonNull
        private final AddPaymentMethodActivity mActivity;
        @NonNull
        private final AddPaymentMethodCardView mAddPaymentMethodCardView;
        @NonNull
        private final InputMethodManager mInputMethodManager;

        OnEditorActionListenerImpl(@NonNull AddPaymentMethodActivity activity, @NonNull AddPaymentMethodCardView addPaymentMethodCardView, @NonNull InputMethodManager inputMethodManager) {
            this.mActivity = activity;
            this.mAddPaymentMethodCardView = addPaymentMethodCardView;
            this.mInputMethodManager = inputMethodManager;
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            if (actionId == 6) {
                if (this.mAddPaymentMethodCardView.getCreateParams() != null) {
                    this.mInputMethodManager.hideSoftInputFromWindow(this.mActivity.getWindowToken(), 0);
                }
                this.mActivity.onActionSave();
                return true;
            }
            return false;
        }
    }
}

