/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.stripe.android.StripeUid;
import com.stripe.android.Supplier;
import com.stripe.android.utils.ObjectUtils;

final class UidSupplier
implements Supplier<StripeUid> {
    @NonNull
    private final ContentResolver mContentResolver;

    UidSupplier(@NonNull Context context) {
        this.mContentResolver = context.getApplicationContext().getContentResolver();
    }

    @Override
    @NonNull
    public StripeUid get() {
        String androidId = Settings.Secure.getString((ContentResolver)this.mContentResolver, (String)"android_id");
        return StripeUid.create(ObjectUtils.getOrDefault(androidId, ""));
    }
}

