/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.ViewUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MaskedCardView
extends LinearLayout {
    private String mCardBrand;
    private String mLast4;
    private boolean mIsSelected;
    @NonNull
    private final AppCompatImageView mCardIconImageView;
    @NonNull
    private final AppCompatTextView mCardInformationTextView;
    @NonNull
    private final AppCompatImageView mCheckMarkImageView;
    @ColorInt
    private final int mSelectedAlphaColorInt;
    @ColorInt
    private final int mSelectedColorInt;
    @ColorInt
    private final int mUnselectedColorInt;
    @ColorInt
    private final int mUnselectedTextAlphaColorInt;
    @ColorInt
    private final int mUnselectedTextColorInt;
    @NonNull
    private final int[] mTextColorValues;
    @NonNull
    private static final Map<String, Integer> ICON_RESOURCE_MAP = new HashMap<String, Integer>();
    @NonNull
    private static final Map<String, Integer> BRAND_RESOURCE_MAP = new HashMap<String, Integer>();

    public MaskedCardView(@NonNull Context context) {
        this(context, null);
    }

    public MaskedCardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskedCardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        MaskedCardView.inflate((Context)this.getContext(), (int)R.layout.masked_card_view, (ViewGroup)this);
        this.mCardIconImageView = (AppCompatImageView)this.findViewById(R.id.masked_icon_view);
        this.mCardInformationTextView = (AppCompatTextView)this.findViewById(R.id.masked_card_info_view);
        this.mCheckMarkImageView = (AppCompatImageView)this.findViewById(R.id.masked_check_icon);
        this.mSelectedColorInt = this.determineColor(ViewUtils.getThemeAccentColor((Context)this.getContext()).data, R.color.accent_color_default);
        this.mUnselectedColorInt = this.determineColor(ViewUtils.getThemeColorControlNormal((Context)this.getContext()).data, R.color.control_normal_color_default);
        this.mUnselectedTextColorInt = this.determineColor(ViewUtils.getThemeTextColorSecondary((Context)this.getContext()).data, R.color.color_text_secondary_default);
        this.mSelectedAlphaColorInt = ColorUtils.setAlphaComponent((int)this.mSelectedColorInt, (int)this.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.mUnselectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.mUnselectedTextColorInt, (int)this.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.mTextColorValues = new int[]{this.mSelectedColorInt, this.mSelectedAlphaColorInt, this.mUnselectedTextColorInt, this.mUnselectedTextAlphaColorInt};
        this.initializeCheckMark();
        this.updateCheckMark();
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean selected) {
        this.mIsSelected = selected;
        this.updateCheckMark();
        this.updateUi();
    }

    void setPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.mCardBrand = paymentMethod.card != null ? paymentMethod.card.brand : "unknown";
        this.mLast4 = paymentMethod.card != null ? paymentMethod.card.last4 : "";
        this.updateUi();
    }

    private void updateUi() {
        this.updateBrandIcon();
        this.mCardInformationTextView.setText((CharSequence)this.createDisplayString());
    }

    void toggleSelected() {
        this.setSelected(!this.mIsSelected);
    }

    @NonNull
    @VisibleForTesting
    int[] getTextColorValues() {
        return this.mTextColorValues;
    }

    @VisibleForTesting
    String getCardBrand() {
        return this.mCardBrand;
    }

    @VisibleForTesting
    String getLast4() {
        return this.mLast4;
    }

    private void initializeCheckMark() {
        this.updateDrawable(R.drawable.ic_checkmark, (ImageView)this.mCheckMarkImageView, true);
    }

    private void updateBrandIcon() {
        if (this.mCardBrand == null || !ICON_RESOURCE_MAP.containsKey(this.mCardBrand)) {
            return;
        }
        int iconResourceId = Objects.requireNonNull(ICON_RESOURCE_MAP.get(this.mCardBrand));
        this.updateDrawable(iconResourceId, (ImageView)this.mCardIconImageView, false);
    }

    private void updateDrawable(@DrawableRes int resourceId, @NonNull ImageView imageView, boolean isCheckMark) {
        Drawable icon = Objects.requireNonNull(ContextCompat.getDrawable((Context)this.getContext(), (int)resourceId));
        int tintColor = this.mIsSelected || isCheckMark ? this.mSelectedColorInt : this.mUnselectedColorInt;
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)tintColor);
        imageView.setImageDrawable(compatIcon);
    }

    @NonNull
    private SpannableString createDisplayString() {
        String brandText = BRAND_RESOURCE_MAP.containsKey(this.mCardBrand) ? this.getResources().getString(Objects.requireNonNull(BRAND_RESOURCE_MAP.get(this.mCardBrand)).intValue()) : this.getResources().getString(R.string.unknown);
        String cardEndingIn = this.getResources().getString(R.string.ending_in, new Object[]{brandText, this.mLast4});
        int totalLength = cardEndingIn.length();
        int brandLength = brandText.length();
        int last4length = this.mLast4.length();
        int last4Start = totalLength - last4length;
        int textColor = this.mIsSelected ? this.mSelectedColorInt : this.mUnselectedTextColorInt;
        int lightTextColor = this.mIsSelected ? this.mSelectedAlphaColorInt : this.mUnselectedTextAlphaColorInt;
        SpannableString displayString = new SpannableString((CharSequence)cardEndingIn);
        displayString.setSpan((Object)new TypefaceSpan("sans-serif-medium"), 0, brandLength, 33);
        displayString.setSpan((Object)new ForegroundColorSpan(textColor), 0, brandLength, 33);
        displayString.setSpan((Object)new ForegroundColorSpan(lightTextColor), brandLength, last4Start, 33);
        displayString.setSpan((Object)new TypefaceSpan("sans-serif-medium"), last4Start, totalLength, 33);
        displayString.setSpan((Object)new ForegroundColorSpan(textColor), last4Start, totalLength, 33);
        return displayString;
    }

    private void updateCheckMark() {
        if (this.mIsSelected) {
            this.mCheckMarkImageView.setVisibility(0);
        } else {
            this.mCheckMarkImageView.setVisibility(4);
        }
    }

    @ColorInt
    private int determineColor(@ColorInt int defaultColor, @ColorRes int colorIfTransparent) {
        return ViewUtils.isColorTransparent(defaultColor) ? ContextCompat.getColor((Context)this.getContext(), (int)colorIfTransparent) : defaultColor;
    }

    static {
        ICON_RESOURCE_MAP.put("amex", R.drawable.ic_amex_template_32);
        ICON_RESOURCE_MAP.put("diners", R.drawable.ic_diners_template_32);
        ICON_RESOURCE_MAP.put("discover", R.drawable.ic_discover_template_32);
        ICON_RESOURCE_MAP.put("jcb", R.drawable.ic_jcb_template_32);
        ICON_RESOURCE_MAP.put("mastercard", R.drawable.ic_mastercard_template_32);
        ICON_RESOURCE_MAP.put("visa", R.drawable.ic_visa_template_32);
        ICON_RESOURCE_MAP.put("unionpay", R.drawable.ic_unionpay_template_32);
        ICON_RESOURCE_MAP.put("unknown", R.drawable.ic_unknown);
        BRAND_RESOURCE_MAP.put("amex", R.string.amex_short);
        BRAND_RESOURCE_MAP.put("diners", R.string.diners_club);
        BRAND_RESOURCE_MAP.put("discover", R.string.discover);
        BRAND_RESOURCE_MAP.put("jcb", R.string.jcb);
        BRAND_RESOURCE_MAP.put("mastercard", R.string.mastercard);
        BRAND_RESOURCE_MAP.put("visa", R.string.visa);
        BRAND_RESOURCE_MAP.put("unionpay", R.string.unionpay);
        BRAND_RESOURCE_MAP.put("unknown", R.string.unknown);
    }
}

