/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.stripe.android.R;
import com.stripe.android.view.CountryAdapter;
import com.stripe.android.view.CountryUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CountryAutoCompleteTextView
extends FrameLayout {
    @NonNull
    private final AutoCompleteTextView mCountryAutocomplete;
    @NonNull
    private final Map<String, String> mCountryNameToCode;
    @VisibleForTesting
    String mCountrySelected;
    @Nullable
    private CountryChangeListener mCountryChangeListener;

    public CountryAutoCompleteTextView(@NonNull Context context) {
        this(context, null);
    }

    public CountryAutoCompleteTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CountryAutoCompleteTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        CountryAutoCompleteTextView.inflate((Context)this.getContext(), (int)R.layout.country_autocomplete_textview, (ViewGroup)this);
        this.mCountryAutocomplete = (AutoCompleteTextView)this.findViewById(R.id.autocomplete_country_cat);
        this.mCountryNameToCode = CountryUtils.getCountryNameToCodeMap();
        CountryAdapter countryAdapter = new CountryAdapter(this.getContext(), new ArrayList<String>(this.mCountryNameToCode.keySet()));
        this.mCountryAutocomplete.setThreshold(0);
        this.mCountryAutocomplete.setAdapter((ListAdapter)countryAdapter);
        this.mCountryAutocomplete.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                String countryEntered = CountryAutoCompleteTextView.this.mCountryAutocomplete.getText().toString();
                CountryAutoCompleteTextView.this.updateUiForCountryEntered(countryEntered);
            }
        });
        String defaultCountryEntered = (String)Objects.requireNonNull(countryAdapter.getItem(0));
        this.updateUiForCountryEntered(defaultCountryEntered);
        this.mCountryAutocomplete.setText((CharSequence)defaultCountryEntered);
        this.mCountryAutocomplete.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean focused) {
                String countryEntered = CountryAutoCompleteTextView.this.mCountryAutocomplete.getText().toString();
                if (focused) {
                    CountryAutoCompleteTextView.this.mCountryAutocomplete.showDropDown();
                } else {
                    CountryAutoCompleteTextView.this.updateUiForCountryEntered(countryEntered);
                }
            }
        });
    }

    @Nullable
    String getSelectedCountryCode() {
        return this.mCountrySelected;
    }

    void setCountrySelected(@Nullable String countryCode) {
        if (countryCode == null) {
            return;
        }
        this.updateUiForCountryEntered(CountryAutoCompleteTextView.getDisplayCountry(countryCode));
    }

    void setCountryChangeListener(@Nullable CountryChangeListener countryChangeListener) {
        this.mCountryChangeListener = countryChangeListener;
    }

    @VisibleForTesting
    void updateUiForCountryEntered(@NonNull String displayCountryEntered) {
        String countryCodeEntered = this.mCountryNameToCode.get(displayCountryEntered);
        if (countryCodeEntered != null) {
            if (this.mCountrySelected == null || !this.mCountrySelected.equals(countryCodeEntered)) {
                this.mCountrySelected = countryCodeEntered;
                if (this.mCountryChangeListener != null) {
                    this.mCountryChangeListener.onCountryChanged(this.mCountrySelected);
                }
            }
            this.mCountryAutocomplete.setText((CharSequence)displayCountryEntered);
        } else if (this.mCountrySelected != null) {
            this.mCountryAutocomplete.setText((CharSequence)CountryAutoCompleteTextView.getDisplayCountry(this.mCountrySelected));
        }
    }

    @NonNull
    private static String getDisplayCountry(@NonNull String countryCode) {
        return new Locale("", countryCode).getDisplayCountry();
    }

    static interface CountryChangeListener {
        public void onCountryChanged(@NonNull String var1);
    }
}

