/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import java.util.Objects;

public abstract class ActivityStarter<TargetActivityType extends Activity, ArgsType extends Args> {
    @NonNull
    private final Activity mActivity;
    @Nullable
    private final Fragment mFragment;
    @NonNull
    private final Class<TargetActivityType> mTargetClass;
    @NonNull
    private final ArgsType mDefaultArgs;

    ActivityStarter(@NonNull Activity activity, @NonNull Class<TargetActivityType> targetClass, @NonNull ArgsType args) {
        this.mActivity = activity;
        this.mFragment = null;
        this.mTargetClass = targetClass;
        this.mDefaultArgs = args;
    }

    ActivityStarter(@NonNull Fragment fragment, @NonNull Class<TargetActivityType> targetClass, @NonNull ArgsType args) {
        this.mActivity = fragment.requireActivity();
        this.mFragment = fragment;
        this.mTargetClass = targetClass;
        this.mDefaultArgs = args;
    }

    public final void startForResult(int requestCode) {
        this.startForResult(requestCode, this.mDefaultArgs);
    }

    public final void startForResult(int requestCode, @NonNull ArgsType args) {
        Intent intent = this.newIntent().putExtra("EXTRA_ARGS", args);
        if (this.mFragment != null) {
            Objects.requireNonNull(this.mFragment).startActivityForResult(intent, requestCode);
        } else {
            this.mActivity.startActivityForResult(intent, requestCode);
        }
    }

    @NonNull
    final Intent newIntent() {
        return new Intent((Context)this.mActivity, this.mTargetClass);
    }

    public static interface Args
    extends Parcelable {
        public static final String EXTRA = "EXTRA_ARGS";
    }
}

