/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.AuthActivityStarter;
import com.stripe.android.view.PaymentRelayActivity;

class Stripe3ds2CompletionStarter
implements AuthActivityStarter<StartData> {
    @NonNull
    private final AuthActivityStarter.Host mHost;
    private final int mRequestCode;

    Stripe3ds2CompletionStarter(@NonNull AuthActivityStarter.Host host, int requestCode) {
        this.mHost = host;
        this.mRequestCode = requestCode;
    }

    @Override
    public void start(@NonNull StartData data) {
        Bundle extras = new Bundle();
        extras.putString("client_secret", data.mStripeIntent.getClientSecret());
        extras.putInt("flow_outcome", data.getOutcome());
        this.mHost.startActivityForResult(PaymentRelayActivity.class, extras, this.mRequestCode);
    }

    static class StartData {
        @NonNull
        private final StripeIntent mStripeIntent;
        private final int mChallengeFlowOutcome;

        StartData(@NonNull StripeIntent stripeIntent, int challengeFlowOutcome) {
            this.mStripeIntent = stripeIntent;
            this.mChallengeFlowOutcome = challengeFlowOutcome;
        }

        private int getOutcome() {
            if (this.mChallengeFlowOutcome == 0) {
                return 1;
            }
            if (this.mChallengeFlowOutcome == 1) {
                return 2;
            }
            if (this.mChallengeFlowOutcome == 2) {
                return 3;
            }
            if (this.mChallengeFlowOutcome == 3) {
                return 4;
            }
            return 2;
        }

        public int hashCode() {
            return ObjectUtils.hash(this.mStripeIntent, this.mChallengeFlowOutcome);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof StartData && this.typedEquals((StartData)obj);
        }

        private boolean typedEquals(@NonNull StartData startData) {
            return ObjectUtils.equals(this.mStripeIntent, startData.mStripeIntent) && ObjectUtils.equals(this.mChallengeFlowOutcome, startData.mChallengeFlowOutcome);
        }
    }
}

