/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.SourceParams;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ConfirmPaymentIntentParams
implements ConfirmStripeIntentParams {
    public static final String API_PARAM_SOURCE_DATA = "source_data";
    public static final String API_PARAM_PAYMENT_METHOD_DATA = "payment_method_data";
    static final String API_PARAM_SOURCE_ID = "source";
    static final String API_PARAM_SAVE_PAYMENT_METHOD = "save_payment_method";
    @Nullable
    private final PaymentMethodCreateParams mPaymentMethodCreateParams;
    @Nullable
    private final String mPaymentMethodId;
    @Nullable
    private final SourceParams mSourceParams;
    @Nullable
    private final String mSourceId;
    @Nullable
    private final Map<String, Object> mExtraParams;
    @NonNull
    private final String mClientSecret;
    @Nullable
    private final String mReturnUrl;
    private final boolean mSavePaymentMethod;
    private final boolean mUseStripeSdk;

    private ConfirmPaymentIntentParams(@NonNull Builder builder) {
        this.mClientSecret = builder.mClientSecret;
        this.mReturnUrl = builder.mReturnUrl;
        this.mPaymentMethodId = builder.mPaymentMethodId;
        this.mPaymentMethodCreateParams = builder.mPaymentMethodCreateParams;
        this.mSourceId = builder.mSourceId;
        this.mSourceParams = builder.mSourceParams;
        this.mSavePaymentMethod = builder.mSavePaymentMethod;
        this.mExtraParams = builder.mExtraParams;
        this.mUseStripeSdk = builder.mShouldUseSdk;
    }

    @NonNull
    public static ConfirmPaymentIntentParams create(@NonNull String clientSecret, @Nullable String returnUrl, @Nullable Map<String, Object> extraParams) {
        return new Builder(clientSecret).setReturnUrl(returnUrl).setExtraParams(extraParams).build();
    }

    @NonNull
    public static ConfirmPaymentIntentParams create(@NonNull String clientSecret, @Nullable String returnUrl) {
        return ConfirmPaymentIntentParams.create(clientSecret, returnUrl, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams create(@NonNull String clientSecret) {
        return ConfirmPaymentIntentParams.create(clientSecret, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodId(@NonNull String paymentMethodId, @NonNull String clientSecret, @Nullable String returnUrl, boolean savePaymentMethod, @Nullable Map<String, Object> extraParams) {
        return new Builder(clientSecret).setPaymentMethodId(paymentMethodId).setReturnUrl(returnUrl).setSavePaymentMethod(savePaymentMethod).setExtraParams(extraParams).build();
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodId(@NonNull String paymentMethodId, @NonNull String clientSecret, @Nullable String returnUrl, boolean savePaymentMethod) {
        return ConfirmPaymentIntentParams.createWithPaymentMethodId(paymentMethodId, clientSecret, returnUrl, savePaymentMethod, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodId(@NonNull String paymentMethodId, @NonNull String clientSecret, @Nullable String returnUrl) {
        return ConfirmPaymentIntentParams.createWithPaymentMethodId(paymentMethodId, clientSecret, returnUrl, false);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodId(@NonNull String paymentMethodId, @NonNull String clientSecret) {
        return ConfirmPaymentIntentParams.createWithPaymentMethodId(paymentMethodId, clientSecret, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodCreateParams(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String clientSecret, @Nullable String returnUrl, boolean savePaymentMethod, @Nullable Map<String, Object> extraParams) {
        return new Builder(clientSecret).setPaymentMethodCreateParams(paymentMethodCreateParams).setReturnUrl(returnUrl).setSavePaymentMethod(savePaymentMethod).setExtraParams(extraParams).build();
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodCreateParams(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String clientSecret, @Nullable String returnUrl, boolean savePaymentMethod) {
        return ConfirmPaymentIntentParams.createWithPaymentMethodCreateParams(paymentMethodCreateParams, clientSecret, returnUrl, savePaymentMethod, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodCreateParams(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String clientSecret, @Nullable String returnUrl) {
        return ConfirmPaymentIntentParams.createWithPaymentMethodCreateParams(paymentMethodCreateParams, clientSecret, returnUrl, false);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithPaymentMethodCreateParams(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String clientSecret) {
        return ConfirmPaymentIntentParams.createWithPaymentMethodCreateParams(paymentMethodCreateParams, clientSecret, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithSourceId(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String returnUrl, boolean savePaymentMethod, @Nullable Map<String, Object> extraParams) {
        return new Builder(clientSecret).setSourceId(sourceId).setReturnUrl(returnUrl).setSavePaymentMethod(savePaymentMethod).setExtraParams(extraParams).build();
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithSourceId(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String returnUrl, boolean savePaymentMethod) {
        return ConfirmPaymentIntentParams.createWithSourceId(sourceId, clientSecret, returnUrl, savePaymentMethod, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithSourceId(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String returnUrl) {
        return ConfirmPaymentIntentParams.createWithSourceId(sourceId, clientSecret, returnUrl, false);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithSourceParams(@NonNull SourceParams sourceParams, @NonNull String clientSecret, @NonNull String returnUrl, boolean savePaymentMethod, @Nullable Map<String, Object> extraParams) {
        return new Builder(clientSecret).setSourceParams(sourceParams).setReturnUrl(returnUrl).setSavePaymentMethod(savePaymentMethod).setExtraParams(extraParams).build();
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithSourceParams(@NonNull SourceParams sourceParams, @NonNull String clientSecret, @NonNull String returnUrl, boolean savePaymentMethod) {
        return ConfirmPaymentIntentParams.createWithSourceParams(sourceParams, clientSecret, returnUrl, savePaymentMethod, null);
    }

    @NonNull
    public static ConfirmPaymentIntentParams createWithSourceParams(@NonNull SourceParams sourceParams, @NonNull String clientSecret, @NonNull String returnUrl) {
        return ConfirmPaymentIntentParams.createWithSourceParams(sourceParams, clientSecret, returnUrl, false);
    }

    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        return this.mPaymentMethodCreateParams;
    }

    @Nullable
    public String getPaymentMethodId() {
        return this.mPaymentMethodId;
    }

    @Nullable
    public SourceParams getSourceParams() {
        return this.mSourceParams;
    }

    @Nullable
    public String getSourceId() {
        return this.mSourceId;
    }

    @Nullable
    public Map<String, Object> getExtraParams() {
        return this.mExtraParams;
    }

    @Override
    @NonNull
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public String getReturnUrl() {
        return this.mReturnUrl;
    }

    public boolean shouldSavePaymentMethod() {
        return this.mSavePaymentMethod;
    }

    @Override
    public boolean shouldUseStripeSdk() {
        return this.mUseStripeSdk;
    }

    @Override
    @NonNull
    public ConfirmPaymentIntentParams withShouldUseStripeSdk(boolean shouldUseStripeSdk) {
        return this.toBuilder().setShouldUseSdk(shouldUseStripeSdk).build();
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        if (this.mPaymentMethodCreateParams != null) {
            ((AbstractMap)networkReadyMap).put(API_PARAM_PAYMENT_METHOD_DATA, this.mPaymentMethodCreateParams.toParamMap());
        } else if (this.mPaymentMethodId != null) {
            ((AbstractMap)networkReadyMap).put("payment_method", this.mPaymentMethodId);
        } else if (this.mSourceParams != null) {
            ((AbstractMap)networkReadyMap).put(API_PARAM_SOURCE_DATA, this.mSourceParams.toParamMap());
        } else if (this.mSourceId != null) {
            ((AbstractMap)networkReadyMap).put(API_PARAM_SOURCE_ID, this.mSourceId);
        }
        if (this.mReturnUrl != null) {
            ((AbstractMap)networkReadyMap).put("return_url", this.mReturnUrl);
        }
        ((AbstractMap)networkReadyMap).put("client_secret", this.mClientSecret);
        if (this.mExtraParams != null) {
            ((AbstractMap)networkReadyMap).putAll(this.mExtraParams);
        }
        if (this.mSavePaymentMethod) {
            ((AbstractMap)networkReadyMap).put(API_PARAM_SAVE_PAYMENT_METHOD, true);
        }
        if (this.mUseStripeSdk) {
            ((AbstractMap)networkReadyMap).put("use_stripe_sdk", true);
        }
        return networkReadyMap;
    }

    @NonNull
    private Builder toBuilder() {
        return new Builder(this.mClientSecret).setReturnUrl(this.mReturnUrl).setPaymentMethodId(this.mPaymentMethodId).setPaymentMethodCreateParams(this.mPaymentMethodCreateParams).setSourceId(this.mSourceId).setSourceParams(this.mSourceParams).setSavePaymentMethod(this.mSavePaymentMethod).setExtraParams(this.mExtraParams);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ConfirmPaymentIntentParams && this.typedEquals((ConfirmPaymentIntentParams)obj);
    }

    private boolean typedEquals(@NonNull ConfirmPaymentIntentParams params) {
        return ObjectUtils.equals(this.mReturnUrl, params.mReturnUrl) && ObjectUtils.equals(this.mClientSecret, params.mClientSecret) && ObjectUtils.equals(this.mPaymentMethodId, params.mPaymentMethodId) && ObjectUtils.equals(this.mPaymentMethodCreateParams, params.mPaymentMethodCreateParams) && ObjectUtils.equals(this.mSourceId, params.mSourceId) && ObjectUtils.equals(this.mSourceParams, params.mSourceParams) && ObjectUtils.equals(this.mExtraParams, params.mExtraParams) && ObjectUtils.equals(this.mSavePaymentMethod, params.mSavePaymentMethod) && ObjectUtils.equals(this.mUseStripeSdk, params.mUseStripeSdk);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mReturnUrl, this.mClientSecret, this.mPaymentMethodId, this.mPaymentMethodCreateParams, this.mSourceId, this.mSourceParams, this.mExtraParams, this.mSavePaymentMethod, this.mUseStripeSdk);
    }

    private static final class Builder
    implements ObjectBuilder<ConfirmPaymentIntentParams> {
        @NonNull
        private final String mClientSecret;
        @Nullable
        private PaymentMethodCreateParams mPaymentMethodCreateParams;
        @Nullable
        private String mPaymentMethodId;
        @Nullable
        private SourceParams mSourceParams;
        @Nullable
        private String mSourceId;
        @Nullable
        private Map<String, Object> mExtraParams;
        @Nullable
        private String mReturnUrl;
        private boolean mSavePaymentMethod;
        private boolean mShouldUseSdk;

        private Builder(@NonNull String clientSecret) {
            this.mClientSecret = Objects.requireNonNull(clientSecret);
        }

        @NonNull
        private Builder setPaymentMethodCreateParams(@NonNull PaymentMethodCreateParams paymentMethodCreateParams) {
            this.mPaymentMethodCreateParams = paymentMethodCreateParams;
            return this;
        }

        @NonNull
        private Builder setPaymentMethodId(@NonNull String paymentMethodId) {
            this.mPaymentMethodId = paymentMethodId;
            return this;
        }

        @NonNull
        private Builder setSourceParams(@NonNull SourceParams sourceParams) {
            this.mSourceParams = sourceParams;
            return this;
        }

        @NonNull
        private Builder setSourceId(@Nullable String sourceId) {
            this.mSourceId = sourceId;
            return this;
        }

        @NonNull
        private Builder setReturnUrl(@Nullable String returnUrl) {
            this.mReturnUrl = returnUrl;
            return this;
        }

        @NonNull
        private Builder setExtraParams(@Nullable Map<String, Object> extraParams) {
            this.mExtraParams = extraParams;
            return this;
        }

        @NonNull
        private Builder setSavePaymentMethod(boolean savePaymentMethod) {
            this.mSavePaymentMethod = savePaymentMethod;
            return this;
        }

        @NonNull
        private Builder setShouldUseSdk(boolean shouldUseSdk) {
            this.mShouldUseSdk = shouldUseSdk;
            return this;
        }

        @Override
        @NonNull
        public ConfirmPaymentIntentParams build() {
            return new ConfirmPaymentIntentParams(this);
        }
    }
}

