/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONException;
import org.json.JSONObject;

public final class BankAccount {
    private static final String FIELD_ACCOUNT_HOLDER_NAME = "account_holder_name";
    private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
    private static final String FIELD_BANK_NAME = "bank_name";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_ROUTING_NUMBER = "routing_number";
    @Nullable
    private final String mAccountHolderName;
    @Nullable
    private final String mAccountHolderType;
    @Nullable
    private final String mAccountNumber;
    @Nullable
    private final String mBankName;
    @Nullable
    @Size(value=2L)
    private final String mCountryCode;
    @Nullable
    @Size(value=3L)
    private final String mCurrency;
    @Nullable
    private final String mFingerprint;
    @Nullable
    private final String mLast4;
    @Nullable
    private final String mRoutingNumber;

    public BankAccount(@NonNull String accountNumber, @NonNull @Size(value=2L) String countryCode, @NonNull @Size(value=3L) String currency, @Nullable String routingNumber) {
        this(accountNumber, null, null, null, countryCode, currency, null, null, routingNumber);
    }

    public BankAccount(@Nullable String accountHolderName, @Nullable String accountHolderType, @Nullable String bankName, @Nullable @Size(value=2L) String countryCode, @Nullable @Size(value=3L) String currency, @Nullable String fingerprint, @Nullable String last4, @Nullable String routingNumber) {
        this(null, accountHolderName, accountHolderType, bankName, countryCode, currency, fingerprint, last4, routingNumber);
    }

    public BankAccount(@Nullable String accountNumber, @Nullable String accountHolderName, @Nullable String accountHolderType, @Nullable String bankName, @Nullable @Size(value=2L) String countryCode, @Nullable @Size(value=3L) String currency, @Nullable String fingerprint, @Nullable String last4, @Nullable String routingNumber) {
        this.mAccountNumber = accountNumber;
        this.mAccountHolderName = accountHolderName;
        this.mAccountHolderType = accountHolderType;
        this.mBankName = bankName;
        this.mCountryCode = countryCode;
        this.mCurrency = currency;
        this.mFingerprint = fingerprint;
        this.mLast4 = last4;
        this.mRoutingNumber = routingNumber;
    }

    @Nullable
    public String getAccountNumber() {
        return this.mAccountNumber;
    }

    @Nullable
    public String getAccountHolderName() {
        return this.mAccountHolderName;
    }

    @Nullable
    public String getAccountHolderType() {
        return this.mAccountHolderType;
    }

    @Nullable
    public String getBankName() {
        return this.mBankName;
    }

    @Nullable
    @Size(value=2L)
    public String getCountryCode() {
        return this.mCountryCode;
    }

    @Nullable
    @Size(value=3L)
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getFingerprint() {
        return this.mFingerprint;
    }

    @Nullable
    public String getLast4() {
        return this.mLast4;
    }

    @Nullable
    public String getRoutingNumber() {
        return this.mRoutingNumber;
    }

    @Nullable
    public static String asBankAccountType(@Nullable String possibleAccountType) {
        if ("company".equals(possibleAccountType)) {
            return "company";
        }
        if ("individual".equals(possibleAccountType)) {
            return "individual";
        }
        return null;
    }

    @Nullable
    public static BankAccount fromString(@Nullable String jsonString) {
        try {
            JSONObject accountObject = new JSONObject(jsonString);
            return BankAccount.fromJson(accountObject);
        }
        catch (JSONException jsonException) {
            return null;
        }
    }

    @Nullable
    public static BankAccount fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new BankAccount(StripeJsonUtils.optString(jsonObject, FIELD_ACCOUNT_HOLDER_NAME), BankAccount.asBankAccountType(StripeJsonUtils.optString(jsonObject, FIELD_ACCOUNT_HOLDER_TYPE)), StripeJsonUtils.optString(jsonObject, FIELD_BANK_NAME), StripeJsonUtils.optCountryCode(jsonObject, FIELD_COUNTRY), StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY), StripeJsonUtils.optString(jsonObject, FIELD_FINGERPRINT), StripeJsonUtils.optString(jsonObject, FIELD_LAST4), StripeJsonUtils.optString(jsonObject, FIELD_ROUTING_NUMBER));
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mAccountHolderName, this.mAccountHolderType, this.mAccountNumber, this.mBankName, this.mCountryCode, this.mCurrency, this.mFingerprint, this.mLast4, this.mRoutingNumber);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof BankAccount && this.typedEquals((BankAccount)obj);
    }

    private boolean typedEquals(@NonNull BankAccount bankAccount) {
        return ObjectUtils.equals(this.mAccountHolderName, bankAccount.mAccountHolderName) && ObjectUtils.equals(this.mAccountHolderType, bankAccount.mAccountHolderType) && ObjectUtils.equals(this.mAccountNumber, bankAccount.mAccountNumber) && ObjectUtils.equals(this.mBankName, bankAccount.mBankName) && ObjectUtils.equals(this.mCountryCode, bankAccount.mCountryCode) && ObjectUtils.equals(this.mCurrency, bankAccount.mCurrency) && ObjectUtils.equals(this.mFingerprint, bankAccount.mFingerprint) && ObjectUtils.equals(this.mLast4, bankAccount.mLast4) && ObjectUtils.equals(this.mRoutingNumber, bankAccount.mRoutingNumber);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BankAccountType {
        public static final String COMPANY = "company";
        public static final String INDIVIDUAL = "individual";
    }
}

