/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ProgressBar;
import com.stripe.android.R;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.view.PaymentAuthWebView;

public class PaymentAuthWebViewActivity
extends AppCompatActivity {
    @Nullable
    private ToolbarCustomization mToolbarCustomization;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent().setAction("com.ul.sdk.HANDLE_CHALLENGE_ACTION"));
        this.setContentView(R.layout.payment_auth_web_view_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.payment_auth_web_view_toolbar);
        this.setSupportActionBar(toolbar);
        this.mToolbarCustomization = (ToolbarCustomization)this.getIntent().getParcelableExtra("ui_customization");
        this.customizeToolbar(toolbar);
        String clientSecret = this.getIntent().getStringExtra("client_secret");
        String returnUrl = this.getIntent().getStringExtra("return_url");
        this.setResult(-1, new Intent().putExtra("client_secret", clientSecret));
        PaymentAuthWebView webView = (PaymentAuthWebView)this.findViewById(R.id.auth_web_view);
        ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.auth_web_view_progress_bar);
        webView.init((Activity)this, progressBar, clientSecret, returnUrl);
        webView.loadUrl(this.getIntent().getStringExtra("auth_url"));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.payment_auth_web_view_menu, menu2);
        if (this.mToolbarCustomization != null && !StripeTextUtils.isBlank(this.mToolbarCustomization.getButtonText())) {
            MenuItem closeMenuItem = menu2.findItem(R.id.action_close);
            closeMenuItem.setTitle((CharSequence)this.mToolbarCustomization.getButtonText());
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_close) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void customizeToolbar(@NonNull Toolbar toolbar) {
        if (this.mToolbarCustomization != null) {
            if (!StripeTextUtils.isBlank(this.mToolbarCustomization.getHeaderText())) {
                toolbar.setTitle((CharSequence)CustomizeUtils.buildStyledText((Context)this, (String)this.mToolbarCustomization.getHeaderText(), (Customization)this.mToolbarCustomization));
            }
            if (this.mToolbarCustomization.getBackgroundColor() != null) {
                int backgroundColor = Color.parseColor((String)this.mToolbarCustomization.getBackgroundColor());
                toolbar.setBackgroundColor(backgroundColor);
                CustomizeUtils.setStatusBarColor((AppCompatActivity)this, (int)backgroundColor);
            }
        }
    }
}

