/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ResultWrapper;
import com.stripe.android.exception.StripeException;
import org.json.JSONException;

abstract class ApiOperation<ResultType>
extends AsyncTask<Void, Void, ResultWrapper<ResultType>> {
    @NonNull
    private final ApiResultCallback<ResultType> mCallback;

    ApiOperation(@NonNull ApiResultCallback<ResultType> callback) {
        this.mCallback = callback;
    }

    protected final ResultWrapper<ResultType> doInBackground(Void ... voids) {
        try {
            return new ResultWrapper<ResultType>(this.getResult());
        }
        catch (StripeException | JSONException e) {
            return new ResultWrapper((Exception)e);
        }
    }

    protected final void onPostExecute(@NonNull ResultWrapper<ResultType> resultWrapper) {
        super.onPostExecute(resultWrapper);
        if (resultWrapper.result != null) {
            this.mCallback.onSuccess(resultWrapper.result);
        } else if (resultWrapper.error != null) {
            this.mCallback.onError(resultWrapper.error);
        } else {
            this.mCallback.onError(new RuntimeException("The API operation returned neither a result or exception"));
        }
    }

    @Nullable
    abstract ResultType getResult() throws StripeException, JSONException;
}

