/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.stripe3ds2.transaction.ErrorMessage;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AnalyticsDataFactory {
    static final String UNKNOWN = "unknown";
    static final String NO_CONTEXT = "no_context";
    static final String FIELD_PRODUCT_USAGE = "product_usage";
    static final String FIELD_ANALYTICS_UA = "analytics_ua";
    static final String FIELD_APP_NAME = "app_name";
    static final String FIELD_APP_VERSION = "app_version";
    static final String FIELD_BINDINGS_VERSION = "bindings_version";
    static final String FIELD_DEVICE_TYPE = "device_type";
    static final String FIELD_EVENT = "event";
    static final String FIELD_ERROR_DATA = "error";
    static final String FIELD_INTENT_ID = "intent_id";
    static final String FIELD_OS_NAME = "os_name";
    static final String FIELD_OS_RELEASE = "os_release";
    static final String FIELD_OS_VERSION = "os_version";
    static final String FIELD_PAYMENT_METHOD_ID = "payment_method_id";
    static final String FIELD_PAYMENT_METHOD_TYPE = "payment_method_type";
    static final String FIELD_PUBLISHABLE_KEY = "publishable_key";
    static final String FIELD_SOURCE_TYPE = "source_type";
    static final String FIELD_3DS2_UI_TYPE = "3ds2_ui_type";
    static final String FIELD_TOKEN_TYPE = "token_type";
    static final Set<String> VALID_PARAM_FIELDS = new HashSet<String>(Arrays.asList("analytics_ua", "app_name", "app_version", "bindings_version", "device_type", "event", "os_version", "os_name", "os_release", "product_usage", "publishable_key", "source_type", "token_type"));
    private static final String ANALYTICS_PREFIX = "analytics";
    private static final String ANALYTICS_NAME = "stripe_android";
    private static final String ANALYTICS_VERSION = "1.0";
    @Nullable
    private final PackageManager mPackageManager;
    @Nullable
    private final String mPackageName;

    AnalyticsDataFactory(@NonNull Context context) {
        this(context.getPackageManager(), context.getPackageName());
    }

    @VisibleForTesting
    AnalyticsDataFactory(@Nullable PackageManager packageManager, @Nullable String packageName) {
        this.mPackageManager = packageManager;
        this.mPackageName = packageName;
    }

    @NonNull
    Map<String, Object> createAuthParams(@NonNull String eventName, @NonNull String intentId, @NonNull String publishableKey) {
        Map<String, Object> params = this.getEventLoggingParams(publishableKey, eventName);
        params.put(FIELD_INTENT_ID, intentId);
        return params;
    }

    @NonNull
    Map<String, Object> create3ds2ChallengeParams(@NonNull String eventName, @NonNull String intentId, @NonNull String uiTypeCode, @NonNull String publishableKey) {
        Map<String, Object> params = this.getEventLoggingParams(publishableKey, eventName);
        params.put(FIELD_INTENT_ID, intentId);
        params.put(FIELD_3DS2_UI_TYPE, AnalyticsDataFactory.get3ds2UiType(uiTypeCode));
        return params;
    }

    @NonNull
    Map<String, Object> create3ds2ChallengeErrorParams(@NonNull String intentId, @NonNull RuntimeErrorEvent runtimeErrorEvent, @NonNull String publishableKey) {
        HashMap<String, String> errorData = new HashMap<String, String>();
        errorData.put("type", "runtime_error_event");
        errorData.put("error_code", runtimeErrorEvent.getErrorCode());
        errorData.put("error_message", runtimeErrorEvent.getErrorMessage());
        Map<String, Object> params = this.getEventLoggingParams(publishableKey, "3ds2_challenge_flow_errored");
        params.put(FIELD_INTENT_ID, intentId);
        params.put(FIELD_ERROR_DATA, errorData);
        return params;
    }

    @NonNull
    Map<String, Object> create3ds2ChallengeErrorParams(@NonNull String intentId, @NonNull ProtocolErrorEvent protocolErrorEvent, @NonNull String publishableKey) {
        HashMap<String, String> errorData = new HashMap<String, String>();
        ErrorMessage errorMessage = protocolErrorEvent.getErrorMessage();
        errorData.put("type", "protocol_error_event");
        errorData.put("sdk_trans_id", protocolErrorEvent.getSDKTransactionID());
        errorData.put("error_code", errorMessage.getErrorCode());
        errorData.put("error_description", errorMessage.getErrorDescription());
        errorData.put("error_details", errorMessage.getErrorDetails());
        errorData.put("trans_id", errorMessage.getTransactionID());
        Map<String, Object> params = this.getEventLoggingParams(publishableKey, "3ds2_challenge_flow_errored");
        params.put(FIELD_INTENT_ID, intentId);
        params.put(FIELD_ERROR_DATA, errorData);
        return params;
    }

    @NonNull
    Map<String, Object> getTokenCreationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @Nullable String tokenType) {
        return this.getEventLoggingParams(productUsageTokens, null, tokenType, publishableApiKey, "token_creation");
    }

    @NonNull
    Map<String, Object> createPaymentMethodCreationParams(@NonNull String publishableApiKey, @Nullable String paymentMethodId) {
        Map<String, Object> params = this.getEventLoggingParams(publishableApiKey, "payment_method_creation");
        if (paymentMethodId != null) {
            params.put(FIELD_PAYMENT_METHOD_ID, paymentMethodId);
        }
        return params;
    }

    @NonNull
    Map<String, Object> getSourceCreationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @NonNull String sourceType) {
        return this.getEventLoggingParams(productUsageTokens, sourceType, null, publishableApiKey, "source_creation");
    }

    @NonNull
    Map<String, Object> getAddSourceParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey, @NonNull String sourceType) {
        return this.getEventLoggingParams(productUsageTokens, sourceType, null, publishableKey, "add_source");
    }

    @NonNull
    Map<String, Object> getDeleteSourceParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey) {
        return this.getEventLoggingParams(productUsageTokens, publishableKey, "delete_source");
    }

    @NonNull
    Map<String, Object> getAttachPaymentMethodParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey) {
        return this.getEventLoggingParams(productUsageTokens, publishableKey, "attach_payment_method");
    }

    @NonNull
    Map<String, Object> getDetachPaymentMethodParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey) {
        return this.getEventLoggingParams(productUsageTokens, publishableKey, "detach_payment_method");
    }

    @NonNull
    Map<String, Object> getPaymentIntentConfirmationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @Nullable String sourceType) {
        return this.getEventLoggingParams(productUsageTokens, sourceType, null, publishableApiKey, "payment_intent_confirmation");
    }

    @NonNull
    Map<String, Object> getPaymentIntentRetrieveParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey) {
        return this.getEventLoggingParams(productUsageTokens, publishableApiKey, "payment_intent_retrieval");
    }

    @NonNull
    Map<String, Object> getSetupIntentConfirmationParams(@NonNull String publishableApiKey, @Nullable String paymentMethodType) {
        Map<String, Object> params = this.getEventLoggingParams(publishableApiKey, "setup_intent_confirmation");
        if (paymentMethodType != null) {
            params.put(FIELD_PAYMENT_METHOD_TYPE, paymentMethodType);
        }
        return params;
    }

    @NonNull
    Map<String, Object> getSetupIntentRetrieveParams(@NonNull String publishableApiKey) {
        return this.getEventLoggingParams(publishableApiKey, "setup_intent_retrieval");
    }

    @NonNull
    Map<String, Object> getEventLoggingParams(@NonNull String publishableApiKey, @NonNull String eventName) {
        return this.getEventLoggingParams(null, null, null, publishableApiKey, eventName);
    }

    @NonNull
    Map<String, Object> getEventLoggingParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @NonNull String eventName) {
        return this.getEventLoggingParams(productUsageTokens, null, null, publishableApiKey, eventName);
    }

    @NonNull
    Map<String, Object> getEventLoggingParams(@Nullable List<String> productUsageTokens, @Nullable String sourceType, @Nullable String tokenType, @NonNull String publishableApiKey, @NonNull String eventName) {
        HashMap<String, Object> paramsObject = new HashMap<String, Object>();
        paramsObject.put(FIELD_ANALYTICS_UA, AnalyticsDataFactory.getAnalyticsUa());
        paramsObject.put(FIELD_EVENT, AnalyticsDataFactory.getEventParamName(eventName));
        paramsObject.put(FIELD_PUBLISHABLE_KEY, publishableApiKey);
        paramsObject.put(FIELD_OS_NAME, Build.VERSION.CODENAME);
        paramsObject.put(FIELD_OS_RELEASE, Build.VERSION.RELEASE);
        paramsObject.put(FIELD_OS_VERSION, Build.VERSION.SDK_INT);
        paramsObject.put(FIELD_DEVICE_TYPE, AnalyticsDataFactory.getDeviceLoggingString());
        paramsObject.put(FIELD_BINDINGS_VERSION, "10.0.3");
        paramsObject.putAll(this.createNameAndVersionParams());
        if (productUsageTokens != null) {
            paramsObject.put(FIELD_PRODUCT_USAGE, productUsageTokens);
        }
        if (sourceType != null) {
            paramsObject.put(FIELD_SOURCE_TYPE, sourceType);
        }
        if (tokenType != null) {
            paramsObject.put(FIELD_TOKEN_TYPE, tokenType);
        } else if (sourceType == null) {
            paramsObject.put(FIELD_TOKEN_TYPE, UNKNOWN);
        }
        return paramsObject;
    }

    @NonNull
    Map<String, Object> createNameAndVersionParams() {
        HashMap<String, Object> paramsObject = new HashMap<String, Object>(2);
        if (this.mPackageManager != null) {
            try {
                String nameString;
                PackageInfo info = this.mPackageManager.getPackageInfo(this.mPackageName, 0);
                if (info.applicationInfo != null) {
                    CharSequence name = info.applicationInfo.loadLabel(this.mPackageManager);
                    nameString = name != null ? name.toString() : null;
                    paramsObject.put(FIELD_APP_NAME, nameString);
                } else {
                    nameString = null;
                }
                if (StripeTextUtils.isBlank(nameString)) {
                    paramsObject.put(FIELD_APP_NAME, info.packageName);
                }
                paramsObject.put(FIELD_APP_VERSION, info.versionCode);
            }
            catch (PackageManager.NameNotFoundException nameNotFound) {
                paramsObject.put(FIELD_APP_NAME, UNKNOWN);
                paramsObject.put(FIELD_APP_VERSION, UNKNOWN);
            }
        } else {
            paramsObject.put(FIELD_APP_NAME, NO_CONTEXT);
            paramsObject.put(FIELD_APP_VERSION, NO_CONTEXT);
        }
        return paramsObject;
    }

    @NonNull
    private static String getDeviceLoggingString() {
        return Build.MANUFACTURER + '_' + Build.BRAND + '_' + Build.MODEL;
    }

    @NonNull
    static String getAnalyticsUa() {
        return "analytics.stripe_android-1.0";
    }

    @NonNull
    static String getEventParamName(@NonNull String eventName) {
        return "stripe_android." + eventName;
    }

    private static String get3ds2UiType(@NonNull String uiTypeCode) {
        switch (uiTypeCode) {
            case "01": {
                return "text";
            }
            case "02": {
                return "single_select";
            }
            case "03": {
                return "multi_select";
            }
            case "04": {
                return "oob";
            }
            case "05": {
                return "html";
            }
        }
        return "none";
    }
}

