/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public final class Token
implements StripePaymentSource {
    private static final String FIELD_BANK_ACCOUNT = "bank_account";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_ID = "id";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USED = "used";
    @NonNull
    private final String mId;
    @NonNull
    private final String mType;
    @NonNull
    private final Date mCreated;
    private final boolean mLivemode;
    private final boolean mUsed;
    @Nullable
    private final BankAccount mBankAccount;
    @Nullable
    private final Card mCard;

    public Token(@NonNull String id, boolean livemode, @NonNull Date created, @Nullable Boolean used, @Nullable Card card) {
        this.mId = id;
        this.mType = FIELD_CARD;
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = card;
        this.mUsed = Boolean.TRUE.equals(used);
        this.mBankAccount = null;
    }

    public Token(@NonNull String id, boolean livemode, @NonNull Date created, @Nullable Boolean used, @NonNull BankAccount bankAccount) {
        this.mId = id;
        this.mType = FIELD_BANK_ACCOUNT;
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = null;
        this.mUsed = Boolean.TRUE.equals(used);
        this.mBankAccount = bankAccount;
    }

    public Token(@NonNull String id, @NonNull String type, boolean livemode, @NonNull Date created, @Nullable Boolean used) {
        this.mId = id;
        this.mType = type;
        this.mCreated = created;
        this.mCard = null;
        this.mBankAccount = null;
        this.mUsed = Boolean.TRUE.equals(used);
        this.mLivemode = livemode;
    }

    @NonNull
    public Date getCreated() {
        return this.mCreated;
    }

    @Override
    @NonNull
    public String getId() {
        return this.mId;
    }

    public boolean getLivemode() {
        return this.mLivemode;
    }

    public boolean getUsed() {
        return this.mUsed;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @Nullable
    public Card getCard() {
        return this.mCard;
    }

    @Nullable
    public BankAccount getBankAccount() {
        return this.mBankAccount;
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mId, this.mType, this.mCreated, this.mLivemode, this.mUsed, this.mBankAccount, this.mCard);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof Token && this.typedEquals((Token)obj);
    }

    private boolean typedEquals(@NonNull Token token) {
        return ObjectUtils.equals(this.mId, token.mId) && ObjectUtils.equals(this.mType, token.mType) && ObjectUtils.equals(this.mCreated, token.mCreated) && this.mLivemode == token.mLivemode && this.mUsed == token.mUsed && ObjectUtils.equals(this.mBankAccount, token.mBankAccount) && ObjectUtils.equals(this.mCard, token.mCard);
    }

    @Nullable
    public static Token fromString(@Nullable String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            JSONObject tokenObject = new JSONObject(jsonString);
            return Token.fromJson(tokenObject);
        }
        catch (JSONException exception) {
            return null;
        }
    }

    @Nullable
    public static Token fromJson(@Nullable JSONObject jsonObject) {
        Token token;
        if (jsonObject == null) {
            return null;
        }
        String tokenId = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        Long createdTimeStamp = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        Boolean liveModeOpt = StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE);
        String tokenType = Token.asTokenType(StripeJsonUtils.optString(jsonObject, FIELD_TYPE));
        Boolean usedOpt = StripeJsonUtils.optBoolean(jsonObject, FIELD_USED);
        if (tokenId == null || createdTimeStamp == null || liveModeOpt == null) {
            return null;
        }
        boolean used = Boolean.TRUE.equals(usedOpt);
        boolean liveMode = Boolean.TRUE.equals(liveModeOpt);
        Date date = new Date(createdTimeStamp * 1000L);
        if (FIELD_BANK_ACCOUNT.equals(tokenType)) {
            JSONObject bankAccountObject = jsonObject.optJSONObject(FIELD_BANK_ACCOUNT);
            if (bankAccountObject == null) {
                return null;
            }
            token = new Token(tokenId, liveMode, date, (Boolean)used, BankAccount.fromJson(bankAccountObject));
        } else if (FIELD_CARD.equals(tokenType)) {
            JSONObject cardObject = jsonObject.optJSONObject(FIELD_CARD);
            if (cardObject == null) {
                return null;
            }
            token = new Token(tokenId, liveMode, date, (Boolean)used, Card.fromJson(cardObject));
        } else {
            token = "pii".equals(tokenType) || "account".equals(tokenType) || "cvc_update".equals(tokenType) ? new Token(tokenId, tokenType, liveMode, date, used) : null;
        }
        return token;
    }

    @Nullable
    private static String asTokenType(@Nullable String possibleTokenType) {
        if (possibleTokenType == null || StripeTextUtils.isEmpty(possibleTokenType.trim())) {
            return null;
        }
        if (FIELD_CARD.equals(possibleTokenType)) {
            return FIELD_CARD;
        }
        if (FIELD_BANK_ACCOUNT.equals(possibleTokenType)) {
            return FIELD_BANK_ACCOUNT;
        }
        if ("pii".equals(possibleTokenType)) {
            return "pii";
        }
        if ("account".equals(possibleTokenType)) {
            return "account";
        }
        if ("cvc_update".equals(possibleTokenType)) {
            return "cvc_update";
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TokenType {
        public static final String CARD = "card";
        public static final String BANK_ACCOUNT = "bank_account";
        public static final String PII = "pii";
        public static final String ACCOUNT = "account";
        public static final String CVC_UPDATE = "cvc_update";
    }
}

