/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

public class TextUtils {
    public static boolean hasAnyPrefix(String number, String ... prefixes) {
        if (number == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWholePositiveNumber(String value) {
        if (value == null) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String nullIfBlank(String value) {
        if (TextUtils.isBlank(value)) {
            return null;
        }
        return value;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

