/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.databinding.StripeChallengeZoneWebViewBinding;
import com.stripe.android.stripe3ds2.views.FormField;
import com.stripe.android.stripe3ds2.views.ThreeDS2WebView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010J\u0012\u0010!\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeZoneWebView;", "Landroid/widget/FrameLayout;", "Lcom/stripe/android/stripe3ds2/views/FormField;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "webView", "Lcom/stripe/android/stripe3ds2/views/ThreeDS2WebView;", "getWebView", "()Lcom/stripe/android/stripe3ds2/views/ThreeDS2WebView;", "value", "", "userEntry", "getUserEntry", "()Ljava/lang/String;", "onClickListener", "Landroid/view/View$OnClickListener;", "getOnClickListener$3ds2sdk_release", "()Landroid/view/View$OnClickListener;", "setOnClickListener$3ds2sdk_release", "(Landroid/view/View$OnClickListener;)V", "transformHtml", "html", "transformHtml$3ds2sdk_release", "transformFormMethod", "transformFormActionUrl", "loadHtml", "", "setOnClickListener", "Companion", "3ds2sdk_release"})
public final class ChallengeZoneWebView
extends FrameLayout
implements FormField {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreeDS2WebView webView;
    @NotNull
    private String userEntry;
    @Nullable
    private View.OnClickListener onClickListener;
    private static final Pattern PATTERN_METHOD_POST = Pattern.compile("method=\"post\"", 10);
    private static final Pattern PATTERN_FORM_ACTION = Pattern.compile("action=\"(.+?)\"", 10);
    @NotNull
    private static final String HTML_MIME_TYPE = "text/html";
    @NotNull
    private static final String ENCODING = "UTF-8";
    @NotNull
    private static final String METHOD_GET = "method=\"get\"";

    @JvmOverloads
    public ChallengeZoneWebView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.userEntry = "";
        StripeChallengeZoneWebViewBinding stripeChallengeZoneWebViewBinding = StripeChallengeZoneWebViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeChallengeZoneWebViewBinding, (String)"inflate(...)");
        StripeChallengeZoneWebViewBinding viewBinding = stripeChallengeZoneWebViewBinding;
        this.webView = viewBinding.webView;
        this.webView.setOnHtmlSubmitListener$3ds2sdk_release(arg_0 -> ChallengeZoneWebView._init_$lambda$0(this, arg_0));
    }

    public /* synthetic */ ChallengeZoneWebView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final ThreeDS2WebView getWebView() {
        return this.webView;
    }

    @Override
    @NotNull
    public String getUserEntry() {
        return this.userEntry;
    }

    @Nullable
    public final View.OnClickListener getOnClickListener$3ds2sdk_release() {
        return this.onClickListener;
    }

    public final void setOnClickListener$3ds2sdk_release(@Nullable View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    @VisibleForTesting
    @NotNull
    public final String transformHtml$3ds2sdk_release(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        return this.transformFormActionUrl(this.transformFormMethod(html));
    }

    private final String transformFormMethod(String html) {
        Matcher methodMatcher = PATTERN_METHOD_POST.matcher(html);
        String string2 = methodMatcher.replaceAll(METHOD_GET);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceAll(...)");
        return string2;
    }

    private final String transformFormActionUrl(String html) {
        Matcher actionMatcher = PATTERN_FORM_ACTION.matcher(html);
        if (actionMatcher.find()) {
            String string2 = actionMatcher.group(1);
            if (string2 != null) {
                String actionUrl = string2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)"https://emv3ds/challenge", (Object)actionUrl)) {
                    CharSequence charSequence = html;
                    Regex regex = new Regex(actionUrl);
                    String string3 = "https://emv3ds/challenge";
                    return regex.replace(charSequence, string3);
                }
            }
        }
        return html;
    }

    public final void loadHtml(@Nullable String html) {
        if (html == null) {
            return;
        }
        this.webView.loadDataWithBaseURL(null, this.transformHtml$3ds2sdk_release(html), HTML_MIME_TYPE, ENCODING, null);
    }

    public void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    @JvmOverloads
    public ChallengeZoneWebView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ChallengeZoneWebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _init_$lambda$0(ChallengeZoneWebView this$0, String data) {
        block1: {
            String string2 = data;
            if (string2 == null) {
                string2 = "";
            }
            this$0.userEntry = string2;
            View.OnClickListener onClickListener = this$0.onClickListener;
            if (onClickListener == null) break block1;
            onClickListener.onClick((View)this$0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeZoneWebView$Companion;", "", "<init>", "()V", "PATTERN_METHOD_POST", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "PATTERN_FORM_ACTION", "HTML_MIME_TYPE", "", "ENCODING", "METHOD_GET", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

