/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.BundleCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.stripe3ds2.R;
import com.stripe.android.stripe3ds2.databinding.StripeChallengeFragmentBinding;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.transaction.ChallengeAction;
import com.stripe.android.stripe3ds2.transaction.ChallengeActionHandler;
import com.stripe.android.stripe3ds2.transaction.ChallengeRequestResult;
import com.stripe.android.stripe3ds2.transaction.ChallengeResult;
import com.stripe.android.stripe3ds2.transaction.ErrorRequestExecutor;
import com.stripe.android.stripe3ds2.transaction.IntentData;
import com.stripe.android.stripe3ds2.transaction.TransactionTimer;
import com.stripe.android.stripe3ds2.transactions.ChallengeRequestData;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData;
import com.stripe.android.stripe3ds2.transactions.ErrorData;
import com.stripe.android.stripe3ds2.transactions.UiType;
import com.stripe.android.stripe3ds2.utils.AnalyticsDelegate;
import com.stripe.android.stripe3ds2.views.BrandZoneView;
import com.stripe.android.stripe3ds2.views.ChallengeActivityViewModel;
import com.stripe.android.stripe3ds2.views.ChallengeEntryViewFactory;
import com.stripe.android.stripe3ds2.views.ChallengeZoneSelectView;
import com.stripe.android.stripe3ds2.views.ChallengeZoneTextView;
import com.stripe.android.stripe3ds2.views.ChallengeZoneView;
import com.stripe.android.stripe3ds2.views.ChallengeZoneWebView;
import com.stripe.android.stripe3ds2.views.InformationZoneView;
import java.util.Iterator;
import java.util.Map;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u0000 l2\u00020\u0001:\u0001lBS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020T2\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\b\u0010W\u001a\u00020RH\u0016J\b\u0010X\u001a\u00020RH\u0016J\b\u0010Y\u001a\u00020RH\u0016J \u0010Z\u001a\u00020R2\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u00020=2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010[\u001a\u00020RH\u0002J\b\u0010\\\u001a\u00020RH\u0002J\b\u0010]\u001a\u00020RH\u0002J\u0006\u0010^\u001a\u00020RJ\u0010\u0010_\u001a\u00020R2\u0006\u0010`\u001a\u00020aH\u0002J\u0018\u0010b\u001a\u00020R2\u0006\u0010c\u001a\u00020d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010e\u001a\u00020R2\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020R2\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010e\u001a\u00020R2\u0006\u0010i\u001a\u00020jH\u0002J\u0006\u0010k\u001a\u00020RR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001e\u001a\u00020\u001f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001d\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001d\u001a\u0004\b%\u0010&R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020)8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001b\u0010-\u001a\u00020.8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001d\u001a\u0004\b/\u00100R\u001b\u00102\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u001d\u001a\u0004\b4\u00105R\u001b\u00107\u001a\u0002088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u001d\u001a\u0004\b9\u0010:R\u001b\u0010<\u001a\u00020=8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u001d\u001a\u0004\b>\u0010?R\u001b\u0010A\u001a\u00020B8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010\u001d\u001a\u0004\bC\u0010DR\u001b\u0010F\u001a\u00020G8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u001d\u001a\u0004\bH\u0010IR\u0014\u0010K\u001a\u00020\u00198AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001bR\u0014\u0010M\u001a\u00020N8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006m"}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeFragment;", "Landroidx/fragment/app/Fragment;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "analyticsDelegate", "Lcom/stripe/android/stripe3ds2/utils/AnalyticsDelegate;", "transactionTimer", "Lcom/stripe/android/stripe3ds2/transaction/TransactionTimer;", "errorRequestExecutor", "Lcom/stripe/android/stripe3ds2/transaction/ErrorRequestExecutor;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "challengeActionHandler", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeActionHandler;", "initialUiType", "Lcom/stripe/android/stripe3ds2/transactions/UiType;", "intentData", "Lcom/stripe/android/stripe3ds2/transaction/IntentData;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;Lcom/stripe/android/stripe3ds2/utils/AnalyticsDelegate;Lcom/stripe/android/stripe3ds2/transaction/TransactionTimer;Lcom/stripe/android/stripe3ds2/transaction/ErrorRequestExecutor;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/transaction/ChallengeActionHandler;Lcom/stripe/android/stripe3ds2/transactions/UiType;Lcom/stripe/android/stripe3ds2/transaction/IntentData;Lkotlin/coroutines/CoroutineContext;)V", "cresData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeResponseData;", "uiTypeCode", "", "getUiTypeCode", "()Ljava/lang/String;", "uiTypeCode$delegate", "Lkotlin/Lazy;", "viewModel", "Lcom/stripe/android/stripe3ds2/views/ChallengeActivityViewModel;", "getViewModel$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/views/ChallengeActivityViewModel;", "viewModel$delegate", "challengeEntryViewFactory", "Lcom/stripe/android/stripe3ds2/views/ChallengeEntryViewFactory;", "getChallengeEntryViewFactory", "()Lcom/stripe/android/stripe3ds2/views/ChallengeEntryViewFactory;", "challengeEntryViewFactory$delegate", "_viewBinding", "Lcom/stripe/android/stripe3ds2/databinding/StripeChallengeFragmentBinding;", "viewBinding", "getViewBinding$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/databinding/StripeChallengeFragmentBinding;", "challengeZoneView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneView;", "getChallengeZoneView", "()Lcom/stripe/android/stripe3ds2/views/ChallengeZoneView;", "challengeZoneView$delegate", "brandZoneView", "Lcom/stripe/android/stripe3ds2/views/BrandZoneView;", "getBrandZoneView", "()Lcom/stripe/android/stripe3ds2/views/BrandZoneView;", "brandZoneView$delegate", "challengeZoneTextView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneTextView;", "getChallengeZoneTextView", "()Lcom/stripe/android/stripe3ds2/views/ChallengeZoneTextView;", "challengeZoneTextView$delegate", "challengeZoneSelectView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView;", "getChallengeZoneSelectView", "()Lcom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView;", "challengeZoneSelectView$delegate", "challengeZoneWebView", "Lcom/stripe/android/stripe3ds2/views/ChallengeZoneWebView;", "getChallengeZoneWebView", "()Lcom/stripe/android/stripe3ds2/views/ChallengeZoneWebView;", "challengeZoneWebView$delegate", "informationZoneView", "Lcom/stripe/android/stripe3ds2/views/InformationZoneView;", "getInformationZoneView", "()Lcom/stripe/android/stripe3ds2/views/InformationZoneView;", "informationZoneView$delegate", "userEntry", "getUserEntry$3ds2sdk_release", "challengeAction", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeAction;", "getChallengeAction", "()Lcom/stripe/android/stripe3ds2/transaction/ChallengeAction;", "onViewCreated", "", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "onResume", "onPause", "onDestroyView", "configure", "updateBrandZoneImages", "configureInformationZoneView", "configureChallengeZoneView", "refreshUi", "onChallengeRequestResult", "result", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestResult;", "onSuccess", "creqData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;", "onError", "data", "Lcom/stripe/android/stripe3ds2/transactions/ErrorData;", "onTimeout", "throwable", "", "clickSubmitButton", "Companion", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nChallengeFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChallengeFragment.kt\ncom/stripe/android/stripe3ds2/views/ChallengeFragment\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,419:1\n172#2,9:420\n298#3,2:429\n256#3,2:433\n298#3,2:435\n216#4,2:431\n*S KotlinDebug\n*F\n+ 1 ChallengeFragment.kt\ncom/stripe/android/stripe3ds2/views/ChallengeFragment\n*L\n47#1:420,9\n207#1:429,2\n233#1:433,2\n236#1:435,2\n226#1:431,2\n*E\n"})
public final class ChallengeFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeUiCustomization uiCustomization;
    @Nullable
    private final AnalyticsDelegate analyticsDelegate;
    @NotNull
    private final TransactionTimer transactionTimer;
    @NotNull
    private final ErrorRequestExecutor errorRequestExecutor;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final ChallengeActionHandler challengeActionHandler;
    @Nullable
    private final UiType initialUiType;
    @NotNull
    private final IntentData intentData;
    @NotNull
    private final CoroutineContext workContext;
    private ChallengeResponseData cresData;
    @NotNull
    private final Lazy uiTypeCode$delegate;
    @NotNull
    private final Lazy viewModel$delegate;
    @NotNull
    private final Lazy challengeEntryViewFactory$delegate;
    @Nullable
    private StripeChallengeFragmentBinding _viewBinding;
    @NotNull
    private final Lazy challengeZoneView$delegate;
    @NotNull
    private final Lazy brandZoneView$delegate;
    @NotNull
    private final Lazy challengeZoneTextView$delegate;
    @NotNull
    private final Lazy challengeZoneSelectView$delegate;
    @NotNull
    private final Lazy challengeZoneWebView$delegate;
    @NotNull
    private final Lazy informationZoneView$delegate;
    @NotNull
    public static final String ARG_CRES = "arg_cres";

    /*
     * WARNING - void declaration
     */
    public ChallengeFragment(@NotNull StripeUiCustomization uiCustomization, @Nullable AnalyticsDelegate analyticsDelegate, @NotNull TransactionTimer transactionTimer, @NotNull ErrorRequestExecutor errorRequestExecutor, @NotNull ErrorReporter errorReporter, @NotNull ChallengeActionHandler challengeActionHandler, @Nullable UiType initialUiType, @NotNull IntentData intentData, @NotNull CoroutineContext workContext) {
        void $this$activityViewModels_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        Intrinsics.checkNotNullParameter((Object)transactionTimer, (String)"transactionTimer");
        Intrinsics.checkNotNullParameter((Object)errorRequestExecutor, (String)"errorRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)challengeActionHandler, (String)"challengeActionHandler");
        Intrinsics.checkNotNullParameter((Object)intentData, (String)"intentData");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        super(R.layout.stripe_challenge_fragment);
        this.uiCustomization = uiCustomization;
        this.analyticsDelegate = analyticsDelegate;
        this.transactionTimer = transactionTimer;
        this.errorRequestExecutor = errorRequestExecutor;
        this.errorReporter = errorReporter;
        this.challengeActionHandler = challengeActionHandler;
        this.initialUiType = initialUiType;
        this.intentData = intentData;
        this.workContext = workContext;
        this.uiTypeCode$delegate = LazyKt.lazy(() -> ChallengeFragment.uiTypeCode_delegate$lambda$0(this));
        Fragment fragment = this;
        Function0 factoryProducer$iv = () -> ChallengeFragment.viewModel_delegate$lambda$1(this);
        Function0 extrasProducer$iv = null;
        boolean $i$f$activityViewModels = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(ChallengeActivityViewModel.class);
        Function0 function0 = (Function0)new Function0<ViewModelStore>((Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_activityViewModels.requireActivity().getViewModelStore();
            }
        };
        Function0 function02 = (Function0)new Function0<CreationExtras>(extrasProducer$iv, (Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_activityViewModels.requireActivity().getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        };
        Function0 function03 = factoryProducer$iv;
        if (function03 == null) {
            function03 = (Function0)new Function0<ViewModelProvider.Factory>((Fragment)$this$activityViewModels_u24default$iv){
                final /* synthetic */ Fragment $this_activityViewModels;
                {
                    this.$this_activityViewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    return this.$this_activityViewModels.requireActivity().getDefaultViewModelProviderFactory();
                }
            };
        }
        this.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$activityViewModels_u24default$iv, (KClass)kClass, (Function0)function0, (Function0)function02, (Function0)function03);
        this.challengeEntryViewFactory$delegate = LazyKt.lazy(() -> ChallengeFragment.challengeEntryViewFactory_delegate$lambda$2(this));
        this.challengeZoneView$delegate = LazyKt.lazy(() -> ChallengeFragment.challengeZoneView_delegate$lambda$3(this));
        this.brandZoneView$delegate = LazyKt.lazy(() -> ChallengeFragment.brandZoneView_delegate$lambda$4(this));
        this.challengeZoneTextView$delegate = LazyKt.lazy(() -> ChallengeFragment.challengeZoneTextView_delegate$lambda$5(this));
        this.challengeZoneSelectView$delegate = LazyKt.lazy(() -> ChallengeFragment.challengeZoneSelectView_delegate$lambda$6(this));
        this.challengeZoneWebView$delegate = LazyKt.lazy(() -> ChallengeFragment.challengeZoneWebView_delegate$lambda$7(this));
        this.informationZoneView$delegate = LazyKt.lazy(() -> ChallengeFragment.informationZoneView_delegate$lambda$8(this));
    }

    @NotNull
    public final String getUiTypeCode() {
        Lazy lazy = this.uiTypeCode$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final ChallengeActivityViewModel getViewModel$3ds2sdk_release() {
        Lazy lazy = this.viewModel$delegate;
        return (ChallengeActivityViewModel)((Object)lazy.getValue());
    }

    private final ChallengeEntryViewFactory getChallengeEntryViewFactory() {
        Lazy lazy = this.challengeEntryViewFactory$delegate;
        return (ChallengeEntryViewFactory)lazy.getValue();
    }

    @NotNull
    public final StripeChallengeFragmentBinding getViewBinding$3ds2sdk_release() {
        StripeChallengeFragmentBinding stripeChallengeFragmentBinding = this._viewBinding;
        if (stripeChallengeFragmentBinding == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return stripeChallengeFragmentBinding;
    }

    @NotNull
    public final ChallengeZoneView getChallengeZoneView() {
        Lazy lazy = this.challengeZoneView$delegate;
        return (ChallengeZoneView)((Object)lazy.getValue());
    }

    private final BrandZoneView getBrandZoneView() {
        Lazy lazy = this.brandZoneView$delegate;
        return (BrandZoneView)((Object)lazy.getValue());
    }

    @NotNull
    public final ChallengeZoneTextView getChallengeZoneTextView() {
        Lazy lazy = this.challengeZoneTextView$delegate;
        return (ChallengeZoneTextView)lazy.getValue();
    }

    @NotNull
    public final ChallengeZoneSelectView getChallengeZoneSelectView() {
        Lazy lazy = this.challengeZoneSelectView$delegate;
        return (ChallengeZoneSelectView)lazy.getValue();
    }

    @NotNull
    public final ChallengeZoneWebView getChallengeZoneWebView() {
        Lazy lazy = this.challengeZoneWebView$delegate;
        return (ChallengeZoneWebView)lazy.getValue();
    }

    @NotNull
    public final InformationZoneView getInformationZoneView() {
        Lazy lazy = this.informationZoneView$delegate;
        return (InformationZoneView)((Object)lazy.getValue());
    }

    @VisibleForTesting
    @NotNull
    public final String getUserEntry$3ds2sdk_release() {
        String string2;
        ChallengeResponseData challengeResponseData = this.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        UiType uiType = challengeResponseData.getUiType();
        switch (uiType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uiType.ordinal()]) {
            case 1: {
                string2 = this.getChallengeZoneTextView().getUserEntry();
                break;
            }
            case 2: 
            case 3: {
                string2 = this.getChallengeZoneSelectView().getUserEntry();
                break;
            }
            case 4: {
                string2 = this.getChallengeZoneWebView().getUserEntry();
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    private final ChallengeAction getChallengeAction() {
        ChallengeAction challengeAction;
        ChallengeResponseData challengeResponseData = this.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        UiType uiType = challengeResponseData.getUiType();
        switch (uiType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uiType.ordinal()]) {
            case 5: {
                challengeAction = new ChallengeAction.Oob(this.getChallengeZoneView().getWhitelistingSelection$3ds2sdk_release());
                break;
            }
            case 4: {
                challengeAction = new ChallengeAction.HtmlForm(this.getUserEntry$3ds2sdk_release());
                break;
            }
            default: {
                challengeAction = new ChallengeAction.NativeForm(this.getUserEntry$3ds2sdk_release(), this.getChallengeZoneView().getWhitelistingSelection$3ds2sdk_release());
            }
        }
        return challengeAction;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        ChallengeResponseData nullableCres;
        ChallengeResponseData challengeResponseData;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            Bundle it = bundle;
            boolean bl = false;
            challengeResponseData = (ChallengeResponseData)BundleCompat.getParcelable((Bundle)it, (String)ARG_CRES, ChallengeResponseData.class);
        } else {
            challengeResponseData = nullableCres = null;
        }
        if (nullableCres == null) {
            this.onError(new IllegalArgumentException("Could not start challenge screen. Challenge response data was null."));
            return;
        }
        this.cresData = nullableCres;
        AnalyticsDelegate analyticsDelegate = this.analyticsDelegate;
        if (analyticsDelegate != null) {
            ChallengeResponseData challengeResponseData2 = this.cresData;
            if (challengeResponseData2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData2 = null;
            }
            analyticsDelegate.didReceiveChallengeResponseWithTransactionId(challengeResponseData2.getServerTransId(), this.getUiTypeCode());
        }
        this._viewBinding = StripeChallengeFragmentBinding.bind(view);
        Function1 function1 = arg_0 -> ChallengeFragment.onViewCreated$lambda$10(this, arg_0);
        this.getViewModel$3ds2sdk_release().getChallengeText().observe(this.getViewLifecycleOwner(), new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        function1 = arg_0 -> ChallengeFragment.onViewCreated$lambda$11(this, arg_0);
        this.getViewModel$3ds2sdk_release().getRefreshUi().observe(this.getViewLifecycleOwner(), new /* invalid duplicate definition of identical inner class */);
        function1 = arg_0 -> ChallengeFragment.onViewCreated$lambda$12(this, arg_0);
        this.getViewModel$3ds2sdk_release().getChallengeRequestResult().observe(this.getViewLifecycleOwner(), new /* invalid duplicate definition of identical inner class */);
        this.updateBrandZoneImages();
        this.configure(this.getChallengeZoneTextView(), this.getChallengeZoneSelectView(), this.getChallengeZoneWebView());
        this.configureInformationZoneView();
    }

    public void onResume() {
        block4: {
            super.onResume();
            if (this.cresData == null) break block4;
            ChallengeResponseData challengeResponseData = this.cresData;
            if (challengeResponseData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData = null;
            }
            if (challengeResponseData.getUiType() == UiType.OutOfBand) {
                AnalyticsDelegate analyticsDelegate = this.analyticsDelegate;
                if (analyticsDelegate != null) {
                    ChallengeResponseData challengeResponseData2 = this.cresData;
                    if (challengeResponseData2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                        challengeResponseData2 = null;
                    }
                    analyticsDelegate.oobFlowDidResume(challengeResponseData2.getServerTransId());
                }
            }
        }
    }

    public void onPause() {
        block4: {
            super.onPause();
            if (this.cresData == null) break block4;
            ChallengeResponseData challengeResponseData = this.cresData;
            if (challengeResponseData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData = null;
            }
            if (challengeResponseData.getUiType() == UiType.OutOfBand) {
                AnalyticsDelegate analyticsDelegate = this.analyticsDelegate;
                if (analyticsDelegate != null) {
                    ChallengeResponseData challengeResponseData2 = this.cresData;
                    if (challengeResponseData2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                        challengeResponseData2 = null;
                    }
                    analyticsDelegate.oobFlowDidPause(challengeResponseData2.getServerTransId());
                }
            }
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this._viewBinding = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void configure(ChallengeZoneTextView challengeZoneTextView, ChallengeZoneSelectView challengeZoneSelectView, ChallengeZoneWebView challengeZoneWebView) {
        ChallengeResponseData challengeResponseData = this.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        UiType uiType = challengeResponseData.getUiType();
        switch (uiType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uiType.ordinal()]) {
            case 1: {
                this.getChallengeZoneView().setChallengeEntryView((View)challengeZoneTextView);
                ChallengeZoneView challengeZoneView = this.getChallengeZoneView();
                ChallengeResponseData challengeResponseData2 = this.cresData;
                if (challengeResponseData2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                    challengeResponseData2 = null;
                }
                challengeZoneView.setSubmitButton(challengeResponseData2.getSubmitAuthenticationLabel(), this.uiCustomization.getButtonCustomization(UiCustomization.ButtonType.SUBMIT));
                ChallengeZoneView challengeZoneView2 = this.getChallengeZoneView();
                ChallengeResponseData challengeResponseData3 = this.cresData;
                if (challengeResponseData3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                    challengeResponseData3 = null;
                }
                challengeZoneView2.setResendButtonLabel(challengeResponseData3.getResendInformationLabel(), this.uiCustomization.getButtonCustomization(UiCustomization.ButtonType.RESEND));
                break;
            }
            case 2: 
            case 3: {
                this.getChallengeZoneView().setChallengeEntryView((View)challengeZoneSelectView);
                ChallengeZoneView challengeZoneView = this.getChallengeZoneView();
                ChallengeResponseData challengeResponseData4 = this.cresData;
                if (challengeResponseData4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                    challengeResponseData4 = null;
                }
                challengeZoneView.setSubmitButton(challengeResponseData4.getSubmitAuthenticationLabel(), this.uiCustomization.getButtonCustomization(UiCustomization.ButtonType.NEXT));
                break;
            }
            case 4: {
                void $this$isGone$iv;
                this.getChallengeZoneView().setChallengeEntryView((View)challengeZoneWebView);
                this.getChallengeZoneView().setInfoHeaderText(null, null);
                this.getChallengeZoneView().setInfoText(null, null);
                this.getChallengeZoneView().setSubmitButton(null, null);
                challengeZoneWebView.setOnClickListener(arg_0 -> ChallengeFragment.configure$lambda$13(this, arg_0));
                View view = (View)this.getBrandZoneView();
                boolean value$iv = true;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(8);
                break;
            }
            case 5: {
                ChallengeZoneView challengeZoneView = this.getChallengeZoneView();
                ChallengeResponseData challengeResponseData5 = this.cresData;
                if (challengeResponseData5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                    challengeResponseData5 = null;
                }
                challengeZoneView.setSubmitButton(challengeResponseData5.getOobContinueLabel(), this.uiCustomization.getButtonCustomization(UiCustomization.ButtonType.CONTINUE));
            }
        }
        this.configureChallengeZoneView();
    }

    private final void updateBrandZoneImages() {
        BrandZoneView brandZoneView = this.getViewBinding$3ds2sdk_release().caBrandZone;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)brandZoneView), (String)"caBrandZone");
        BrandZoneView brandZoneView2 = brandZoneView;
        Pair[] pairArray = new Pair[2];
        ImageView imageView = brandZoneView2.getIssuerImageView$3ds2sdk_release();
        ChallengeResponseData challengeResponseData = this.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        pairArray[0] = TuplesKt.to((Object)imageView, (Object)challengeResponseData.getIssuerImage());
        ImageView imageView2 = brandZoneView2.getPaymentSystemImageView$3ds2sdk_release();
        ChallengeResponseData challengeResponseData2 = this.cresData;
        if (challengeResponseData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData2 = null;
        }
        pairArray[1] = TuplesKt.to((Object)imageView2, (Object)challengeResponseData2.getPaymentSystemImage());
        Map $this$forEach$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ImageView imageView3 = (ImageView)entry.getKey();
            ChallengeResponseData.Image imageData = (ChallengeResponseData.Image)entry.getValue();
            Function1 function1 = arg_0 -> ChallengeFragment.updateBrandZoneImages$lambda$15$lambda$14(imageView3, arg_0);
            this.getViewModel$3ds2sdk_release().getImage(imageData, this.getResources().getDisplayMetrics().densityDpi).observe(this.getViewLifecycleOwner(), new /* invalid duplicate definition of identical inner class */);
        }
    }

    private final void configureInformationZoneView() {
        block4: {
            InformationZoneView informationZoneView = this.getViewBinding$3ds2sdk_release().caInformationZone;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)informationZoneView), (String)"caInformationZone");
            InformationZoneView informationZoneView2 = informationZoneView;
            ChallengeResponseData challengeResponseData = this.cresData;
            if (challengeResponseData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData = null;
            }
            String string2 = challengeResponseData.getWhyInfoLabel();
            ChallengeResponseData challengeResponseData2 = this.cresData;
            if (challengeResponseData2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData2 = null;
            }
            informationZoneView2.setWhyInfo(string2, challengeResponseData2.getWhyInfoText(), this.uiCustomization.getLabelCustomization());
            ChallengeResponseData challengeResponseData3 = this.cresData;
            if (challengeResponseData3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData3 = null;
            }
            String string3 = challengeResponseData3.getExpandInfoLabel();
            ChallengeResponseData challengeResponseData4 = this.cresData;
            if (challengeResponseData4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData4 = null;
            }
            informationZoneView2.setExpandInfo(string3, challengeResponseData4.getExpandInfoText(), this.uiCustomization.getLabelCustomization());
            String string4 = this.uiCustomization.getAccentColor();
            if (string4 == null) break block4;
            String accentColor = string4;
            boolean bl = false;
            informationZoneView2.setToggleColor$3ds2sdk_release(Color.parseColor((String)accentColor));
        }
    }

    private final void configureChallengeZoneView() {
        ChallengeZoneView challengeZoneView = this.getChallengeZoneView();
        ChallengeResponseData challengeResponseData = this.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        challengeZoneView.setInfoHeaderText(challengeResponseData.getChallengeInfoHeader(), this.uiCustomization.getLabelCustomization());
        ChallengeZoneView challengeZoneView2 = this.getChallengeZoneView();
        ChallengeResponseData challengeResponseData2 = this.cresData;
        if (challengeResponseData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData2 = null;
        }
        challengeZoneView2.setInfoText(challengeResponseData2.getChallengeInfoText(), this.uiCustomization.getLabelCustomization());
        ChallengeResponseData challengeResponseData3 = this.cresData;
        if (challengeResponseData3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData3 = null;
        }
        if (challengeResponseData3.getUiType() == UiType.OutOfBand) {
            ChallengeZoneView challengeZoneView3 = this.getChallengeZoneView();
            ChallengeResponseData challengeResponseData4 = this.cresData;
            if (challengeResponseData4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData4 = null;
            }
            challengeZoneView3.setInfoLabel(challengeResponseData4.getChallengeInfoLabel(), this.uiCustomization.getLabelCustomization());
        }
        ChallengeZoneView challengeZoneView4 = this.getChallengeZoneView();
        ChallengeResponseData challengeResponseData5 = this.cresData;
        if (challengeResponseData5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData5 = null;
        }
        challengeZoneView4.setInfoTextIndicator(challengeResponseData5.getShouldShowChallengeInfoTextIndicator() ? R.drawable.stripe_3ds2_ic_indicator : 0);
        ChallengeZoneView challengeZoneView5 = this.getChallengeZoneView();
        ChallengeResponseData challengeResponseData6 = this.cresData;
        if (challengeResponseData6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData6 = null;
        }
        challengeZoneView5.setWhitelistingLabel(challengeResponseData6.getWhitelistingInfoText(), this.uiCustomization.getLabelCustomization(), this.uiCustomization.getButtonCustomization(UiCustomization.ButtonType.SELECT));
        this.getChallengeZoneView().setSubmitButtonClickListener(arg_0 -> ChallengeFragment.configureChallengeZoneView$lambda$17(this, arg_0));
        this.getChallengeZoneView().setResendButtonClickListener(arg_0 -> ChallengeFragment.configureChallengeZoneView$lambda$18(this, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void refreshUi() {
        ChallengeResponseData challengeResponseData;
        CharSequence charSequence;
        ChallengeResponseData challengeResponseData2 = this.cresData;
        if (challengeResponseData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData2 = null;
        }
        if (challengeResponseData2.getUiType() == UiType.Html) {
            ChallengeResponseData challengeResponseData3 = this.cresData;
            if (challengeResponseData3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                challengeResponseData3 = null;
            }
            if (!((charSequence = (CharSequence)challengeResponseData3.getAcsHtmlRefresh()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                ChallengeZoneWebView challengeZoneWebView = this.getChallengeZoneWebView();
                ChallengeResponseData challengeResponseData4 = this.cresData;
                if (challengeResponseData4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                    challengeResponseData4 = null;
                }
                challengeZoneWebView.loadHtml(challengeResponseData4.getAcsHtmlRefresh());
                return;
            }
        }
        if ((challengeResponseData = this.cresData) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        if (challengeResponseData.getUiType() != UiType.OutOfBand) return;
        ChallengeResponseData challengeResponseData5 = this.cresData;
        if (challengeResponseData5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData5 = null;
        }
        if ((charSequence = (CharSequence)challengeResponseData5.getChallengeAdditionalInfoText()) == null || StringsKt.isBlank((CharSequence)charSequence)) return;
        ChallengeZoneView challengeZoneView = this.getChallengeZoneView();
        ChallengeResponseData challengeResponseData6 = this.cresData;
        if (challengeResponseData6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData6 = null;
        }
        challengeZoneView.setInfoText(challengeResponseData6.getChallengeAdditionalInfoText(), this.uiCustomization.getLabelCustomization());
        this.getChallengeZoneView().setInfoTextIndicator(0);
    }

    private final void onChallengeRequestResult(ChallengeRequestResult result) {
        ChallengeRequestResult challengeRequestResult = result;
        if (challengeRequestResult instanceof ChallengeRequestResult.Success) {
            this.onSuccess(((ChallengeRequestResult.Success)result).getCreqData(), ((ChallengeRequestResult.Success)result).getCresData());
        } else if (challengeRequestResult instanceof ChallengeRequestResult.ProtocolError) {
            this.onError(((ChallengeRequestResult.ProtocolError)result).getData());
        } else if (challengeRequestResult instanceof ChallengeRequestResult.RuntimeError) {
            this.onError(((ChallengeRequestResult.RuntimeError)result).getThrowable());
        } else if (challengeRequestResult instanceof ChallengeRequestResult.Timeout) {
            this.onTimeout(((ChallengeRequestResult.Timeout)result).getData());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void onSuccess(ChallengeRequestData creqData, ChallengeResponseData cresData) {
        block5: {
            if (cresData.isChallengeCompleted()) {
                ChallengeResult challengeResult;
                this.getViewModel$3ds2sdk_release().stopTimer();
                if (creqData.getCancelReason() != null) {
                    challengeResult = new ChallengeResult.Canceled(this.getUiTypeCode(), this.initialUiType, this.intentData);
                } else {
                    String transStatus;
                    String string2 = cresData.getTransStatus();
                    if (string2 == null) {
                        string2 = "";
                    }
                    challengeResult = Intrinsics.areEqual((Object)"Y", (Object)(transStatus = string2)) ? (ChallengeResult)new ChallengeResult.Succeeded(this.getUiTypeCode(), this.initialUiType, this.intentData) : (ChallengeResult)new ChallengeResult.Failed(this.getUiTypeCode(), this.initialUiType, this.intentData);
                }
                ChallengeResult challengeResult2 = challengeResult;
                this.getViewModel$3ds2sdk_release().onFinish(challengeResult2);
            } else {
                this.getViewModel$3ds2sdk_release().onNextScreen(cresData);
            }
            AnalyticsDelegate analyticsDelegate = this.analyticsDelegate;
            if (analyticsDelegate == null) break block5;
            analyticsDelegate.didReceiveChallengeResponseWithTransactionId(cresData.getServerTransId(), this.getUiTypeCode());
        }
    }

    private final void onError(ErrorData data) {
        this.getViewModel$3ds2sdk_release().onFinish(new ChallengeResult.ProtocolError(data, this.initialUiType, this.intentData));
        this.getViewModel$3ds2sdk_release().stopTimer();
        this.errorRequestExecutor.executeAsync(data);
    }

    private final void onTimeout(ErrorData data) {
        this.getViewModel$3ds2sdk_release().stopTimer();
        this.errorRequestExecutor.executeAsync(data);
        this.getViewModel$3ds2sdk_release().onFinish(new ChallengeResult.Timeout(this.getUiTypeCode(), this.initialUiType, this.intentData));
    }

    private final void onError(Throwable throwable) {
        this.getViewModel$3ds2sdk_release().onFinish(new ChallengeResult.RuntimeError(throwable, this.initialUiType, this.intentData));
    }

    public final void clickSubmitButton() {
        this.getViewModel$3ds2sdk_release().submit(this.getChallengeAction());
    }

    private static final String uiTypeCode_delegate$lambda$0(ChallengeFragment this$0) {
        ChallengeResponseData challengeResponseData = this$0.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        UiType uiType = challengeResponseData.getUiType();
        String string2 = uiType != null ? uiType.getCode() : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final ViewModelProvider.Factory viewModel_delegate$lambda$1(ChallengeFragment this$0) {
        return new ChallengeActivityViewModel.Factory(this$0.challengeActionHandler, this$0.transactionTimer, this$0.errorReporter, this$0.workContext);
    }

    private static final ChallengeEntryViewFactory challengeEntryViewFactory_delegate$lambda$2(ChallengeFragment this$0) {
        FragmentActivity fragmentActivity = this$0.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity(...)");
        return new ChallengeEntryViewFactory((Context)fragmentActivity);
    }

    private static final ChallengeZoneView challengeZoneView_delegate$lambda$3(ChallengeFragment this$0) {
        ChallengeZoneView challengeZoneView = this$0.getViewBinding$3ds2sdk_release().caChallengeZone;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)challengeZoneView), (String)"caChallengeZone");
        return challengeZoneView;
    }

    private static final BrandZoneView brandZoneView_delegate$lambda$4(ChallengeFragment this$0) {
        BrandZoneView brandZoneView = this$0.getViewBinding$3ds2sdk_release().caBrandZone;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)brandZoneView), (String)"caBrandZone");
        return brandZoneView;
    }

    private static final ChallengeZoneTextView challengeZoneTextView_delegate$lambda$5(ChallengeFragment this$0) {
        ChallengeEntryViewFactory challengeEntryViewFactory = this$0.getChallengeEntryViewFactory();
        ChallengeResponseData challengeResponseData = this$0.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        return challengeEntryViewFactory.createChallengeEntryTextView(challengeResponseData, this$0.uiCustomization);
    }

    private static final ChallengeZoneSelectView challengeZoneSelectView_delegate$lambda$6(ChallengeFragment this$0) {
        ChallengeEntryViewFactory challengeEntryViewFactory = this$0.getChallengeEntryViewFactory();
        ChallengeResponseData challengeResponseData = this$0.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        return challengeEntryViewFactory.createChallengeEntrySelectView(challengeResponseData, this$0.uiCustomization);
    }

    private static final ChallengeZoneWebView challengeZoneWebView_delegate$lambda$7(ChallengeFragment this$0) {
        ChallengeEntryViewFactory challengeEntryViewFactory = this$0.getChallengeEntryViewFactory();
        ChallengeResponseData challengeResponseData = this$0.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        return challengeEntryViewFactory.createChallengeEntryWebView(challengeResponseData);
    }

    private static final InformationZoneView informationZoneView_delegate$lambda$8(ChallengeFragment this$0) {
        InformationZoneView informationZoneView = this$0.getViewBinding$3ds2sdk_release().caInformationZone;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)informationZoneView), (String)"caInformationZone");
        return informationZoneView;
    }

    private static final Unit onViewCreated$lambda$10(ChallengeFragment this$0, String challengeText) {
        ChallengeZoneTextView challengeZoneTextView = this$0.getChallengeZoneTextView();
        Intrinsics.checkNotNull((Object)challengeText);
        challengeZoneTextView.setText(challengeText);
        return Unit.INSTANCE;
    }

    private static final Unit onViewCreated$lambda$11(ChallengeFragment this$0, Unit it) {
        this$0.refreshUi();
        return Unit.INSTANCE;
    }

    private static final Unit onViewCreated$lambda$12(ChallengeFragment this$0, ChallengeRequestResult challengeRequestResult) {
        if (challengeRequestResult != null) {
            this$0.onChallengeRequestResult(challengeRequestResult);
        }
        return Unit.INSTANCE;
    }

    private static final void configure$lambda$13(ChallengeFragment this$0, View it) {
        this$0.getViewModel$3ds2sdk_release().onSubmitClicked(this$0.getChallengeAction());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateBrandZoneImages$lambda$15$lambda$14(ImageView $imageView, Bitmap bitmap) {
        if (bitmap != null) {
            void $this$isVisible$iv;
            View view = (View)$imageView;
            boolean value$iv = true;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            $imageView.setImageBitmap(bitmap);
        } else {
            void $this$isGone$iv;
            View $this$isVisible$iv = (View)$imageView;
            boolean value$iv = true;
            boolean $i$f$setGone = false;
            $this$isGone$iv.setVisibility(8);
        }
        return Unit.INSTANCE;
    }

    private static final void configureChallengeZoneView$lambda$17(ChallengeFragment this$0, View it) {
        this$0.getViewModel$3ds2sdk_release().onSubmitClicked(this$0.getChallengeAction());
        ChallengeResponseData challengeResponseData = this$0.cresData;
        if (challengeResponseData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
            challengeResponseData = null;
        }
        UiType uiType = challengeResponseData.getUiType();
        switch (uiType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uiType.ordinal()]) {
            case 1: {
                AnalyticsDelegate analyticsDelegate = this$0.analyticsDelegate;
                if (analyticsDelegate != null) {
                    ChallengeResponseData challengeResponseData2 = this$0.cresData;
                    if (challengeResponseData2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                        challengeResponseData2 = null;
                    }
                    analyticsDelegate.otpSubmitButtonTappedWithTransactionID(challengeResponseData2.getServerTransId());
                }
                break;
            }
            case 5: {
                AnalyticsDelegate analyticsDelegate = this$0.analyticsDelegate;
                if (analyticsDelegate != null) {
                    ChallengeResponseData challengeResponseData3 = this$0.cresData;
                    if (challengeResponseData3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cresData");
                        challengeResponseData3 = null;
                    }
                    analyticsDelegate.oobContinueButtonTappedWithTransactionID(challengeResponseData3.getServerTransId());
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void configureChallengeZoneView$lambda$18(ChallengeFragment this$0, View it) {
        this$0.getViewModel$3ds2sdk_release().submit(ChallengeAction.Resend.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeFragment$Companion;", "", "<init>", "()V", "ARG_CRES", "", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UiType.values().length];
            try {
                nArray[UiType.Text.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiType.SingleSelect.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiType.MultiSelect.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiType.Html.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiType.OutOfBand.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

