/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.crypto.impl.ConcatKDF;
import com.nimbusds.jose.crypto.impl.ECDH;
import com.nimbusds.jose.util.Base64URL;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.DiffieHellmanKeyGenerator;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/stripe3ds2/security/StripeDiffieHellmanKeyGenerator;", "Lcom/stripe/android/stripe3ds2/security/DiffieHellmanKeyGenerator;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "<init>", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "generate", "Ljavax/crypto/SecretKey;", "acsPublicKey", "Ljava/security/interfaces/ECPublicKey;", "sdkPrivateKey", "Ljava/security/interfaces/ECPrivateKey;", "agreementInfo", "", "Companion", "3ds2sdk_release"})
public final class StripeDiffieHellmanKeyGenerator
implements DiffieHellmanKeyGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private static final String HASH_ALGO = "SHA-256";
    private static final int KEY_LENGTH = 256;

    public StripeDiffieHellmanKeyGenerator(@NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
    }

    @Override
    @NotNull
    public SecretKey generate(@NotNull ECPublicKey acsPublicKey, @NotNull ECPrivateKey sdkPrivateKey, @NotNull String agreementInfo) {
        Object $this$generate_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)acsPublicKey, (String)"acsPublicKey");
        Intrinsics.checkNotNullParameter((Object)sdkPrivateKey, (String)"sdkPrivateKey");
        Intrinsics.checkNotNullParameter((Object)agreementInfo, (String)"agreementInfo");
        Object object = this;
        try {
            $this$generate_u24lambda_u240 = object;
            boolean bl = false;
            ConcatKDF keyDerivationFunction = new ConcatKDF(HASH_ALGO);
            $this$generate_u24lambda_u240 = Result.constructor-impl((Object)keyDerivationFunction.deriveKey(ECDH.deriveSharedSecret((ECPublicKey)acsPublicKey, (PrivateKey)sdkPrivateKey, null), 256, ConcatKDF.encodeStringData(null), ConcatKDF.encodeDataWithLength(null), ConcatKDF.encodeDataWithLength((Base64URL)Base64URL.encode((String)agreementInfo)), ConcatKDF.encodeIntData((int)256), ConcatKDF.encodeNoData()));
        }
        catch (Throwable bl) {
            $this$generate_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$generate_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$generate_u24lambda_u240 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (SecretKey)object2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/security/StripeDiffieHellmanKeyGenerator$Companion;", "", "<init>", "()V", "HASH_ALGO", "", "KEY_LENGTH", "", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

