/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.webkit.WebSettings;
import androidx.core.os.LocaleListCompat;
import com.stripe.android.stripe3ds2.init.AppInfo;
import com.stripe.android.stripe3ds2.init.AppInfoRepository;
import com.stripe.android.stripe3ds2.init.DeviceDataFactory;
import com.stripe.android.stripe3ds2.init.DeviceDataFactoryImpl;
import com.stripe.android.stripe3ds2.init.DeviceParam;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0097@\u00a2\u0006\u0002\u0010&J\n\u0010'\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n \u000e*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u001d\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/stripe/android/stripe3ds2/init/DeviceDataFactoryImpl;", "Lcom/stripe/android/stripe3ds2/init/DeviceDataFactory;", "context", "Landroid/content/Context;", "appInfoRepository", "Lcom/stripe/android/stripe3ds2/init/AppInfoRepository;", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "<init>", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/init/AppInfoRepository;Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;)V", "displayMetrics", "Landroid/util/DisplayMetrics;", "defaultUserAgent", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "telephonyManager", "Landroid/telephony/TelephonyManager;", "secureFRPMode", "", "audioManager", "Landroid/media/AudioManager;", "packageManager", "Landroid/content/pm/PackageManager;", "Landroid/content/pm/PackageManager;", "apiVersion", "dateFormat", "Ljava/text/SimpleDateFormat;", "dateTime", "codeName", "osName", "timeZone", "create", "", "", "sdkReferenceNumber", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "(Ljava/lang/String;Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildCodeName", "Companion", "3ds2sdk_release"})
public final class DeviceDataFactoryImpl
implements DeviceDataFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppInfoRepository appInfoRepository;
    @NotNull
    private final MessageVersionRegistry messageVersionRegistry;
    @NotNull
    private final DisplayMetrics displayMetrics;
    private final String defaultUserAgent;
    @NotNull
    private final TelephonyManager telephonyManager;
    private final int secureFRPMode;
    @NotNull
    private final AudioManager audioManager;
    private final PackageManager packageManager;
    private final int apiVersion;
    @NotNull
    private final SimpleDateFormat dateFormat;
    private final String dateTime;
    @NotNull
    private final String codeName;
    @NotNull
    private final String osName;
    private final int timeZone;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int SECONDS_IN_MINUTE = 60;

    public DeviceDataFactoryImpl(@NotNull Context context, @NotNull AppInfoRepository appInfoRepository, @NotNull MessageVersionRegistry messageVersionRegistry) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appInfoRepository, (String)"appInfoRepository");
        Intrinsics.checkNotNullParameter((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        this.appInfoRepository = appInfoRepository;
        this.messageVersionRegistry = messageVersionRegistry;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getDisplayMetrics(...)");
        this.displayMetrics = displayMetrics;
        this.defaultUserAgent = WebSettings.getDefaultUserAgent((Context)context);
        Object object = context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        this.telephonyManager = (TelephonyManager)object;
        this.secureFRPMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"secure_frp_mode", (int)0);
        Object object2 = context.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object2;
        this.packageManager = context.getPackageManager();
        this.apiVersion = Build.VERSION.SDK_INT;
        this.dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
        this.dateTime = this.dateFormat.format(Calendar.getInstance().getTime());
        String string = this.buildCodeName();
        if (string == null) {
            string = "UNKNOWN";
        }
        this.codeName = string;
        this.osName = "Android " + this.codeName + " " + Build.VERSION.RELEASE + " API " + this.apiVersion;
        this.timeZone = TimeZone.getDefault().getRawOffset() / 1000 / 60;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @TargetApi(value=33)
    @Nullable
    public Object create(@NotNull String var1_1, @NotNull SdkTransactionId var2_2, @NotNull Continuation<? super Map<String, ? extends Object>> $completion) {
        if (!($completion instanceof create.1)) ** GOTO lbl-1000
        var15_4 = $completion;
        if ((var15_4.label & -2147483648) != 0) {
            var15_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceDataFactoryImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.create(null, null, (Continuation<? super Map<String, ? extends Object>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new Pair[13];
                var5_7[0] = TuplesKt.to((Object)DeviceParam.PARAM_PLATFORM.toString(), (Object)"Android");
                var5_7[1] = TuplesKt.to((Object)DeviceParam.PARAM_DEVICE_MODEL.toString(), (Object)(Build.MANUFACTURER + "||" + Build.MODEL));
                var5_7[2] = TuplesKt.to((Object)DeviceParam.PARAM_OS_NAME.toString(), (Object)this.osName);
                var5_7[3] = TuplesKt.to((Object)DeviceParam.PARAM_OS_VERSION.toString(), (Object)Build.VERSION.RELEASE);
                var6_8 = new Locale[]{Locale.getDefault()};
                var5_7[4] = TuplesKt.to((Object)DeviceParam.PARAM_LOCALE.toString(), (Object)LocaleListCompat.create((Locale[])var6_8).toLanguageTags());
                var5_7[5] = TuplesKt.to((Object)DeviceParam.PARAM_TIME_ZONE.toString(), (Object)String.valueOf(this.timeZone));
                v0 = DeviceParam.PARAM_SCREEN_RESOLUTION.toString();
                var7_9 = Locale.ROOT;
                var8_10 = "%sx%s";
                var9_11 = new Object[]{Boxing.boxInt((int)this.displayMetrics.heightPixels), Boxing.boxInt((int)this.displayMetrics.widthPixels)};
                v1 = String.format(var7_9, var8_10, Arrays.copyOf(var9_11, var9_11.length));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(...)");
                var5_7[6] = TuplesKt.to((Object)v0, (Object)v1);
                var12_12 = DeviceParam.PARAM_SDK_APP_ID.toString();
                var11_13 = 7;
                var10_14 = var5_7;
                $continuation.L$0 = this;
                $continuation.L$1 = sdkReferenceNumber;
                $continuation.L$2 = sdkTransactionId;
                $continuation.L$3 = var5_7;
                $continuation.L$4 = var10_14;
                $continuation.L$5 = var12_12;
                $continuation.I$0 = var11_13;
                $continuation.label = 1;
                v2 = this.appInfoRepository.get((Continuation<? super AppInfo>)$continuation);
                if (v2 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl53
            }
            case 1: {
                var11_13 = $continuation.I$0;
                var12_12 = (String)$continuation.L$5;
                var10_14 = (Pair[])$continuation.L$4;
                var5_7 = (Pair[])$continuation.L$3;
                sdkTransactionId = (SdkTransactionId)$continuation.L$2;
                sdkReferenceNumber = (String)$continuation.L$1;
                this = (DeviceDataFactoryImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                var13_15 = v2;
                var10_14[var11_13] = TuplesKt.to((Object)var12_12, (Object)((AppInfo)var13_15).getSdkAppId());
                var5_7[8] = TuplesKt.to((Object)DeviceParam.PARAM_SDK_VERSION.toString(), (Object)this.messageVersionRegistry.getCurrent());
                var5_7[9] = TuplesKt.to((Object)DeviceParam.PARAM_SDK_REF_NUMBER.toString(), (Object)sdkReferenceNumber);
                var5_7[10] = TuplesKt.to((Object)DeviceParam.PARAM_DATE_TIME.toString(), (Object)this.dateTime);
                var5_7[11] = TuplesKt.to((Object)DeviceParam.PARAM_SDK_TRANS_ID.toString(), (Object)sdkTransactionId.toString());
                var5_7[12] = TuplesKt.to((Object)DeviceParam.PARAM_WEB_VIEW_USER_AGENT.toString(), (Object)this.defaultUserAgent);
                map = MapsKt.hashMapOf((Pair[])var5_7);
                if (this.apiVersion >= 28) {
                    ((Map)map).put(DeviceParam.PARAM_SIM_CARRIER_ID.toString(), String.valueOf(this.telephonyManager.getSimCarrierId()));
                    ((Map)map).put(DeviceParam.PARAM_SIM_CARRIER_ID_NAME.toString(), String.valueOf(this.telephonyManager.getSimCarrierIdName()));
                }
                if (this.apiVersion >= 29) {
                    ((Map)map).put(DeviceParam.PARAM_SIM_SPECIFIC_CARRIER_ID.toString(), String.valueOf(this.telephonyManager.getSimSpecificCarrierId()));
                    ((Map)map).put(DeviceParam.PARAM_SIM_SPECIFIC_CARRIER_ID_NAME.toString(), String.valueOf(this.telephonyManager.getSimSpecificCarrierIdName()));
                    if (this.packageManager.hasSystemFeature("android.hardware.telephony.ims")) {
                        ((Map)map).put(DeviceParam.PARAM_RTT_CALLING_MODE.toString(), String.valueOf(this.telephonyManager.isRttSupported()));
                    }
                }
                if (this.apiVersion >= 30) {
                    ((Map)map).put(DeviceParam.PARAM_SUBSCRIPTION_ID.toString(), String.valueOf(this.telephonyManager.getSubscriptionId()));
                    ((Map)map).put(DeviceParam.PARAM_SECURE_FRP_MODE.toString(), this.secureFRPMode == 1 ? "true" : "false");
                }
                if (this.apiVersion >= 31) {
                    ((Map)map).put(DeviceParam.PARAM_HARDWARE_SKU.toString(), Build.SKU);
                    ((Map)map).put(DeviceParam.PARAM_SOC_MANUFACTURER.toString(), Build.SOC_MANUFACTURER);
                    ((Map)map).put(DeviceParam.PARAM_SOC_MODEL.toString(), Build.SOC_MODEL);
                }
                if (this.apiVersion >= 33) {
                    ((Map)map).put(DeviceParam.PARAM_APPLY_RAMPING_RINGER.toString(), String.valueOf(this.audioManager.isRampingRingerEnabled()));
                }
                return map;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String buildCodeName() {
        Field[] fieldArray = Build.VERSION_CODES.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
        for (Field field : fieldArray) {
            String fieldName;
            Intrinsics.checkNotNullExpressionValue((Object)field.getName(), (String)"getName(...)");
            int fieldValue = -1;
            try {
                fieldValue = field.getInt(new Object());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (fieldValue != Build.VERSION.SDK_INT) continue;
            return fieldName;
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/stripe3ds2/init/DeviceDataFactoryImpl$Companion;", "", "<init>", "()V", "MILLIS_IN_SECOND", "", "SECONDS_IN_MINUTE", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

