/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ProgressBar;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AppCompatActivity;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u00020\u00112\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0007J\u0017\u0010\u0017\u001a\u00020\u00162\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u0018J\u001f\u0010\u0017\u001a\u00020\u00162\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0007J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0007J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0007J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/stripe/android/stripe3ds2/utils/CustomizeUtils;", "", "()V", "DEFAULT_DARKEN_FACTOR", "", "applyProgressBarColor", "", "progressBar", "Landroid/widget/ProgressBar;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "applyProgressBarColor$3ds2sdk_release", "buildStyledText", "Landroid/text/SpannableString;", "context", "Landroid/content/Context;", "text", "", "customization", "Lcom/stripe/android/stripe3ds2/init/ui/Customization;", "colorIntToHex", "color", "", "darken", "darken$3ds2sdk_release", "factor", "requireValidColor", "hexColor", "requireValidDimension", "dimension", "requireValidFontSize", "fontSize", "requireValidString", "string", "setStatusBarColor", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "statusBarColor", "3ds2sdk_release"})
public final class CustomizeUtils {
    @NotNull
    public static final CustomizeUtils INSTANCE = new CustomizeUtils();
    private static final float DEFAULT_DARKEN_FACTOR = 0.8f;

    private CustomizeUtils() {
    }

    public final void applyProgressBarColor$3ds2sdk_release(@NotNull ProgressBar progressBar, @Nullable UiCustomization uiCustomization) {
        String string;
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
        UiCustomization uiCustomization2 = uiCustomization;
        if (uiCustomization2 != null && (string = uiCustomization2.getAccentColor()) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String accentColor = string2;
            boolean bl3 = false;
            progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)Color.parseColor((String)accentColor)));
        }
    }

    public final void setStatusBarColor(@NotNull AppCompatActivity activity, @ColorInt int statusBarColor) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getWindow().setStatusBarColor(statusBarColor);
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int color, float factor) {
        int alpha = Color.alpha((int)color);
        int red = (int)((float)Color.red((int)color) * factor);
        int green = (int)((float)Color.green((int)color) * factor);
        int blue = (int)((float)Color.blue((int)color) * factor);
        int n = 0;
        int n2 = 0;
        n = Math.max(red, n);
        n2 = 255;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        n = 0;
        n2 = 0;
        n = Math.max(green, n);
        n2 = 255;
        bl = false;
        int n4 = Math.min(n, n2);
        n = 0;
        n2 = 0;
        n = Math.max(blue, n);
        n2 = 255;
        bl = false;
        return Color.argb((int)alpha, (int)n3, (int)n4, (int)Math.min(n, n2));
    }

    @JvmStatic
    @NotNull
    public static final String colorIntToHex(@ColorInt int color) {
        int alpha = Color.alpha((int)color);
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        int red = Color.red((int)color);
        StringBuilder stringBuilder = new StringBuilder().append('#');
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.ENGLISH;
        String string = "%02X";
        Object[] objectArray = new Object[]{alpha};
        boolean bl = false;
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        stringCompanionObject = StringCompanionObject.INSTANCE;
        locale = Locale.ENGLISH;
        string = "%02X";
        objectArray = new Object[]{red};
        bl = false;
        String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        stringCompanionObject = StringCompanionObject.INSTANCE;
        locale = Locale.ENGLISH;
        string = "%02X";
        objectArray = new Object[]{green};
        bl = false;
        String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string4);
        stringCompanionObject = StringCompanionObject.INSTANCE;
        locale = Locale.ENGLISH;
        string = "%02X";
        objectArray = new Object[]{blue};
        bl = false;
        String string5 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(locale, format, *args)");
        return stringBuilder4.append(string5).toString();
    }

    @NotNull
    public final SpannableString buildStyledText(@NotNull Context context, @NotNull String text, @NotNull Customization customization) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
        SpannableString styledText = new SpannableString((CharSequence)text);
        Object object2 = customization.getTextColor();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            Object textColor = object;
            boolean bl3 = false;
            styledText.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)textColor)), 0, styledText.length(), 0);
        }
        object = customization.getTextFontSize();
        bl2 = false;
        bl = false;
        int it = ((Number)object).intValue();
        boolean bl4 = false;
        Object object3 = object2 = it > 0 ? object : null;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            int textFontSize = ((Number)object).intValue();
            boolean bl5 = false;
            int fontSize = (int)TypedValue.applyDimension((int)2, (float)textFontSize, (DisplayMetrics)context.getResources().getDisplayMetrics());
            AbsoluteSizeSpan sizeSpan = new AbsoluteSizeSpan(fontSize);
            styledText.setSpan((Object)sizeSpan, 0, styledText.length(), 0);
        }
        object2 = customization.getTextFontName();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            Object textFontName = object;
            boolean bl6 = false;
            styledText.setSpan((Object)new TypefaceSpan((String)textFontName), 0, styledText.length(), 0);
        }
        return styledText;
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int color) {
        return this.darken$3ds2sdk_release(color, 0.8f);
    }

    @JvmStatic
    @NotNull
    public static final String requireValidColor(@NotNull String hexColor) throws InvalidInputException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hexColor, (String)"hexColor");
        CustomizeUtils customizeUtils = INSTANCE;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$requireValidColor_u24lambda_u2d5 = customizeUtils;
            boolean bl2 = false;
            Color.parseColor((String)hexColor);
            $this$requireValidColor_u24lambda_u2d5 = hexColor;
            bl2 = false;
            object = Result.constructor-impl((Object)$this$requireValidColor_u24lambda_u2d5);
        }
        catch (Throwable $this$requireValidColor_u24lambda_u2d5) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$requireValidColor_u24lambda_u2d5));
        }
        customizeUtils = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)customizeUtils);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            throw new InvalidInputException(Intrinsics.stringPlus((String)"Unable to parse color: ", (Object)hexColor), null, 2, null);
        }
        return (String)((Object)customizeUtils);
    }

    @JvmStatic
    public static final int requireValidFontSize(int fontSize) throws InvalidInputException {
        if (fontSize <= 0) {
            throw new InvalidInputException("Font size must be greater than 0", null, 2, null);
        }
        return fontSize;
    }

    @JvmStatic
    public static final int requireValidDimension(int dimension) throws InvalidInputException {
        if (dimension < 0) {
            throw new InvalidInputException("Dimension must be greater or equal to 0", null, 2, null);
        }
        return dimension;
    }

    @JvmStatic
    @NotNull
    public static final String requireValidString(@NotNull String string) throws InvalidInputException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (StringsKt.isBlank((CharSequence)string)) {
            throw new InvalidInputException("String must not be null or empty", null, 2, null);
        }
        return string;
    }
}

