/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.transaction.HttpClient;
import com.stripe.android.stripe3ds2.transaction.HttpResponse;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002!\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0015\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/StripeHttpClient;", "Lcom/stripe/android/stripe3ds2/transaction/HttpClient;", "url", "", "connectionFactory", "Lcom/stripe/android/stripe3ds2/transaction/StripeHttpClient$ConnectionFactory;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljava/lang/String;Lcom/stripe/android/stripe3ds2/transaction/StripeHttpClient$ConnectionFactory;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lkotlin/coroutines/CoroutineContext;)V", "createConnection", "Ljava/net/HttpURLConnection;", "createGetConnection", "createPostConnection", "requestBody", "contentType", "doGetRequest", "Ljava/io/InputStream;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doPostRequest", "Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doPostRequestInternal", "getResponseBody", "inputStream", "handlePostResponse", "conn", "handlePostResponse$3ds2sdk_release", "isSuccessfulResponse", "", "responseCode", "", "ConnectionFactory", "DefaultConnectionFactory", "3ds2sdk_release"})
public final class StripeHttpClient
implements HttpClient {
    @NotNull
    private final String url;
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final CoroutineContext workContext;

    public StripeHttpClient(@NotNull String url, @NotNull ConnectionFactory connectionFactory, @NotNull ErrorReporter errorReporter2, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.url = url;
        this.connectionFactory = connectionFactory;
        this.errorReporter = errorReporter2;
        this.workContext = workContext;
    }

    public /* synthetic */ StripeHttpClient(String string, ConnectionFactory connectionFactory, ErrorReporter errorReporter2, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            connectionFactory = new DefaultConnectionFactory();
        }
        this(string, connectionFactory, errorReporter2, coroutineContext);
    }

    @Override
    @Nullable
    public Object doGetRequest(@NotNull Continuation<? super InputStream> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.workContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InputStream>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StripeHttpClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        int n;
                        boolean bl;
                        Object object3;
                        CoroutineScope $this$withContext;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = $this$withContext = (CoroutineScope)this.L$0;
                        StripeHttpClient stripeHttpClient = this.this$0;
                        boolean bl2 = false;
                        try {
                            object3 = Result.Companion;
                            Object object4 = coroutineScope;
                            boolean bl3 = false;
                            HttpURLConnection httpURLConnection = StripeHttpClient.access$createGetConnection(stripeHttpClient);
                            bl = false;
                            boolean bl4 = false;
                            HttpURLConnection it = httpURLConnection;
                            boolean bl5 = false;
                            it.connect();
                            HttpURLConnection connection = httpURLConnection;
                            n = connection.getResponseCode();
                            object4 = n == 200 ? connection.getInputStream() : null;
                            boolean bl6 = false;
                            object3 = Result.constructor-impl((Object)object4);
                        }
                        catch (Throwable throwable) {
                            Result.Companion companion = Result.Companion;
                            n = 0;
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        coroutineScope = object3;
                        stripeHttpClient = this.this$0;
                        bl2 = false;
                        boolean bl7 = false;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)coroutineScope);
                        if (throwable != null) {
                            Throwable throwable2 = throwable;
                            boolean bl8 = false;
                            boolean bl9 = false;
                            Throwable throwable3 = throwable2;
                            bl = false;
                            Throwable it = throwable3;
                            boolean bl10 = false;
                            StripeHttpClient.access$getErrorReporter$p(stripeHttpClient).reportError(it);
                        }
                        boolean bl11 = false;
                        return Result.isFailure-impl((Object)coroutineScope) ? null : coroutineScope;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super InputStream>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super InputStream> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object doPostRequest(@NotNull String requestBody, @NotNull String contentType, @NotNull Continuation<? super HttpResponse> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.workContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, requestBody, contentType, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StripeHttpClient this$0;
            final /* synthetic */ String $requestBody;
            final /* synthetic */ String $contentType;
            {
                this.this$0 = $receiver;
                this.$requestBody = $requestBody;
                this.$contentType = $contentType;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        Object object4;
                        CoroutineScope $this$withContext;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = $this$withContext = (CoroutineScope)this.L$0;
                        StripeHttpClient stripeHttpClient = this.this$0;
                        String string = this.$requestBody;
                        String string2 = this.$contentType;
                        boolean bl = false;
                        try {
                            object4 = Result.Companion;
                            object3 = coroutineScope;
                            boolean bl2 = false;
                            object3 = StripeHttpClient.access$doPostRequestInternal(stripeHttpClient, string, string2);
                            boolean bl3 = false;
                            object4 = Result.constructor-impl((Object)object3);
                        }
                        catch (Throwable throwable) {
                            Result.Companion companion = Result.Companion;
                            boolean bl4 = false;
                            object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        coroutineScope = object4;
                        stripeHttpClient = this.this$0;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)coroutineScope);
                        if (throwable != null) {
                            Throwable throwable2 = throwable;
                            bl = false;
                            boolean bl7 = false;
                            object3 = throwable2;
                            boolean bl8 = false;
                            Object it = object3;
                            boolean bl9 = false;
                            StripeHttpClient.access$getErrorReporter$p(stripeHttpClient).reportError((Throwable)it);
                        }
                        boolean bl10 = false;
                        bl5 = false;
                        Throwable throwable3 = Result.exceptionOrNull-impl((Object)coroutineScope);
                        if (throwable3 != null) {
                            Throwable it = throwable3;
                            boolean bl11 = false;
                            throw new SDKRuntimeException(it);
                        }
                        return coroutineScope;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super HttpResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpResponse doPostRequestInternal(String requestBody, String contentType) {
        HttpURLConnection httpURLConnection = this.createPostConnection(requestBody, contentType);
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection connection = httpURLConnection;
        boolean bl3 = false;
        Closeable closeable = connection.getOutputStream();
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)os, (String)"os");
            Closeable closeable2 = os;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            boolean bl7 = false;
            closeable2 = new OutputStreamWriter((OutputStream)closeable2, charset);
            boolean bl8 = false;
            bl7 = false;
            Throwable throwable2 = null;
            try {
                OutputStreamWriter osw = (OutputStreamWriter)closeable2;
                boolean bl9 = false;
                osw.write(requestBody);
                osw.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        connection.connect();
        return this.handlePostResponse$3ds2sdk_release(connection);
    }

    @VisibleForTesting
    @NotNull
    public final HttpResponse handlePostResponse$3ds2sdk_release(@NotNull HttpURLConnection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        int responseCode = conn.getResponseCode();
        boolean isSuccessfulResponse = this.isSuccessfulResponse(responseCode);
        if (!isSuccessfulResponse) {
            throw new SDKRuntimeException("Unsuccessful response code from " + this.url + ": " + responseCode, null, 2, null);
        }
        InputStream inputStream = conn.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.inputStream");
        return new HttpResponse(this.getResponseBody(inputStream), conn.getContentType());
    }

    private final boolean isSuccessfulResponse(int responseCode) {
        return 200 <= responseCode ? responseCode <= 299 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getResponseBody(InputStream inputStream) {
        Object object;
        Object object2 = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            StripeHttpClient $this$getResponseBody_u24lambda_u2d3 = object2;
            boolean bl2 = false;
            Closeable closeable = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl3 = false;
            Object object3 = closeable;
            int n = 0;
            object3 = new InputStreamReader((InputStream)object3, charset);
            n = 8192;
            boolean bl4 = false;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            boolean bl5 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                BufferedReader p0 = (BufferedReader)closeable;
                boolean bl6 = false;
                object3 = TextStreamsKt.readText((Reader)p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object object4 = object3;
            boolean bl7 = false;
            object = Result.constructor-impl((Object)object4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl8 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        bl = false;
        object2 = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        bl = false;
        Object object5 = object2;
        if (object5 == null) {
            object5 = "";
        }
        return object5;
    }

    private final HttpURLConnection createPostConnection(String requestBody, String contentType) {
        HttpURLConnection httpURLConnection = this.createConnection();
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection $this$createPostConnection_u24lambda_u2d4 = httpURLConnection;
        boolean bl3 = false;
        $this$createPostConnection_u24lambda_u2d4.setRequestMethod("POST");
        $this$createPostConnection_u24lambda_u2d4.setDoOutput(true);
        $this$createPostConnection_u24lambda_u2d4.setRequestProperty("Content-Type", contentType);
        $this$createPostConnection_u24lambda_u2d4.setRequestProperty("Content-Length", String.valueOf(requestBody.length()));
        return httpURLConnection;
    }

    private final HttpURLConnection createGetConnection() {
        HttpURLConnection httpURLConnection = this.createConnection();
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection $this$createGetConnection_u24lambda_u2d5 = httpURLConnection;
        boolean bl3 = false;
        $this$createGetConnection_u24lambda_u2d5.setDoInput(true);
        return httpURLConnection;
    }

    private final HttpURLConnection createConnection() {
        return this.connectionFactory.create(this.url);
    }

    public static final /* synthetic */ HttpURLConnection access$createGetConnection(StripeHttpClient $this) {
        return $this.createGetConnection();
    }

    public static final /* synthetic */ ErrorReporter access$getErrorReporter$p(StripeHttpClient $this) {
        return $this.errorReporter;
    }

    public static final /* synthetic */ HttpResponse access$doPostRequestInternal(StripeHttpClient $this, String requestBody, String contentType) {
        return $this.doPostRequestInternal(requestBody, contentType);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/StripeHttpClient$ConnectionFactory;", "", "create", "Ljava/net/HttpURLConnection;", "url", "", "3ds2sdk_release"})
    public static interface ConnectionFactory {
        @NotNull
        public HttpURLConnection create(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/StripeHttpClient$DefaultConnectionFactory;", "Lcom/stripe/android/stripe3ds2/transaction/StripeHttpClient$ConnectionFactory;", "()V", "create", "Ljava/net/HttpURLConnection;", "url", "", "3ds2sdk_release"})
    private static final class DefaultConnectionFactory
    implements ConnectionFactory {
        @Override
        @NotNull
        public HttpURLConnection create(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URLConnection uRLConnection = new URL(url).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            return (HttpURLConnection)uRLConnection;
        }
    }
}

