package com.stripe.android.stripe3ds2.transaction

import android.content.Context
import android.content.Intent
import android.os.Parcelable
import androidx.activity.result.contract.ActivityResultContract
import androidx.core.os.bundleOf
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization
import kotlinx.parcelize.Parcelize
import java.security.KeyPair
import java.security.cert.X509Certificate

class TransactionContract :
    ActivityResultContract<TransactionContract.Args, ChallengeResult>() {

    override fun createIntent(
        context: Context,
        input: Args
    ): Intent {
        return Intent(context, TransactionActivity::class.java)
            .putExtras(input.toBundle())
    }

    override fun parseResult(resultCode: Int, intent: Intent?): ChallengeResult {
        return ChallengeResult.fromIntent(intent)
    }

    @Parcelize
    data class Args(
        internal val sdkTransactionId: SdkTransactionId,
        internal val sdkReferenceNumber: String,
        internal val isLiveMode: Boolean,
        internal val uiCustomization: StripeUiCustomization,
        internal val rootCerts: List<X509Certificate>,
        internal val sdkKeyPair: KeyPair,
        internal val enableLogging: Boolean,
        internal val challengeParameters: ChallengeParameters,
        internal val timeoutMins: Int,
        internal val intentData: IntentData
    ) : Parcelable {

        fun toBundle() = bundleOf(EXTRA_ARGS to this)

        internal companion object {
            private const val EXTRA_ARGS = "TransactionContractArgs"

            fun fromIntent(intent: Intent): Args? {
                return intent.getParcelableExtra(EXTRA_ARGS)
            }
        }
    }
}
