/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.core.os.BundleKt;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeResult;
import com.stripe.android.stripe3ds2.transaction.IntentData;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.TransactionActivity;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/TransactionContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/stripe3ds2/transaction/TransactionContract$Args;", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeResult;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "3ds2sdk_release"})
public final class TransactionContract
extends ActivityResultContract<Args, ChallengeResult> {
    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intent intent = new Intent(context, TransactionActivity.class).putExtras(input.toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, TransactionActivity::class.java)\n            .putExtras(input.toBundle())");
        return intent;
    }

    @NotNull
    public ChallengeResult parseResult(int resultCode, @Nullable Intent intent) {
        return ChallengeResult.Companion.fromIntent(intent);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 L2\u00020\u0001:\u0001LB[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010*\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b+J\u000e\u0010,\u001a\u00020\u0015H\u00c0\u0003\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0002\b1J\u000e\u00102\u001a\u00020\tH\u00c0\u0003\u00a2\u0006\u0002\b3J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c0\u0003\u00a2\u0006\u0002\b5J\u000e\u00106\u001a\u00020\u000eH\u00c0\u0003\u00a2\u0006\u0002\b7J\u000e\u00108\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0002\b9J\u000e\u0010:\u001a\u00020\u0011H\u00c0\u0003\u00a2\u0006\u0002\b;J\u000e\u0010<\u001a\u00020\u0013H\u00c0\u0003\u00a2\u0006\u0002\b=Js\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u00c6\u0001J\t\u0010?\u001a\u00020\u0013H\u00d6\u0001J\u0013\u0010@\u001a\u00020\u00072\b\u0010A\u001a\u0004\u0018\u00010BH\u00d6\u0003J\t\u0010C\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010D\u001a\u00020EJ\t\u0010F\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0013H\u00d6\u0001R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u000f\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006M"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/TransactionContract$Args;", "Landroid/os/Parcelable;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "sdkReferenceNumber", "", "isLiveMode", "", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "sdkKeyPair", "Ljava/security/KeyPair;", "enableLogging", "challengeParameters", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeParameters;", "timeoutMins", "", "intentData", "Lcom/stripe/android/stripe3ds2/transaction/IntentData;", "(Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;Ljava/util/List;Ljava/security/KeyPair;ZLcom/stripe/android/stripe3ds2/transaction/ChallengeParameters;ILcom/stripe/android/stripe3ds2/transaction/IntentData;)V", "getChallengeParameters$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/transaction/ChallengeParameters;", "getEnableLogging$3ds2sdk_release", "()Z", "getIntentData$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/transaction/IntentData;", "isLiveMode$3ds2sdk_release", "getRootCerts$3ds2sdk_release", "()Ljava/util/List;", "getSdkKeyPair$3ds2sdk_release", "()Ljava/security/KeyPair;", "getSdkReferenceNumber$3ds2sdk_release", "()Ljava/lang/String;", "getSdkTransactionId$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "getTimeoutMins$3ds2sdk_release", "()I", "getUiCustomization$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "component1", "component1$3ds2sdk_release", "component10", "component10$3ds2sdk_release", "component2", "component2$3ds2sdk_release", "component3", "component3$3ds2sdk_release", "component4", "component4$3ds2sdk_release", "component5", "component5$3ds2sdk_release", "component6", "component6$3ds2sdk_release", "component7", "component7$3ds2sdk_release", "component8", "component8$3ds2sdk_release", "component9", "component9$3ds2sdk_release", "copy", "describeContents", "equals", "other", "", "hashCode", "toBundle", "Landroid/os/Bundle;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "3ds2sdk_release"})
    @Parcelize
    public static final class Args
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SdkTransactionId sdkTransactionId;
        @NotNull
        private final String sdkReferenceNumber;
        private final boolean isLiveMode;
        @NotNull
        private final StripeUiCustomization uiCustomization;
        @NotNull
        private final List<X509Certificate> rootCerts;
        @NotNull
        private final KeyPair sdkKeyPair;
        private final boolean enableLogging;
        @NotNull
        private final ChallengeParameters challengeParameters;
        private final int timeoutMins;
        @NotNull
        private final IntentData intentData;
        @NotNull
        public static final Parcelable.Creator<Args> CREATOR;
        @NotNull
        private static final String EXTRA_ARGS = "TransactionContractArgs";

        public Args(@NotNull SdkTransactionId sdkTransactionId2, @NotNull String sdkReferenceNumber, boolean isLiveMode, @NotNull StripeUiCustomization uiCustomization, @NotNull List<? extends X509Certificate> rootCerts, @NotNull KeyPair sdkKeyPair, boolean enableLogging, @NotNull ChallengeParameters challengeParameters, int timeoutMins, @NotNull IntentData intentData) {
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId2, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
            Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            Intrinsics.checkNotNullParameter((Object)sdkKeyPair, (String)"sdkKeyPair");
            Intrinsics.checkNotNullParameter((Object)challengeParameters, (String)"challengeParameters");
            Intrinsics.checkNotNullParameter((Object)intentData, (String)"intentData");
            this.sdkTransactionId = sdkTransactionId2;
            this.sdkReferenceNumber = sdkReferenceNumber;
            this.isLiveMode = isLiveMode;
            this.uiCustomization = uiCustomization;
            this.rootCerts = rootCerts;
            this.sdkKeyPair = sdkKeyPair;
            this.enableLogging = enableLogging;
            this.challengeParameters = challengeParameters;
            this.timeoutMins = timeoutMins;
            this.intentData = intentData;
        }

        @NotNull
        public final SdkTransactionId getSdkTransactionId$3ds2sdk_release() {
            return this.sdkTransactionId;
        }

        @NotNull
        public final String getSdkReferenceNumber$3ds2sdk_release() {
            return this.sdkReferenceNumber;
        }

        public final boolean isLiveMode$3ds2sdk_release() {
            return this.isLiveMode;
        }

        @NotNull
        public final StripeUiCustomization getUiCustomization$3ds2sdk_release() {
            return this.uiCustomization;
        }

        @NotNull
        public final List<X509Certificate> getRootCerts$3ds2sdk_release() {
            return this.rootCerts;
        }

        @NotNull
        public final KeyPair getSdkKeyPair$3ds2sdk_release() {
            return this.sdkKeyPair;
        }

        public final boolean getEnableLogging$3ds2sdk_release() {
            return this.enableLogging;
        }

        @NotNull
        public final ChallengeParameters getChallengeParameters$3ds2sdk_release() {
            return this.challengeParameters;
        }

        public final int getTimeoutMins$3ds2sdk_release() {
            return this.timeoutMins;
        }

        @NotNull
        public final IntentData getIntentData$3ds2sdk_release() {
            return this.intentData;
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)EXTRA_ARGS, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        @NotNull
        public final SdkTransactionId component1$3ds2sdk_release() {
            return this.sdkTransactionId;
        }

        @NotNull
        public final String component2$3ds2sdk_release() {
            return this.sdkReferenceNumber;
        }

        public final boolean component3$3ds2sdk_release() {
            return this.isLiveMode;
        }

        @NotNull
        public final StripeUiCustomization component4$3ds2sdk_release() {
            return this.uiCustomization;
        }

        @NotNull
        public final List<X509Certificate> component5$3ds2sdk_release() {
            return this.rootCerts;
        }

        @NotNull
        public final KeyPair component6$3ds2sdk_release() {
            return this.sdkKeyPair;
        }

        public final boolean component7$3ds2sdk_release() {
            return this.enableLogging;
        }

        @NotNull
        public final ChallengeParameters component8$3ds2sdk_release() {
            return this.challengeParameters;
        }

        public final int component9$3ds2sdk_release() {
            return this.timeoutMins;
        }

        @NotNull
        public final IntentData component10$3ds2sdk_release() {
            return this.intentData;
        }

        @NotNull
        public final Args copy(@NotNull SdkTransactionId sdkTransactionId2, @NotNull String sdkReferenceNumber, boolean isLiveMode, @NotNull StripeUiCustomization uiCustomization, @NotNull List<? extends X509Certificate> rootCerts, @NotNull KeyPair sdkKeyPair, boolean enableLogging, @NotNull ChallengeParameters challengeParameters, int timeoutMins, @NotNull IntentData intentData) {
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId2, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
            Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            Intrinsics.checkNotNullParameter((Object)sdkKeyPair, (String)"sdkKeyPair");
            Intrinsics.checkNotNullParameter((Object)challengeParameters, (String)"challengeParameters");
            Intrinsics.checkNotNullParameter((Object)intentData, (String)"intentData");
            return new Args(sdkTransactionId2, sdkReferenceNumber, isLiveMode, uiCustomization, rootCerts, sdkKeyPair, enableLogging, challengeParameters, timeoutMins, intentData);
        }

        public static /* synthetic */ Args copy$default(Args args, SdkTransactionId sdkTransactionId2, String string, boolean bl, StripeUiCustomization stripeUiCustomization, List list, KeyPair keyPair, boolean bl2, ChallengeParameters challengeParameters, int n, IntentData intentData, int n2, Object object) {
            if ((n2 & 1) != 0) {
                sdkTransactionId2 = args.sdkTransactionId;
            }
            if ((n2 & 2) != 0) {
                string = args.sdkReferenceNumber;
            }
            if ((n2 & 4) != 0) {
                bl = args.isLiveMode;
            }
            if ((n2 & 8) != 0) {
                stripeUiCustomization = args.uiCustomization;
            }
            if ((n2 & 0x10) != 0) {
                list = args.rootCerts;
            }
            if ((n2 & 0x20) != 0) {
                keyPair = args.sdkKeyPair;
            }
            if ((n2 & 0x40) != 0) {
                bl2 = args.enableLogging;
            }
            if ((n2 & 0x80) != 0) {
                challengeParameters = args.challengeParameters;
            }
            if ((n2 & 0x100) != 0) {
                n = args.timeoutMins;
            }
            if ((n2 & 0x200) != 0) {
                intentData = args.intentData;
            }
            return args.copy(sdkTransactionId2, string, bl, stripeUiCustomization, list, keyPair, bl2, challengeParameters, n, intentData);
        }

        @NotNull
        public String toString() {
            return "Args(sdkTransactionId=" + this.sdkTransactionId + ", sdkReferenceNumber=" + this.sdkReferenceNumber + ", isLiveMode=" + this.isLiveMode + ", uiCustomization=" + this.uiCustomization + ", rootCerts=" + this.rootCerts + ", sdkKeyPair=" + this.sdkKeyPair + ", enableLogging=" + this.enableLogging + ", challengeParameters=" + this.challengeParameters + ", timeoutMins=" + this.timeoutMins + ", intentData=" + this.intentData + ')';
        }

        public int hashCode() {
            int result = this.sdkTransactionId.hashCode();
            result = result * 31 + this.sdkReferenceNumber.hashCode();
            int n = this.isLiveMode ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.uiCustomization.hashCode();
            result = result * 31 + ((Object)this.rootCerts).hashCode();
            result = result * 31 + this.sdkKeyPair.hashCode();
            int n2 = this.enableLogging ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.challengeParameters.hashCode();
            result = result * 31 + Integer.hashCode(this.timeoutMins);
            result = result * 31 + this.intentData.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.sdkTransactionId, (Object)args.sdkTransactionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sdkReferenceNumber, (Object)args.sdkReferenceNumber)) {
                return false;
            }
            if (this.isLiveMode != args.isLiveMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uiCustomization, (Object)args.uiCustomization)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rootCerts, args.rootCerts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sdkKeyPair, (Object)args.sdkKeyPair)) {
                return false;
            }
            if (this.enableLogging != args.enableLogging) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.challengeParameters, (Object)args.challengeParameters)) {
                return false;
            }
            if (this.timeoutMins != args.timeoutMins) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.intentData, (Object)args.intentData);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.sdkTransactionId.writeToParcel(out, flags);
            out.writeString(this.sdkReferenceNumber);
            out.writeInt(this.isLiveMode ? 1 : 0);
            out.writeParcelable((Parcelable)this.uiCustomization, flags);
            List<X509Certificate> list = this.rootCerts;
            out.writeInt(list.size());
            Iterator<X509Certificate> iterator = list.iterator();
            while (iterator.hasNext()) {
                out.writeSerializable((Serializable)iterator.next());
            }
            out.writeSerializable((Serializable)this.sdkKeyPair);
            out.writeInt(this.enableLogging ? 1 : 0);
            this.challengeParameters.writeToParcel(out, flags);
            out.writeInt(this.timeoutMins);
            this.intentData.writeToParcel(out, flags);
        }

        static {
            @Metadata(mv={1, 5, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Args> {
                @NotNull
                public final Args[] newArray(int size) {
                    return new Args[size];
                }

                @NotNull
                public final Args createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<Serializable> arrayList = new ArrayList<Serializable>(n);
                    StripeUiCustomization stripeUiCustomization = (StripeUiCustomization)parcel.readParcelable(Args.class.getClassLoader());
                    boolean bl = parcel.readInt() != 0;
                    String string = parcel.readString();
                    SdkTransactionId sdkTransactionId2 = (SdkTransactionId)SdkTransactionId.CREATOR.createFromParcel(parcel);
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(parcel.readSerializable());
                    }
                    IntentData intentData = (IntentData)IntentData.CREATOR.createFromParcel(parcel);
                    int n2 = parcel.readInt();
                    ChallengeParameters challengeParameters = (ChallengeParameters)ChallengeParameters.CREATOR.createFromParcel(parcel);
                    boolean bl2 = parcel.readInt() != 0;
                    KeyPair keyPair = (KeyPair)parcel.readSerializable();
                    List list = arrayList;
                    StripeUiCustomization stripeUiCustomization2 = stripeUiCustomization;
                    boolean bl3 = bl;
                    String string2 = string;
                    SdkTransactionId sdkTransactionId3 = sdkTransactionId2;
                    return new Args(sdkTransactionId3, string2, bl3, stripeUiCustomization2, list, keyPair, bl2, challengeParameters, n2, intentData);
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/TransactionContract$Args$Companion;", "", "()V", "EXTRA_ARGS", "", "fromIntent", "Lcom/stripe/android/stripe3ds2/transaction/TransactionContract$Args;", "intent", "Landroid/content/Intent;", "3ds2sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Args fromIntent(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return (Args)intent.getParcelableExtra(Args.EXTRA_ARGS);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

