package com.stripe.android.stripe3ds2.transaction

import androidx.annotation.Keep

// NOTE: Copied from reference app spec

/**
 * The ErrorMessage class shall represent an error message that is returned by
 * the ACS to the 3DS SDK or an error message that is generated by the 3DS SDK
 * to be returned to the ACS. For more information about error messages, refer
 * to Table A.4: Error Code, Error Description, and Error Detail and Table B.10:
 * Error Message Data Elements in the EMV 3DS Protocol Specification.
 */
@Keep
data class ErrorMessage(

    /**
     * The Transaction ID.
     * The EMV 3DS Protocol Specification defines the Transaction ID.
     */
    val transactionId: String,

    /**
     * The error code.
     */
    val errorCode: String,

    /**
     * Text describing the error.
     * The EMV 3DS Protocol Specification defines error descriptions for a transaction.
     */
    val errorDescription: String,

    /**
     * Error details.
     * The EMV 3DS Protocol Specification defines error details for a transaction.
     */
    val errorDetails: String
)
