/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertChainUtils;
import com.nimbusds.jose.util.X509CertUtils;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u000bJ&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH&\u00a8\u0006\f"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/JwsValidator;", "", "getPayload", "Lorg/json/JSONObject;", "jws", "", "isLiveMode", "", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "Default", "3ds2sdk_release"})
public interface JwsValidator {
    @NotNull
    public JSONObject getPayload(@NotNull String var1, boolean var2, @NotNull List<? extends X509Certificate> var3);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/JwsValidator$Default;", "Lcom/stripe/android/stripe3ds2/transaction/JwsValidator;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "getPayload", "Lorg/json/JSONObject;", "jws", "", "isLiveMode", "", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "getPublicKeyFromHeader", "Ljava/security/PublicKey;", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "getVerifier", "Lcom/nimbusds/jose/JWSVerifier;", "isCertificateChainValid", "encodedChainCerts", "Lcom/nimbusds/jose/util/Base64;", "isValid", "jwsObject", "Lcom/nimbusds/jose/JWSObject;", "Companion", "3ds2sdk_release"})
    public static final class Default
    implements JwsValidator {
        private final ErrorReporter errorReporter;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public JSONObject getPayload(@NotNull String jws, boolean isLiveMode, @NotNull List<? extends X509Certificate> rootCerts) throws JSONException, ParseException, JOSEException, CertificateException {
            block3: {
                JWSObject jwsObject;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)jws, (String)"jws");
                    Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
                    jwsObject = JWSObject.parse((String)jws);
                    if (!isLiveMode) break block2;
                    JWSObject jWSObject = jwsObject;
                    Intrinsics.checkNotNullExpressionValue((Object)jWSObject, (String)"jwsObject");
                    if (!this.isValid(jWSObject, rootCerts)) break block3;
                }
                JWSObject jWSObject = jwsObject;
                Intrinsics.checkNotNullExpressionValue((Object)jWSObject, (String)"jwsObject");
                return new JSONObject(jWSObject.getPayload().toString());
            }
            throw (Throwable)new IllegalStateException("Could not validate JWS");
        }

        private final boolean isValid(JWSObject jwsObject, List<? extends X509Certificate> rootCerts) throws JOSEException, CertificateException {
            JWSHeader jWSHeader = jwsObject.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)jWSHeader, (String)"jwsObject.header");
            if (jWSHeader.getJWK() != null) {
                this.errorReporter.reportError(new IllegalArgumentException("Encountered a JWK in " + jwsObject.getHeader()));
            }
            JWSHeader jWSHeader2 = jwsObject.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)jWSHeader2, (String)"jwsObject.header");
            JWSHeader jwsHeader = Companion.sanitizedJwsHeader$3ds2sdk_release(jWSHeader2);
            if (!this.isCertificateChainValid(jwsHeader.getX509CertChain(), rootCerts)) {
                return false;
            }
            JWSVerifier verifier = this.getVerifier(jwsHeader);
            return jwsObject.verify(verifier);
        }

        private final JWSVerifier getVerifier(JWSHeader jwsHeader) throws JOSEException, CertificateException {
            DefaultJWSVerifierFactory verifierFactory = new DefaultJWSVerifierFactory();
            JCAContext jCAContext = verifierFactory.getJCAContext();
            Intrinsics.checkNotNullExpressionValue((Object)jCAContext, (String)"verifierFactory.jcaContext");
            jCAContext.setProvider((Provider)BouncyCastleProviderSingleton.getInstance());
            JWSVerifier jWSVerifier = verifierFactory.createJWSVerifier(jwsHeader, (Key)this.getPublicKeyFromHeader(jwsHeader));
            Intrinsics.checkNotNullExpressionValue((Object)jWSVerifier, (String)"verifierFactory.createJW\u2026KeyFromHeader(jwsHeader))");
            return jWSVerifier;
        }

        private final PublicKey getPublicKeyFromHeader(JWSHeader jwsHeader) throws CertificateException {
            List list = jwsHeader.getX509CertChain();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jwsHeader.x509CertChain");
            X509Certificate x509Certificate = X509CertUtils.parseWithException((byte[])((Base64)CollectionsKt.first((List)list)).decode());
            Intrinsics.checkNotNullExpressionValue((Object)x509Certificate, (String)"X509CertUtils.parseWithE\u2026().decode()\n            )");
            PublicKey publicKey = x509Certificate.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"X509CertUtils.parseWithE\u2026)\n            ).publicKey");
            return publicKey;
        }

        @VisibleForTesting
        public final boolean isCertificateChainValid(@Nullable List<? extends Base64> encodedChainCerts, @NotNull List<? extends X509Certificate> rootCerts) {
            Default default_;
            block4: {
                boolean bl;
                boolean bl2;
                Object object;
                Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
                default_ = this;
                boolean bl3 = false;
                try {
                    object = Result.Companion;
                    Default $this$runCatching = default_;
                    boolean bl4 = false;
                    Collection collection = encodedChainCerts;
                    bl2 = false;
                    boolean bl5 = false;
                    boolean bl6 = !(collection == null || collection.isEmpty());
                    bl2 = false;
                    bl5 = false;
                    if (!bl6) {
                        boolean bl7 = false;
                        String string2 = "JWSHeader's X.509 certificate chain is null or empty";
                        throw (Throwable)new IllegalArgumentException(string2.toString());
                    }
                    Collection collection2 = rootCerts;
                    bl2 = false;
                    bl = !collection2.isEmpty();
                    bl2 = false;
                    bl5 = false;
                    if (!bl) {
                        boolean bl8 = false;
                        String string3 = "Root certificates are empty";
                        throw (Throwable)new IllegalArgumentException(string3.toString());
                    }
                    Default.Companion.validateChain(encodedChainCerts, rootCerts);
                    Unit unit = Unit.INSTANCE;
                    boolean bl9 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    bl = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                default_ = object;
                bl3 = false;
                boolean bl10 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)default_);
                if (throwable == null) break block4;
                Throwable throwable2 = throwable;
                boolean bl11 = false;
                boolean bl12 = false;
                Throwable throwable3 = throwable2;
                bl2 = false;
                Throwable it = throwable3;
                boolean bl13 = false;
                this.errorReporter.reportError(it);
            }
            return Result.isSuccess-impl((Object)default_);
        }

        public Default(@NotNull ErrorReporter errorReporter2) {
            Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
            this.errorReporter = errorReporter2;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000bJ$\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/JwsValidator$Default$Companion;", "", "()V", "createKeyStore", "Ljava/security/KeyStore;", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "sanitizedJwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "jwsHeader", "sanitizedJwsHeader$3ds2sdk_release", "validateChain", "", "encodedChainCerts", "Lcom/nimbusds/jose/util/Base64;", "3ds2sdk_release"})
        public static final class Companion {
            private final void validateChain(List<? extends Base64> encodedChainCerts, List<? extends X509Certificate> rootCerts) throws GeneralSecurityException, IOException, ParseException {
                List chainCerts = X509CertChainUtils.parse(encodedChainCerts);
                KeyStore keyStore = this.createKeyStore(rootCerts);
                X509CertSelector target = new X509CertSelector();
                target.setCertificate((X509Certificate)chainCerts.get(0));
                PKIXBuilderParameters params = new PKIXBuilderParameters(keyStore, (CertSelector)target);
                params.setRevocationEnabled(false);
                params.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(chainCerts)));
                CertPathBuilder.getInstance("PKIX").build(params);
            }

            @VisibleForTesting
            @NotNull
            public final KeyStore createKeyStore(@NotNull List<? extends X509Certificate> rootCerts) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
                Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                Iterable $this$forEachIndexed$iv = rootCerts;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    X509Certificate x509Certificate = (X509Certificate)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    Locale locale = Locale.ROOT;
                    String string2 = "ca_%d";
                    Object[] objectArray = new Object[]{index};
                    boolean bl3 = false;
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                    keyStore.setCertificateEntry(string3, rootCerts.get(index));
                }
                KeyStore keyStore2 = keyStore;
                Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"keyStore");
                return keyStore2;
            }

            @NotNull
            public final JWSHeader sanitizedJwsHeader$3ds2sdk_release(@NotNull JWSHeader jwsHeader) {
                Intrinsics.checkNotNullParameter((Object)jwsHeader, (String)"jwsHeader");
                JWSHeader jWSHeader = new JWSHeader.Builder(jwsHeader).jwk(null).build();
                Intrinsics.checkNotNullExpressionValue((Object)jWSHeader, (String)"JWSHeader.Builder(jwsHea\u2026                 .build()");
                return jWSHeader;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

