package com.stripe.android.stripe3ds2.transaction

import android.app.Activity
import android.content.Intent
import androidx.annotation.Keep
import androidx.fragment.app.Fragment

/**
 * A representation of an object (i.e. Activity or Fragment) that can start an activity.
 */
@Keep
class Stripe3ds2ActivityStarterHost private constructor(
    internal val activity: Activity,
    private val fragment: Fragment?
) {
    constructor(fragment: Fragment) : this(
        activity = fragment.requireActivity(),
        fragment = fragment
    )

    constructor(activity: Activity) : this(
        activity = activity,
        fragment = null
    )

    internal fun startActivity(intent: Intent) {
        when {
            fragment != null -> {
                if (fragment.isAdded) {
                    fragment.startActivity(intent)
                }
            }
            else -> {
                activity.startActivity(intent)
            }
        }
    }
}
