/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.MessageTransformer;
import com.stripe.android.stripe3ds2.security.TransactionEncrypter;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseParseException;
import com.stripe.android.stripe3ds2.transactions.ProtocolError;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0080\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\t\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c2\u0003J'\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001d\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0017J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!J\u001d\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b#J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u000fH\u00d6\u0001J\u0015\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b*R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/stripe/android/stripe3ds2/security/MessageTransformerImpl;", "Lcom/stripe/android/stripe3ds2/security/MessageTransformer;", "isLiveMode", "", "counterSdkToAcs", "", "counterAcsToSdk", "(ZBB)V", "component1", "component2", "component3", "copy", "createEncryptionHeader", "Lcom/nimbusds/jose/JWEHeader;", "keyId", "", "createEncryptionHeader$3ds2sdk_release", "decrypt", "Lorg/json/JSONObject;", "message", "secretKey", "Ljavax/crypto/SecretKey;", "decryptMessage", "decryptMessage$3ds2sdk_release", "encrypt", "challengeRequest", "equals", "other", "", "getDecryptionKey", "", "encryptionMethod", "Lcom/nimbusds/jose/EncryptionMethod;", "getDecryptionKey$3ds2sdk_release", "getEncryptionKey", "getEncryptionKey$3ds2sdk_release", "hashCode", "", "toString", "validateAcsToSdkCounter", "", "cres", "validateAcsToSdkCounter$3ds2sdk_release", "Companion", "3ds2sdk_release"})
public final class MessageTransformerImpl
implements MessageTransformer {
    private final boolean isLiveMode;
    private byte counterSdkToAcs;
    private byte counterAcsToSdk;
    @NotNull
    public static final String FIELD_ACS_COUNTER_ACS_TO_SDK = "acsCounterAtoS";
    @NotNull
    public static final String FIELD_SDK_COUNTER_SDK_TO_ACS = "sdkCounterStoA";
    private static final EncryptionMethod ENCRYPTION_METHOD;
    public static final int BITS_IN_BYTE = 8;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String encrypt(@NotNull JSONObject challengeRequest, @NotNull SecretKey secretKey) throws JOSEException, JSONException {
        Intrinsics.checkNotNullParameter((Object)challengeRequest, (String)"challengeRequest");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        String string2 = challengeRequest.getString("acsTransID");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"challengeRequest.getStri\u2026tData.FIELD_ACS_TRANS_ID)");
        JWEHeader header = this.createEncryptionHeader$3ds2sdk_release(string2);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.ROOT;
        String string3 = "%03d";
        Object[] objectArray = new Object[]{this.counterSdkToAcs};
        boolean bl = false;
        String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
        challengeRequest.put(FIELD_SDK_COUNTER_SDK_TO_ACS, (Object)string4);
        JWEObject jweObject = new JWEObject(header, new Payload(challengeRequest.toString()));
        EncryptionMethod encryptionMethod = header.getEncryptionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)encryptionMethod, (String)"header.encryptionMethod");
        jweObject.encrypt((JWEEncrypter)new TransactionEncrypter(this.getEncryptionKey$3ds2sdk_release(secretKey, encryptionMethod), this.counterSdkToAcs));
        byte by = this.counterSdkToAcs;
        this.counterSdkToAcs = (byte)(by + 1);
        if (this.counterSdkToAcs == 0) {
            throw (Throwable)new RuntimeException("SDK to ACS counter is zero");
        }
        String string5 = jweObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jweObject.serialize()");
        return string5;
    }

    @Override
    @NotNull
    public JSONObject decrypt(@NotNull String message, @NotNull SecretKey secretKey) throws ParseException, JOSEException, JSONException, ChallengeResponseParseException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        JSONObject challengeResponse = this.decryptMessage$3ds2sdk_release(message, secretKey);
        this.validateAcsToSdkCounter$3ds2sdk_release(challengeResponse);
        byte by = this.counterAcsToSdk;
        this.counterAcsToSdk = (byte)(by + 1);
        if (this.counterAcsToSdk == 0) {
            throw (Throwable)new RuntimeException("ACS to SDK counter is zero");
        }
        return challengeResponse;
    }

    @VisibleForTesting
    public final void validateAcsToSdkCounter$3ds2sdk_release(@NotNull JSONObject cres) throws ChallengeResponseParseException, JSONException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)cres, (String)"cres");
        if (!this.isLiveMode) {
            return;
        }
        if (!cres.has(FIELD_ACS_COUNTER_ACS_TO_SDK)) {
            throw (Throwable)ChallengeResponseParseException.Companion.createRequiredDataElementMissing(FIELD_ACS_COUNTER_ACS_TO_SDK);
        }
        MessageTransformerImpl messageTransformerImpl = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Serializable $this$runCatching = messageTransformerImpl;
            boolean bl2 = false;
            String string2 = cres.getString(FIELD_ACS_COUNTER_ACS_TO_SDK);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cres.getString(FIELD_ACS_COUNTER_ACS_TO_SDK)");
            String string3 = string2;
            boolean bl3 = false;
            $this$runCatching = Byte.valueOf(Byte.parseByte(string3));
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        messageTransformerImpl = object;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)messageTransformerImpl);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl6 = false;
            throw (Throwable)ChallengeResponseParseException.Companion.createInvalidDataElementFormat(FIELD_ACS_COUNTER_ACS_TO_SDK);
        }
        byte acsCounterAcsToSdk = ((Number)((Object)messageTransformerImpl)).byteValue();
        if (this.counterAcsToSdk != acsCounterAcsToSdk) {
            throw (Throwable)new ChallengeResponseParseException(ProtocolError.DataDecryptionFailure, "Counters are not equal. SDK counter: " + this.counterAcsToSdk + ", ACS counter: " + acsCounterAcsToSdk);
        }
    }

    @VisibleForTesting
    @NotNull
    public final JSONObject decryptMessage$3ds2sdk_release(@NotNull String message, @NotNull SecretKey secretKey) throws ParseException, JOSEException, JSONException {
        JWEObject jweObject;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        JWEObject jWEObject = jweObject = JWEObject.parse((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)jWEObject, (String)"jweObject");
        JWEHeader jWEHeader = jWEObject.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jWEHeader, (String)"jweObject.header");
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)encryptionMethod, (String)"jweObject.header.encryptionMethod");
        byte[] key = this.getDecryptionKey$3ds2sdk_release(secretKey, encryptionMethod);
        jweObject.decrypt((JWEDecrypter)new DirectDecrypter(key));
        return new JSONObject(jweObject.getPayload().toString());
    }

    @VisibleForTesting
    @NotNull
    public final JWEHeader createEncryptionHeader$3ds2sdk_release(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        JWEHeader jWEHeader = new JWEHeader.Builder(JWEAlgorithm.DIR, ENCRYPTION_METHOD).keyID(keyId).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWEHeader, (String)"JWEHeader.Builder(JWEAlg\u2026yId)\n            .build()");
        return jWEHeader;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] getDecryptionKey$3ds2sdk_release(@NotNull SecretKey secretKey, @NotNull EncryptionMethod encryptionMethod) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        byte[] encodedKey = secretKey.getEncoded();
        if (EncryptionMethod.A128GCM == encryptionMethod) {
            byte[] byArray2 = Arrays.copyOfRange(encodedKey, encodedKey.length - EncryptionMethod.A128GCM.cekBitLength() / 8, encodedKey.length);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Arrays.copyOfRange(\n    \u2026dedKey.size\n            )");
        } else {
            byArray = encodedKey;
            Intrinsics.checkNotNullExpressionValue((Object)encodedKey, (String)"encodedKey");
        }
        return byArray;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] getEncryptionKey$3ds2sdk_release(@NotNull SecretKey secretKey, @NotNull EncryptionMethod encryptionMethod) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        byte[] encodedKey = secretKey.getEncoded();
        if (EncryptionMethod.A128GCM == encryptionMethod) {
            byte[] byArray2 = Arrays.copyOfRange(encodedKey, 0, EncryptionMethod.A128GCM.cekBitLength() / 8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Arrays.copyOfRange(\n    \u2026ITS_IN_BYTE\n            )");
        } else {
            byArray = encodedKey;
            Intrinsics.checkNotNullExpressionValue((Object)encodedKey, (String)"encodedKey");
        }
        return byArray;
    }

    @VisibleForTesting
    public MessageTransformerImpl(boolean isLiveMode, byte counterSdkToAcs, byte counterAcsToSdk) {
        this.isLiveMode = isLiveMode;
        this.counterSdkToAcs = counterSdkToAcs;
        this.counterAcsToSdk = counterAcsToSdk;
    }

    static {
        Companion = new Companion(null);
        ENCRYPTION_METHOD = EncryptionMethod.A128CBC_HS256;
    }

    private final boolean component1() {
        return this.isLiveMode;
    }

    private final byte component2() {
        return this.counterSdkToAcs;
    }

    private final byte component3() {
        return this.counterAcsToSdk;
    }

    @NotNull
    public final MessageTransformerImpl copy(boolean isLiveMode, byte counterSdkToAcs, byte counterAcsToSdk) {
        return new MessageTransformerImpl(isLiveMode, counterSdkToAcs, counterAcsToSdk);
    }

    public static /* synthetic */ MessageTransformerImpl copy$default(MessageTransformerImpl messageTransformerImpl, boolean bl, byte by, byte by2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = messageTransformerImpl.isLiveMode;
        }
        if ((n & 2) != 0) {
            by = messageTransformerImpl.counterSdkToAcs;
        }
        if ((n & 4) != 0) {
            by2 = messageTransformerImpl.counterAcsToSdk;
        }
        return messageTransformerImpl.copy(bl, by, by2);
    }

    @NotNull
    public String toString() {
        return "MessageTransformerImpl(isLiveMode=" + this.isLiveMode + ", counterSdkToAcs=" + this.counterSdkToAcs + ", counterAcsToSdk=" + this.counterAcsToSdk + ")";
    }

    public int hashCode() {
        int n = this.isLiveMode ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        return (n * 31 + Byte.hashCode(this.counterSdkToAcs)) * 31 + Byte.hashCode(this.counterAcsToSdk);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MessageTransformerImpl)) break block3;
                MessageTransformerImpl messageTransformerImpl = (MessageTransformerImpl)object;
                if (this.isLiveMode != messageTransformerImpl.isLiveMode || this.counterSdkToAcs != messageTransformerImpl.counterSdkToAcs || this.counterAcsToSdk != messageTransformerImpl.counterAcsToSdk) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final MessageTransformerImpl create(boolean isLiveMode, @NotNull ErrorReporter errorReporter2) {
        return Companion.create(isLiveMode, errorReporter2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/stripe3ds2/security/MessageTransformerImpl$Companion;", "", "()V", "BITS_IN_BYTE", "", "ENCRYPTION_METHOD", "Lcom/nimbusds/jose/EncryptionMethod;", "kotlin.jvm.PlatformType", "FIELD_ACS_COUNTER_ACS_TO_SDK", "", "FIELD_SDK_COUNTER_SDK_TO_ACS", "create", "Lcom/stripe/android/stripe3ds2/security/MessageTransformerImpl;", "isLiveMode", "", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "3ds2sdk_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MessageTransformerImpl create(boolean isLiveMode, @NotNull ErrorReporter errorReporter2) {
            Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
            return new MessageTransformerImpl(isLiveMode, (byte)0, (byte)0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

