/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.BaseCustomization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.stripe3ds2.utils.ObjectUtils;

public final class StripeToolbarCustomization
extends BaseCustomization
implements ToolbarCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeToolbarCustomization> CREATOR = new Parcelable.Creator<StripeToolbarCustomization>(){

        public StripeToolbarCustomization createFromParcel(Parcel in) {
            return new StripeToolbarCustomization(in);
        }

        public StripeToolbarCustomization[] newArray(int size) {
            return new StripeToolbarCustomization[size];
        }
    };
    @Nullable
    private String mBackgroundColor;
    @Nullable
    private String mStatusBarColor;
    @Nullable
    private String mHeaderText;
    @Nullable
    private String mButtonText;

    public StripeToolbarCustomization() {
    }

    private StripeToolbarCustomization(@NonNull Parcel in) {
        super(in);
        this.mBackgroundColor = in.readString();
        this.mStatusBarColor = in.readString();
        this.mHeaderText = in.readString();
        this.mButtonText = in.readString();
    }

    @Override
    public void setBackgroundColor(@NonNull String hexColorCode) throws InvalidInputException {
        this.mBackgroundColor = CustomizeUtils.requireValidColor(hexColorCode);
    }

    @Override
    public void setStatusBarColor(@NonNull String statusBarColor) throws InvalidInputException {
        this.mStatusBarColor = CustomizeUtils.requireValidColor(statusBarColor);
    }

    @Override
    public void setHeaderText(@NonNull String headerText) throws InvalidInputException {
        this.mHeaderText = CustomizeUtils.requireValidString(headerText);
    }

    @Override
    public void setButtonText(@NonNull String buttonText) throws InvalidInputException {
        this.mButtonText = CustomizeUtils.requireValidString(buttonText);
    }

    @Override
    @Nullable
    public String getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    @Nullable
    public String getHeaderText() {
        return this.mHeaderText;
    }

    @Override
    @Nullable
    public String getButtonText() {
        return this.mButtonText;
    }

    @Override
    @Nullable
    public String getStatusBarColor() {
        return this.mStatusBarColor;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeToolbarCustomization && this.typedEquals((StripeToolbarCustomization)obj);
    }

    private boolean typedEquals(@NonNull StripeToolbarCustomization toolbarCustomization) {
        return ObjectUtils.equals(this.mBackgroundColor, toolbarCustomization.mBackgroundColor) && ObjectUtils.equals(this.mStatusBarColor, toolbarCustomization.mStatusBarColor) && ObjectUtils.equals(this.mHeaderText, toolbarCustomization.mHeaderText) && ObjectUtils.equals(this.mButtonText, toolbarCustomization.mButtonText);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mBackgroundColor, this.mStatusBarColor, this.mHeaderText, this.mButtonText);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mBackgroundColor);
        dest.writeString(this.mStatusBarColor);
        dest.writeString(this.mHeaderText);
        dest.writeString(this.mButtonText);
    }
}

