/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init;

import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "", "warning", "Lcom/stripe/android/stripe3ds2/init/Warning;", "(Lcom/stripe/android/stripe3ds2/init/Warning;)V", "getWarning", "()Lcom/stripe/android/stripe3ds2/init/Warning;", "check", "", "DebuggerAttached", "Emulator", "RootedCheck", "Tampered", "UnsupportedOS", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS;", "3ds2sdk_release"})
public abstract class SecurityCheck {
    @NotNull
    private final Warning warning;

    public abstract boolean check();

    @NotNull
    public final Warning getWarning() {
        return this.warning;
    }

    private SecurityCheck(Warning warning) {
        this.warning = warning;
    }

    public /* synthetic */ SecurityCheck(Warning warning, DefaultConstructorMarker $constructor_marker) {
        this(warning);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "check", "", "findSuBinary", "findSuperuserApk", "Companion", "3ds2sdk_release"})
    public static final class RootedCheck
    extends SecurityCheck {
        private static final List<String> BINARY_PATHS;
        private static final Warning WARNING;
        @NotNull
        private static final Companion Companion;

        @Override
        public boolean check() {
            return this.findSuBinary() || this.findSuperuserApk();
        }

        private final boolean findSuBinary() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = BINARY_PATHS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!new File(it + "su").exists()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean findSuperuserApk() {
            return new File(Environment.getRootDirectory().toString() + "/Superuser").isDirectory();
        }

        public RootedCheck() {
            super(WARNING, null);
        }

        static {
            Companion = new Companion(null);
            BINARY_PATHS = CollectionsKt.listOf((Object[])new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"});
            WARNING = new Warning("SW01", "The device is jailbroken.", Warning.Severity.HIGH);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck$Companion;", "", "()V", "BINARY_PATHS", "", "", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "check", "", "hasValidFields", "hasValidMethods", "Companion", "3ds2sdk_release"})
    public static final class Tampered
    extends SecurityCheck {
        private static final Warning WARNING;
        @NotNull
        private static final Companion Companion;

        @Override
        public boolean check() {
            return !this.hasValidFields() || !this.hasValidMethods();
        }

        private final boolean hasValidFields() {
            Field[] serviceImplFields = StripeThreeDs2ServiceImpl.class.getDeclaredFields();
            return serviceImplFields.length == 12;
        }

        private final boolean hasValidMethods() {
            Method[] serviceImplMethods = StripeThreeDs2ServiceImpl.class.getDeclaredMethods();
            return serviceImplMethods.length == 13;
        }

        public Tampered() {
            super(WARNING, null);
        }

        static {
            Companion = new Companion(null);
            WARNING = new Warning("SW02", "The integrity of the SDK has been tampered.", Warning.Severity.HIGH);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "isEmulator", "", "()Z", "check", "Companion", "3ds2sdk_release"})
    public static final class Emulator
    extends SecurityCheck {
        private static final Warning WARNING;
        @NotNull
        private static final Companion Companion;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmulator() {
            String string2 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Build.FINGERPRINT");
            if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) return true;
            String string3 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Build.FINGERPRINT");
            if (StringsKt.startsWith$default((String)string3, (String)"unknown", (boolean)false, (int)2, null)) return true;
            String string4 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Build.MODEL");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
            String string5 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Build.MODEL");
            if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
            String string6 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"Build.MODEL");
            if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
            String string7 = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"Build.MANUFACTURER");
            if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
            String string8 = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"Build.BRAND");
            if (StringsKt.startsWith$default((String)string8, (String)"generic", (boolean)false, (int)2, null)) {
                String string9 = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"Build.DEVICE");
                if (StringsKt.startsWith$default((String)string9, (String)"generic", (boolean)false, (int)2, null)) return true;
            }
            if (!Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) return false;
            return true;
        }

        @Override
        public boolean check() {
            return this.isEmulator();
        }

        public Emulator() {
            super(WARNING, null);
        }

        static {
            Companion = new Companion(null);
            WARNING = new Warning("SW02", "An emulator is being used to run the App.", Warning.Severity.HIGH);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "isDebuggerConnected", "", "(Z)V", "()Z", "check", "Companion", "3ds2sdk_release"})
    public static final class DebuggerAttached
    extends SecurityCheck {
        private final boolean isDebuggerConnected;
        private static final Warning WARNING;
        @NotNull
        private static final Companion Companion;

        @Override
        public boolean check() {
            return this.isDebuggerConnected;
        }

        public final boolean isDebuggerConnected() {
            return this.isDebuggerConnected;
        }

        public DebuggerAttached(boolean isDebuggerConnected) {
            super(WARNING, null);
            this.isDebuggerConnected = isDebuggerConnected;
        }

        public /* synthetic */ DebuggerAttached(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = Debug.isDebuggerConnected();
            }
            this(bl);
        }

        public DebuggerAttached() {
            this(false, 1, null);
        }

        static {
            Companion = new Companion(null);
            WARNING = new Warning("SW04", "A debugger is attached to the App.", Warning.Severity.MEDIUM);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "check", "", "Companion", "3ds2sdk_release"})
    public static final class UnsupportedOS
    extends SecurityCheck {
        private static final Warning WARNING;
        @NotNull
        private static final Companion Companion;

        @Override
        public boolean check() {
            return false;
        }

        public UnsupportedOS() {
            super(WARNING, null);
        }

        static {
            Companion = new Companion(null);
            WARNING = new Warning("SW05", "The OS or the OS version is not supported.", Warning.Severity.HIGH);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

