package com.stripe.android.stripe3ds2.transaction

import com.stripe.android.stripe3ds2.utils.ImageCache

open class StripeChallengeStatusReceiver internal constructor(
    private val imageCache: ImageCache,
    private val logger: Logger = Logger.noop()
) : ChallengeStatusReceiver {

    constructor() : this(
        ImageCache.Default
    )

    override fun completed(
        completionEvent: CompletionEvent,
        uiTypeCode: String,
        onReceiverCompleted: () -> Unit
    ) {
        logger.info("StripeChallengeStatusReceiver#completed()")
        statusReceived()
    }

    override fun cancelled(
        uiTypeCode: String,
        onReceiverCompleted: () -> Unit
    ) {
        logger.info("StripeChallengeStatusReceiver#cancelled()")
        statusReceived()
    }

    override fun timedout(
        uiTypeCode: String,
        onReceiverCompleted: () -> Unit
    ) {
        logger.info("StripeChallengeStatusReceiver#timedout()")
        statusReceived()
    }

    override fun protocolError(
        protocolErrorEvent: ProtocolErrorEvent,
        onReceiverCompleted: () -> Unit
    ) {
        logger.info("StripeChallengeStatusReceiver#protocolError()")
        statusReceived()
    }

    override fun runtimeError(
        runtimeErrorEvent: RuntimeErrorEvent,
        onReceiverCompleted: () -> Unit
    ) {
        logger.info("StripeChallengeStatusReceiver#runtimeError()")
        statusReceived()
    }

    private fun statusReceived() {
        imageCache.clear()
    }
}
