package com.stripe.android.stripe3ds2.transaction

import androidx.annotation.Keep

// NOTE: Copied from reference app spec

/**
 * The CompletionEvent class shall hold data about completion of the challenge process.
 */
@Keep
data class CompletionEvent(

    /**
     * The 3DS SDK transaction ID.
     * The EMV 3DS Protocol Specification defines this transaction ID.
     */
    val sdkTransactionId: SdkTransactionId,

    /**
     * The transaction status that was received by the 3DS SDK in the final CRes.
     */
    val transactionStatus: String
)
