package com.stripe.android.stripe3ds2.transaction

import android.content.Intent
import android.os.Bundle
import androidx.annotation.Keep

@Keep
interface ChallengeCompletionIntentStarter {
    fun start(intent: Intent, outcome: ChallengeFlowOutcome)
    class Default internal constructor(
        private val host: Stripe3ds2ActivityStarterHost,
        private val requestCode: Int = 0
    ) : ChallengeCompletionIntentStarter {
        override fun start(
            intent: Intent,
            outcome: ChallengeFlowOutcome
        ) {
            if (requestCode > 0) {
                host.startActivityForResult(
                    createIntent(
                        intent,
                        outcome,
                        isRequestingResult = true
                    ),
                    requestCode
                )
            } else {
                host.startActivity(createIntent(intent, outcome))
            }
        }

        internal fun createIntent(
            intent: Intent,
            outcome: ChallengeFlowOutcome,
            isRequestingResult: Boolean = false
        ): Intent {
            return Intent()
                .setComponent(intent.component)
                .putExtras(intent.extras ?: Bundle())
                .putExtra(EXTRA_OUTCOME, outcome.ordinal)
                .also {
                    if (!isRequestingResult) {
                        it.addFlags(Intent.FLAG_ACTIVITY_FORWARD_RESULT)
                    }
                }
        }
    }

    @Keep
    companion object {
        const val EXTRA_OUTCOME = "extra_outcome"
    }
}
