package com.stripe.android.stripe3ds2.service

import android.content.Intent
import com.stripe.android.stripe3ds2.transaction.Transaction
import java.security.PublicKey
import java.security.cert.X509Certificate

/**
 * An extension of [ThreeDS2Service] that defines Stripe-specific methods.
 */
interface StripeThreeDs2Service : ThreeDS2Service {
    fun createTransaction(
        directoryServerID: String,
        messageVersion: String?,
        isLiveMode: Boolean,
        directoryServerName: String
    ): Transaction

    /**
     * @param challengeCompletionIntent an `Intent` to start when the challenge flow is completed
     * for any reason.
     * @param challengeCompletionRequestCode a request code to use when starting an `Activity` for
     * result.
     */
    fun createTransaction(
        directoryServerID: String,
        messageVersion: String?,
        isLiveMode: Boolean,
        directoryServerName: String,
        rootCerts: List<X509Certificate>,
        dsPublicKey: PublicKey,
        keyId: String?,
        challengeCompletionIntent: Intent?,
        challengeCompletionRequestCode: Int
    ): Transaction
}
