/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.widget.ProgressBar;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AppCompatActivity;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u0000B\t\b\u0002\u00a2\u0006\u0004\b,\u0010-J!\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0014\u001a\u00020\u000b2\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u0018\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0019H\u0001\u00a2\u0006\u0004\b\u0016\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b \u0010\u0017J\u0017\u0010\"\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\"\u0010\u0017J\u0017\u0010$\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b$\u0010\u001eJ\u001f\u0010(\u001a\u00020\u00052\u0006\u0010&\u001a\u00020%2\b\b\u0001\u0010'\u001a\u00020\u0012\u00a2\u0006\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\u00198\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/stripe/android/stripe3ds2/utils/CustomizeUtils;", "Landroid/widget/ProgressBar;", "progressBar", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "uiCustomization", "", "applyProgressBarColor$3ds2sdk_release", "(Landroid/widget/ProgressBar;Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;)V", "applyProgressBarColor", "Landroid/content/Context;", "context", "", "text", "Lcom/stripe/android/stripe3ds2/init/ui/Customization;", "customization", "Landroid/text/SpannableString;", "buildStyledText", "(Landroid/content/Context;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/init/ui/Customization;)Landroid/text/SpannableString;", "", "color", "colorIntToHex", "(I)Ljava/lang/String;", "darken$3ds2sdk_release", "(I)I", "darken", "", "factor", "(IF)I", "hexColor", "requireValidColor", "(Ljava/lang/String;)Ljava/lang/String;", "dimension", "requireValidDimension", "fontSize", "requireValidFontSize", "string", "requireValidString", "Landroidx/appcompat/app/AppCompatActivity;", "activity", "statusBarColor", "setStatusBarColor", "(Landroidx/appcompat/app/AppCompatActivity;I)V", "DEFAULT_DARKEN_FACTOR", "F", "<init>", "()V", "3ds2sdk_release"}, xs="", pn="", xi=0)
public final class CustomizeUtils {
    public static final CustomizeUtils INSTANCE = new CustomizeUtils();

    @JvmStatic
    @NotNull
    public static final String colorIntToHex(@ColorInt int n2) {
        int n3 = n2;
        n2 = Color.alpha((int)n3);
        int n4 = Color.blue((int)n3);
        int n5 = Color.green((int)n3);
        int n6 = Color.red((int)n3);
        StringBuilder stringBuilder = new StringBuilder().append("#");
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        String string2 = String.format(locale, "%02X", Arrays.copyOf(new Object[]{n2}, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        Locale locale2 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.ENGLISH");
        String string3 = String.format(locale2, "%02X", Arrays.copyOf(new Object[]{n6}, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        Locale locale3 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.ENGLISH");
        String string4 = String.format(locale3, "%02X", Arrays.copyOf(new Object[]{n5}, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string4);
        Locale locale4 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.ENGLISH");
        String string5 = String.format(locale4, "%02X", Arrays.copyOf(new Object[]{n4}, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(locale, format, *args)");
        return stringBuilder4.append(string5).toString();
    }

    @JvmStatic
    @NotNull
    public static final String requireValidColor(@NotNull String string2) throws InvalidInputException {
        Object object;
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"hexColor");
        Color.parseColor((String)string3);
        try {
            object = Result.constructor-impl((Object)string3);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (Result.exceptionOrNull-impl((Object)object) == null) {
            return (String)object;
        }
        throw new InvalidInputException(new RuntimeException("Unable to parse color: " + string2));
    }

    @JvmStatic
    public static final int requireValidFontSize(int n2) throws InvalidInputException {
        RuntimeException runtimeException;
        if (n2 > 0) {
            return n2;
        }
        RuntimeException runtimeException2 = runtimeException;
        runtimeException = new RuntimeException("Font size must be greater than 0");
        throw new InvalidInputException(runtimeException2);
    }

    @JvmStatic
    public static final int requireValidDimension(int n2) throws InvalidInputException {
        RuntimeException runtimeException;
        if (n2 >= 0) {
            return n2;
        }
        RuntimeException runtimeException2 = runtimeException;
        runtimeException = new RuntimeException("Dimension must be greater or equal to 0");
        throw new InvalidInputException(runtimeException2);
    }

    @JvmStatic
    @NotNull
    public static final String requireValidString(@NotNull String object) throws InvalidInputException {
        RuntimeException runtimeException;
        String string2 = object;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
        if (!StringsKt.isBlank((CharSequence)string2)) {
            return object;
        }
        object = runtimeException;
        runtimeException = new RuntimeException("String must not be null or empty");
        throw new InvalidInputException((RuntimeException)object);
    }

    public final void applyProgressBarColor$3ds2sdk_release(@NotNull ProgressBar progressBar, @Nullable UiCustomization uiCustomization) {
        Intrinsics.checkParameterIsNotNull((Object)progressBar, (String)"progressBar");
        if (uiCustomization != null && (this = uiCustomization.getAccentColor()) != null) {
            int n2 = Color.parseColor((String)this);
            if (Build.VERSION.SDK_INT >= 21) {
                progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)n2));
            } else {
                uiCustomization = progressBar.getIndeterminateDrawable().mutate();
                Intrinsics.checkExpressionValueIsNotNull((Object)uiCustomization, (String)"progressBar.indeterminateDrawable.mutate()");
                if (Build.VERSION.SDK_INT >= 29) {
                    BlendModeColorFilter blendModeColorFilter;
                    BlendModeColorFilter blendModeColorFilter2 = blendModeColorFilter;
                    blendModeColorFilter = new BlendModeColorFilter(n2, BlendMode.SRC_IN);
                    uiCustomization.setColorFilter((ColorFilter)blendModeColorFilter2);
                } else {
                    uiCustomization.setColorFilter(n2, PorterDuff.Mode.SRC_IN);
                }
                progressBar.setIndeterminateDrawable((Drawable)uiCustomization);
            }
        }
    }

    public final void setStatusBarColor(@NotNull AppCompatActivity appCompatActivity, @ColorInt int n2) {
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = appCompatActivity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            window.setStatusBarColor(n2);
        }
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int n2, float f2) {
        int n3 = Color.alpha((int)n2);
        int n4 = n2;
        int n5 = (int)((float)Color.red((int)n4) * f2);
        n2 = (int)((float)Color.green((int)n4) * f2);
        n5 = Math.min(Math.max(n5, 0), 255);
        n2 = Math.min(Math.max(n2, 0), 255);
        int n6 = Math.min(Math.max((int)((float)Color.blue((int)n4) * f2), 0), 255);
        return Color.argb((int)n3, (int)n5, (int)n2, (int)n6);
    }

    @NotNull
    public final SpannableString buildStyledText(@NotNull Context object, @NotNull String string2, @NotNull Customization customization) {
        Integer n2;
        SpannableString spannableString;
        Customization customization2 = customization;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)customization2, (String)"customization");
        CustomizeUtils customizeUtils = spannableString;
        spannableString = new SpannableString((CharSequence)string2);
        string2 = customization2.getTextColor();
        if (string2 != null) {
            ForegroundColorSpan foregroundColorSpan;
            CustomizeUtils customizeUtils2 = customizeUtils;
            ForegroundColorSpan foregroundColorSpan2 = foregroundColorSpan;
            foregroundColorSpan = new ForegroundColorSpan(Color.parseColor((String)string2));
            int n3 = customizeUtils2.length();
            customizeUtils2.setSpan(foregroundColorSpan2, 0, n3, 0);
        }
        if (!((n2 = Integer.valueOf(customization.getTextFontSize())) > 0)) {
            n2 = null;
        }
        if (n2 != null) {
            AbsoluteSizeSpan absoluteSizeSpan;
            CustomizeUtils customizeUtils3 = customizeUtils;
            float f2 = ((Number)n2).intValue();
            Resources resources = object.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            n2 = resources.getDisplayMetrics();
            int n4 = (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)n2);
            n2 = absoluteSizeSpan;
            absoluteSizeSpan = new AbsoluteSizeSpan(n4);
            n4 = customizeUtils3.length();
            customizeUtils3.setSpan(n2, 0, n4, 0);
        }
        if ((object = customization.getTextFontName()) != null) {
            TypefaceSpan typefaceSpan;
            CustomizeUtils customizeUtils4 = customizeUtils;
            n2 = typefaceSpan;
            typefaceSpan = new TypefaceSpan((String)object);
            int n5 = customizeUtils4.length();
            customizeUtils4.setSpan(n2, 0, n5, 0);
        }
        return customizeUtils;
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int n2) {
        return this.darken$3ds2sdk_release(n2, 0.8f);
    }
}

