/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.fragment.app.FragmentActivity;
import com.stripe.android.stripe3ds2.R;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.stripe3ds2.views.ThreeDS2Button;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/stripe3ds2/views/HeaderZoneCustomizer;", "", "activity", "Landroidx/fragment/app/FragmentActivity;", "<init>", "(Landroidx/fragment/app/FragmentActivity;)V", "customize", "Lcom/stripe/android/stripe3ds2/views/ThreeDS2Button;", "toolbarCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/ToolbarCustomization;", "cancelButtonCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/ButtonCustomization;", "Companion", "3ds2sdk_release"})
public final class HeaderZoneCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FragmentActivity activity;

    public HeaderZoneCustomizer(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
    }

    @Nullable
    public final ThreeDS2Button customize(@Nullable ToolbarCustomization toolbarCustomization, @Nullable ButtonCustomization cancelButtonCustomization) {
        FragmentActivity fragmentActivity = this.activity;
        AppCompatActivity appCompatActivity = fragmentActivity instanceof AppCompatActivity ? (AppCompatActivity)fragmentActivity : null;
        AppCompatActivity appCompatActivity2 = appCompatActivity;
        if (appCompatActivity2 == null || (appCompatActivity2 = appCompatActivity2.getSupportActionBar()) == null) {
            return null;
        }
        AppCompatActivity actionBar = appCompatActivity2;
        ContextThemeWrapper buttonContext = new ContextThemeWrapper((Context)this.activity, R.style.Stripe3DS2ActionBarButton);
        ThreeDS2Button cancelButton = new ThreeDS2Button((Context)buttonContext, null, 0, 6, null);
        cancelButton.setBackgroundTintList(ColorStateList.valueOf((int)0));
        cancelButton.setButtonCustomization(cancelButtonCustomization);
        ActionBar.LayoutParams layoutParams = new ActionBar.LayoutParams(-2, -2, 8388629);
        actionBar.setCustomView((View)cancelButton, layoutParams);
        actionBar.setDisplayShowCustomEnabled(true);
        if (toolbarCustomization != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = toolbarCustomization.getButtonText();
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                cancelButton.setText(toolbarCustomization.getButtonText());
            } else {
                cancelButton.setText(R.string.stripe_3ds2_hzv_cancel_label);
            }
            String string2 = toolbarCustomization.getBackgroundColor();
            if (string2 != null) {
                String backgroundColor = string2;
                boolean bl = false;
                actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)backgroundColor)));
                Companion.customizeStatusBar(appCompatActivity, toolbarCustomization);
            }
            CharSequence charSequence3 = toolbarCustomization.getHeaderText();
            if (!(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3))) {
                charSequence3 = toolbarCustomization.getHeaderText();
                Intrinsics.checkNotNull((Object)charSequence3);
                charSequence = charSequence3;
            } else {
                charSequence3 = this.activity.getString(R.string.stripe_3ds2_hzv_header_label);
                Intrinsics.checkNotNull((Object)charSequence3);
                charSequence = charSequence3;
            }
            CharSequence headerText = charSequence;
            actionBar.setTitle((CharSequence)CustomizeUtils.INSTANCE.buildStyledText((Context)this.activity, (String)headerText, toolbarCustomization));
        } else {
            actionBar.setTitle(R.string.stripe_3ds2_hzv_header_label);
            cancelButton.setText(R.string.stripe_3ds2_hzv_cancel_label);
        }
        return cancelButton;
    }

    public static /* synthetic */ ThreeDS2Button customize$default(HeaderZoneCustomizer headerZoneCustomizer, ToolbarCustomization toolbarCustomization, ButtonCustomization buttonCustomization, int n, Object object) {
        if ((n & 1) != 0) {
            toolbarCustomization = null;
        }
        if ((n & 2) != 0) {
            buttonCustomization = null;
        }
        return headerZoneCustomizer.customize(toolbarCustomization, buttonCustomization);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/stripe3ds2/views/HeaderZoneCustomizer$Companion;", "", "<init>", "()V", "customizeStatusBar", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "toolbarCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/ToolbarCustomization;", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void customizeStatusBar(@NotNull AppCompatActivity activity, @NotNull ToolbarCustomization toolbarCustomization) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)toolbarCustomization, (String)"toolbarCustomization");
            if (toolbarCustomization.getStatusBarColor() != null) {
                CustomizeUtils.INSTANCE.setStatusBarColor(activity, Color.parseColor((String)toolbarCustomization.getStatusBarColor()));
            } else if (toolbarCustomization.getBackgroundColor() != null) {
                int backgroundColor = Color.parseColor((String)toolbarCustomization.getBackgroundColor());
                CustomizeUtils.INSTANCE.setStatusBarColor(activity, CustomizeUtils.INSTANCE.darken$3ds2sdk_release(backgroundColor));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

