/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.BaseCustomization;
import com.stripe.android.stripe3ds2.init.ui.LabelCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.stripe3ds2.utils.ObjectUtils;

public final class StripeLabelCustomization
extends BaseCustomization
implements LabelCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeLabelCustomization> CREATOR = new Parcelable.Creator<StripeLabelCustomization>(){

        public StripeLabelCustomization createFromParcel(Parcel in) {
            return new StripeLabelCustomization(in);
        }

        public StripeLabelCustomization[] newArray(int size) {
            return new StripeLabelCustomization[size];
        }
    };
    @Nullable
    private String mHeadingTextColor;
    @Nullable
    private String mHeadingTextFontName;
    private int mHeadingTextFontSize;

    public StripeLabelCustomization() {
    }

    private StripeLabelCustomization(@NonNull Parcel in) {
        super(in);
        this.mHeadingTextColor = in.readString();
        this.mHeadingTextFontName = in.readString();
        this.mHeadingTextFontSize = in.readInt();
    }

    @Override
    public void setHeadingTextColor(@NonNull String hexColorCode) throws InvalidInputException {
        this.mHeadingTextColor = CustomizeUtils.requireValidColor(hexColorCode);
    }

    @Override
    public void setHeadingTextFontName(@NonNull String fontName) throws InvalidInputException {
        this.mHeadingTextFontName = CustomizeUtils.requireValidString(fontName);
    }

    @Override
    public void setHeadingTextFontSize(int fontSize) throws InvalidInputException {
        this.mHeadingTextFontSize = CustomizeUtils.requireValidFontSize(fontSize);
    }

    @Override
    @Nullable
    public String getHeadingTextColor() {
        return this.mHeadingTextColor;
    }

    @Override
    @Nullable
    public String getHeadingTextFontName() {
        return this.mHeadingTextFontName;
    }

    @Override
    public int getHeadingTextFontSize() {
        return this.mHeadingTextFontSize;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeLabelCustomization && this.typedEquals((StripeLabelCustomization)obj);
    }

    private boolean typedEquals(@NonNull StripeLabelCustomization labelCustomization) {
        return ObjectUtils.equals(this.mHeadingTextColor, labelCustomization.mHeadingTextColor) && ObjectUtils.equals(this.mHeadingTextFontName, labelCustomization.mHeadingTextFontName) && this.mHeadingTextFontSize == labelCustomization.mHeadingTextFontSize;
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mHeadingTextColor, this.mHeadingTextFontName, this.mHeadingTextFontSize);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mHeadingTextColor);
        dest.writeString(this.mHeadingTextFontName);
        dest.writeInt(this.mHeadingTextFontSize);
    }
}

